
<ul>
    <?php

    function arraySearch($ctrl = [], $row = []) {
        $map = dot_array_search($ctrl['tip'] . '.attr', $ctrl['configMap']) ?? [];
        $out = [];

        foreach ($map as $htmlAttr => $fieldName) {
            $out[$htmlAttr] = $row[$fieldName] ?? '';
        }

        return $out;
    }

    foreach ($ctrl['results'] as $b):
        $urlParams = http_build_query([
            'column'    => $ctrl['tip'],
            'tip'       => $ctrl['tip'],
            'primaryId' => $row['primaryId'] ?? '',
                //'oldModelValue' => addslashes($row['model'] ?? '')
        ]);

        // Генерираме атрибутите
        $attrs         = arraySearch($ctrl, $b);
        // Рендиране като HTML string
        $renderedAttrs = implode(' ', array_map(fn($k) => "{$k}=\"{$attrs[$k]}\"", array_keys($attrs)));

        $label = $b[$ctrl['label']];
        ?>
        <li class="row" <?= $renderedAttrs ?> >

            <label class="col m-0"><?= $label ?></label>

            <div class="button-group ml-auto">
                <?php if (in_array('edit', $actions)): ?>
                    <i data-route="<?= route_to('Dropdown-edit', $urlParams) ?>" class="dropdown-edit btn-outline-primary font-size-13 px-1 fa fa-edit"></i>
                <?php endif ?>

                <?php if (in_array('edit', $actions)): ?>
                    <i class="dropdown-delete btn-outline-danger font-size-13 px-1 fa fa-trash" data-route="<?= route_to('Dropdown-delete', $urlParams) ?>"></i>
                <?php endif ?>
            </div>

        </li>
    <?php endforeach ?>
</ul>

