<!DOCTYPE html>
<html lang="bg">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= esc($title ?? 'Аналитика') ?></title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
  body { background:#eef2f7; font-family: 'Inter', sans-serif; }
  .modern-sidebar {
    position:fixed; top:0; left:0; width:240px; height:100vh;
    background:linear-gradient(180deg,#0d6efd,#2563eb);
    color:#fff; padding:20px 0;
    display:flex; flex-direction:column; justify-content:space-between;
  }
  .nav-item { padding:12px 20px; display:flex; gap:10px; color:#fff; opacity:.85; text-decoration:none; }
  .nav-item.active { background:rgba(255,255,255,.2); border-left:4px solid #fff; opacity:1; }
  .nav-item:hover { background:rgba(255,255,255,.15); transform:translateX(4px); }
  .main-content { margin-left:240px; padding:2rem; }
  .kpi-box { border-radius:15px; padding:20px; color:#fff; }
  .kpi1 { background:#0d6efd; }
  .kpi2 { background:#198754; }
  .kpi3 { background:#6f42c1; }
  .kpi4 { background:#dc3545; }
  table tbody tr:hover { background:#f1f4f9; }
</style>
</head>
<body>

<!-- ==========================================================
     SIDEBAR (1:1 копиран от твоя CRM)
========================================================== -->
<aside class="modern-sidebar">
  <div>
    <div class="sidebar-logo text-center mb-3">
      <i class="fa-solid fa-chart-pie me-2"></i>Табло
    </div>

    <nav class="sidebar-nav">
         <a href="/dashboard#overview" class="nav-item active" data-target=".apps-header">
            <i class="fa-solid fa-layer-group"></i><span>Преглед</span>
          </a>
        
          <a href="/dashboard#tasks" class="nav-item" data-target=".tasks">
            <i class="fa-solid fa-list-check"></i><span>Задачи</span>
          </a>
        
          <a href="/dashboard#prihodi" class="nav-item" data-target=".prihodi">
            <i class="fa-solid fa-sack-dollar"></i><span>Приходи</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-building"></i><span>Активни</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-ban"></i><span>Неактивни</span>

      <a href="/clients" class="nav-item"><i class="fa-solid fa-users"></i>Профили</a>
      <a href="/clients/create" class="nav-item"><i class="fa-solid fa-user-plus"></i>Нов профил</a>
      <a href="/calendar" class="nav-item"><i class="fa-solid fa-calendar-days"></i>Календар</a>

      <a href="/dashboard/cashflow" class="nav-item"><i class="fa-solid fa-money-bill-transfer"></i>Разходи</a>
      <a href="/dashboard/debtors" class="nav-item"><i class="fa-solid fa-user-clock"></i>Длъжници</a>
      <a href="/refillstock" class="nav-item"><i class="fa-solid fa-boxes-packing"></i>Дозареждане</a>

      <a href="/analytics" class="nav-item active"><i class="fa-solid fa-chart-line"></i>Аналитика</a>
    </nav>
  </div>

  <div class="sidebar-bottom">
    <a href="#" class="nav-item logout"><i class="fa-solid fa-right-from-bracket"></i>Изход</a>
  </div>
</aside>


<!-- ==========================================================
     MAIN CONTENT AREA
========================================================== -->
<div class="main-content">

  <h2 class="mb-4 fw-bold">
    <i class="fa-solid fa-chart-line me-2"></i>Аналитика — Поведение на посетители
  </h2>

  <!-- KPI CARDS -->
  <div class="row g-3 mb-4">

    <div class="col-md-3">
      <div class="kpi-box kpi1">
        <h4 id="kpi_total" class="fw-bold">0</h4>
        Общо посещения
      </div>
    </div>

    <div class="col-md-3">
      <div class="kpi-box kpi2">
        <h4 id="kpi_avg_time" class="fw-bold">0s</h4>
        Среден престой
      </div>
    </div>

    <div class="col-md-3">
      <div class="kpi-box kpi3">
        <h4 id="kpi_top_product" class="fw-bold">—</h4>
        ТОП продукт
      </div>
    </div>

    <div class="col-md-3">
      <div class="kpi-box kpi4">
        <h4 id="kpi_mobile_rate" class="fw-bold">0%</h4>
        Мобилен трафик
      </div>
    </div>

  </div>


  <!-- GRAPH ROW -->
  <div class="row mb-4">

    <div class="col-md-8">
      <div class="card p-3 shadow-sm">
        <h5 class="mb-3">Топ 5 най-гледани продукта</h5>
        <canvas id="topProductsChart" height="200"></canvas>
      </div>
    </div>

    <div class="col-md-4">
      <div class="card p-3 shadow-sm">
        <h5 class="mb-3">Устройства</h5>
        <canvas id="deviceChart" height="200"></canvas>
      </div>
    </div>

  </div>


  <!-- TABLE -->
  <div class="card shadow-sm p-3">
    <h4 class="mb-3">Всички записи</h4>

    <table class="table table-hover align-middle" id="analyticsTable">
      <thead class="table-dark">
        <tr>
          <th>Страница</th>
          <th>URL</th>
          <th>Продукт</th>
          <th>Държава</th>
          <th>Устройство</th>
          <th>Престой</th>
          <th>Кликове</th>
          <th>Дата</th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>

</div>


<!-- ==========================================================
     JS — LOAD DATA + RENDER TABLE + CHARTS + KPIs
========================================================== -->
<script>
fetch('/analytics/data')
  .then(r => r.json())
  .then(rows => {

    /* ---------------- TABLE ---------------- */
    const tbody = document.querySelector('#analyticsTable tbody');
    rows.forEach(r => {
      tbody.innerHTML += `
        <tr>
          <td>${r.page}</td>
          <td><small>${r.full_url}</small></td>
          <td><b>${r.product_id ?? ''}</b></td>
          <td><span class="badge bg-primary">${r.country ?? ''}</span></td>
          <td>
            <span class="badge ${r.device === 'mobile' ? 'bg-warning' : 'bg-success'}">
              ${r.device}
            </span>
          </td>
          <td>${r.time_spent}s</td>
          <td>${r.clicks}</td>
          <td>${r.created_at}</td>
        </tr>`;
    });


    /* ---------------- KPIs ---------------- */
    document.getElementById("kpi_total").innerText = rows.length;

    // --- Среден престой ---
    if (rows.length === 0) {
        document.getElementById("kpi_avg_time").innerText = "0s";
    } else {
        const totalTime = rows.reduce((sum, r) => {
            const t = parseInt(r.time_spent);
            return sum + (isNaN(t) ? 0 : t);
        }, 0);
    
        const avgTime = Math.round(totalTime / rows.length);
        document.getElementById("kpi_avg_time").innerText = avgTime + "s";
    }


    const top = rows.sort((a,b)=>b.time_spent - a.time_spent)[0];
    document.getElementById("kpi_top_product").innerText = top?.page ?? "—";

    const mobile = rows.filter(r => r.device === 'mobile').length;
    document.getElementById("kpi_mobile_rate").innerText =
      Math.round(mobile / rows.length * 100) + "%";


    /* ---------------- TOP PRODUCTS BAR CHART ---------------- */
    let productCounts = {};
    rows.forEach(r => productCounts[r.page] = (productCounts[r.page] ?? 0) + 1);

    let labels = Object.keys(productCounts).slice(0,5);
    let data = Object.values(productCounts).slice(0,5);

    new Chart(document.getElementById("topProductsChart"), {
      type: 'bar',
      data: {
        labels,
        datasets:[{
          label:"Преглеждания",
          data,
          backgroundColor:"#0d6efd"
        }]
      }
    });


    /* ---------------- DEVICE PIE ---------------- */
    let devDesktop = rows.filter(r => r.device === "desktop").length;
    let devMobile = rows.filter(r => r.device === "mobile").length;

    new Chart(document.getElementById("deviceChart"), {
      type: 'doughnut',
      data: {
        labels:["Desktop", "Mobile"],
        datasets:[{
          data:[devDesktop, devMobile],
          backgroundColor:["#0d6efd","#ffc107"]
        }]
      }
    });

  });
</script>

</body>
</html>
