<!DOCTYPE html>
<html lang="bg">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> <?= esc($title) ?> </title>
    <!-- Bootstrap & FontAwesome -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <style>
      body {
        background-color: #f8f9fc;
        font-family: 'Inter', 'Segoe UI', sans-serif;
        color: #333;
      }

      /* === Modern Sidebar === */
      .modern-sidebar {
        position: fixed;
        top: 0;
        left: 0;
        width: 240px;
        height: 100vh;
        background: linear-gradient(180deg, #0d6efd 0%, #2563eb 100%);
        color: #fff;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        padding: 20px 0;
        box-shadow: 3px 0 15px rgba(0, 0, 0, 0.1);
        z-index: 1050;
      }

      .sidebar-top {
        display: flex;
        flex-direction: column;
        gap: 20px;
      }

      .sidebar-logo {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        font-weight: 600;
        font-size: 1.1rem;
      }

      .sidebar-nav {
        display: flex;
        flex-direction: column;
      }

      .nav-item {
        display: flex;
        align-items: center;
        gap: 10px;
        color: rgba(255, 255, 255, 0.9);
        padding: 10px 20px;
        text-decoration: none;
        transition: all 0.3s ease;
        border-left: 4px solid transparent;
        font-weight: 500;
      }

      .nav-item:hover {
        background: rgba(255, 255, 255, 0.1);
        color: #fff;
        transform: translateX(5px);
      }

      .nav-item.active {
        background: rgba(255, 255, 255, 0.15);
        border-left: 4px solid #fff;
        color: #fff;
      }

      .sidebar-bottom {
        border-top: 1px solid rgba(255, 255, 255, 0.2);
        padding-top: 10px;
      }

      .nav-item.logout {
        color: #ffcccc;
      }

      /* === Main === */
      .main-content {
        margin-left: 240px;
        padding: 2rem;
        min-height: 100vh;
        background-color: #f3f6fb;
      }

      .table thead {
        background-color: #f0f4ff;
        color: #0d6efd;
      }

      .table tbody tr:hover {
        background-color: #eef5ff;
        transition: 0.2s;
      }

      @media (max-width: 991px) {
        .modern-sidebar {
          left: -240px;
          transition: left 0.3s ease;
        }

        .modern-sidebar.show {
          left: 0;
        }

        .main-content {
          margin-left: 0;
        }
      }
    </style>
  </head>
  <body>
    <!-- 🟦 Sidebar -->
    <aside class="modern-sidebar">
      <div class="sidebar-top">
        <div class="sidebar-logo">
          <i class="fa-solid fa-chart-pie"></i>
          <span>Табло</span>
        </div>
        <nav class="sidebar-nav">
         <a href="/dashboard#overview" class="nav-item active" data-target=".apps-header">
            <i class="fa-solid fa-layer-group"></i><span>Преглед</span>
          </a>
        
          <a href="/dashboard#tasks" class="nav-item" data-target=".tasks">
            <i class="fa-solid fa-list-check"></i><span>Задачи</span>
          </a>
        
          <a href="/dashboard#prihodi" class="nav-item" data-target=".prihodi">
            <i class="fa-solid fa-sack-dollar"></i><span>Приходи</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-building"></i><span>Активни</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-ban"></i><span>Неактивни</span>
          </a>
        <a href="/clients" class="nav-item"><i class="fa-solid fa-users"></i><span>Профили</span></a>
        <a href="/clients/create" class="nav-item active"><i class="fa-solid fa-user-plus"></i><span>Нов профил</span></a>
        <a href="/calendar" class="nav-item"><i class="fa-solid fa-calendar-days"></i><span>Календар</span></a>
        <a href="/dashboard/cashflow" class="nav-item">
            <i class="fa-solid fa-money-bill-transfer"></i><span>Разходи</span>
        </a>
        
        <a href="/dashboard/debtors" class="nav-item">
            <i class="fa-solid fa-user-clock"></i><span>Длъжници</span>
        </a>
        
        
        <a href="/refillstock" class="nav-item">
            <i class="fa-solid fa-boxes-packing"></i><span>Дозареждане на стока</span>
        </a>
        
        <a href="/analytics" class="nav-item active"><i class="fa-solid fa-chart-line"></i>Аналитика</a>
        </nav>
      </div>
      <div class="sidebar-bottom">
        <a href="#" class="nav-item logout">
          <i class="fa-solid fa-right-from-bracket"></i>
          <span>Изход</span>
        </a>
      </div>
    </aside>
    <!-- 🧾 Основно съдържание -->
    <div class="main-content">
      <div class="bg-white rounded-4 shadow-sm p-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
          <h4 class="fw-bold text-primary mb-0">
            <i class="fa fa-users me-2"></i>Всички профили
          </h4>
          <a href="/clients/create" class="btn btn-primary btn-sm">
            <i class="fa fa-plus me-1"></i> Нов профил </a>
        </div> <?php if (session()->getFlashdata('success')): ?> <div class="alert alert-success small"> <?= session()->getFlashdata('success') ?> </div> <?php endif; ?> <div class="table-responsive">
          <table class="table table-hover align-middle">
            <thead>
              <tr>
                <th>#</th>
                <th>Фирма</th>
                <th>Търговец</th>
                <th>Потенциал</th>
                <th>Статус</th>
                <th class="text-end">Действия</th>
              </tr>
            </thead>
            <tbody> <?php if (!empty($clients)): ?> <?php foreach ($clients as $c): ?> <tr>
                <td> <?= $c['id'] ?> </td>
                <td> <?= esc($c['firm_name']) ?> </td>
                <td> <?= esc($c['salesperson']) ?> </td>
                <td> <?= esc($c['potential']) ?> </td>
                <td> <?= esc($c['status']) ?> </td>
                <td class="text-end">
                  <a href="/clients/preview/
														<?= $c['id'] ?>" class="btn btn-sm btn-outline-success" title="Преглед">
                    <i class="fa fa-eye"></i>
                  </a>
                  <a href="/clients/edit/
														<?= $c['id'] ?>" class="btn btn-sm btn-outline-primary" title="Редактирай">
                    <i class="fa fa-pen"></i>
                  </a>
                  <button class="btn btn-sm btn-outline-danger" title="Изтрий" data-bs-toggle="modal" data-bs-target="#deleteModal" data-client-id="
														<?= $c['id'] ?>" data-client-name="
														<?= esc($c['firm_name']) ?>">
                    <i class="fa fa-trash"></i>
                  </button>
                </td>
              </tr> <?php endforeach; ?> <?php else: ?> <tr>
                <td colspan="6" class="text-center text-muted">Няма добавени профили.</td>
              </tr> <?php endif; ?> </tbody>
          </table>
        </div>
      </div>
    </div>
    <!-- 🗑️ Модал за изтриване -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow">
          <div class="modal-header bg-danger bg-opacity-10 border-0">
            <h5 class="modal-title text-danger" id="deleteModalLabel">
              <i class="fa fa-triangle-exclamation me-2"></i>Потвърди изтриване
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Затвори"></button>
          </div>
          <div class="modal-body"> Сигурни ли сте, че искате да изтриете клиента <strong id="clientName"></strong>? </div>
          <div class="modal-footer border-0">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Откажи</button>
            <a href="#" id="confirmDeleteBtn" class="btn btn-danger">Да, изтрий</a>
          </div>
        </div>
      </div>
    </div>
    <script>
      const deleteModal = document.getElementById('deleteModal');
      deleteModal.addEventListener('show.bs.modal', event => {
        const button = event.relatedTarget;
        const clientId = button.getAttribute('data-client-id');
        const clientName = button.getAttribute('data-client-name');
        document.getElementById('clientName').textContent = clientName;
        document.getElementById('confirmDeleteBtn').href = '/clients/delete/' + clientId;
      });
    </script>
  </body>
</html>