<!DOCTYPE html>
<html lang="bg">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?= esc($title) ?></title>

  <!-- Bootstrap & FontAwesome -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <style>
    body {
      background-color: #f8f9fc;
      font-family: 'Inter', 'Segoe UI', sans-serif;
      color: #333;
    }

    .modern-sidebar {
      position: fixed;
      top: 0;
      left: 0;
      width: 240px;
      height: 100vh;
      background: linear-gradient(180deg, #0d6efd 0%, #2563eb 100%);
      color: #fff;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
      padding: 20px 0;
      box-shadow: 3px 0 15px rgba(0, 0, 0, 0.1);
      z-index: 1050;
    }

    .sidebar-logo {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 8px;
      font-weight: 600;
      font-size: 1.1rem;
    }

    .nav-item {
      display: flex;
      align-items: center;
      gap: 10px;
      color: rgba(255, 255, 255, 0.9);
      padding: 10px 20px;
      text-decoration: none;
      transition: all 0.3s ease;
      border-left: 4px solid transparent;
      font-weight: 500;
    }

    .nav-item:hover {
      background: rgba(255, 255, 255, 0.1);
      color: #fff;
      transform: translateX(5px);
    }

    .nav-item.active {
      background: rgba(255, 255, 255, 0.15);
      border-left: 4px solid #fff;
      color: #fff;
    }

    .main-content {
      margin-left: 240px;
      padding: 2rem;
      background-color: #f3f6fb;
      min-height: 100vh;
    }

    .card-form {
      background: #fff;
      border-radius: 1rem;
      box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);
      padding: 2rem;
    }

    @media (max-width: 991px) {
      .modern-sidebar { left: -240px; transition: left 0.3s ease; }
      .modern-sidebar.show { left: 0; }
      .main-content { margin-left: 0; }
    }
  </style>
</head>
<body>
  <!-- Sidebar -->
  <aside class="modern-sidebar">
    <div class="sidebar-top">
      <div class="sidebar-logo">
        <i class="fa-solid fa-chart-pie"></i><span>Табло</span>
      </div>
      <nav class="sidebar-nav">
         <a href="/dashboard#overview" class="nav-item active" data-target=".apps-header">
            <i class="fa-solid fa-layer-group"></i><span>Преглед</span>
          </a>
        
          <a href="/dashboard#tasks" class="nav-item" data-target=".tasks">
            <i class="fa-solid fa-list-check"></i><span>Задачи</span>
          </a>
        
          <a href="/dashboard#prihodi" class="nav-item" data-target=".prihodi">
            <i class="fa-solid fa-sack-dollar"></i><span>Приходи</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-building"></i><span>Активни</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-ban"></i><span>Неактивни</span>
          </a>
        <a href="/clients" class="nav-item"><i class="fa-solid fa-users"></i><span>Профили</span></a>
        <a href="/clients/create" class="nav-item active"><i class="fa-solid fa-user-plus"></i><span>Нов профил</span></a>
        <a href="/calendar" class="nav-item"><i class="fa-solid fa-calendar-days"></i><span>Календар</span></a>
        <a href="/dashboard/cashflow" class="nav-item">
            <i class="fa-solid fa-money-bill-transfer"></i><span>Разходи</span>
        </a>
        
        <a href="/dashboard/debtors" class="nav-item">
            <i class="fa-solid fa-user-clock"></i><span>Длъжници</span>
        </a>
        
        
        <a href="/refillstock" class="nav-item">
            <i class="fa-solid fa-boxes-packing"></i><span>Дозареждане на стока</span>
        </a>
        
        <a href="/analytics" class="nav-item active"><i class="fa-solid fa-chart-line"></i>Аналитика</a>
      </nav>
    </div>
    <div class="sidebar-bottom">
      <a href="#" class="nav-item logout"><i class="fa-solid fa-right-from-bracket"></i><span>Изход</span></a>
    </div>
  </aside>

  <!-- Main -->
  <div class="main-content">
    <div class="card-form">
<div class="d-flex justify-content-between align-items-center mb-4">
  <h3 class="text-primary mb-0">
    <i class="fa-solid fa-building me-2"></i>
    <?= isset($client) ? 'Редакция на профил' : 'Добавяне на профил' ?>
  </h3>

  <a href="/clients/create" class="btn btn-primary" title="Нова фирма">
    <i class="fa-solid fa-plus me-1"></i> Нова фирма
  </a>
</div>

      <form method="post" action="<?= isset($client) ? '/clients/update/'.$client['id'] : '/clients/save' ?>" class="row g-3">
          
        <div class="col-md-6 position-relative">
          <label class="form-label fw-semibold">Фирма *</label>
          <div class="input-group">
            <select id="firmSelect" name="firm_name" class="form-select" required>
              <option value="">Зареждане...</option>
            </select>
            <button class="btn btn-outline-secondary" type="button" onclick="loadFirms()">
              <i class="fa fa-rotate"></i>
            </button>
          </div>
          <input type="text" id="firmSearch" class="form-control mt-2" placeholder="🔍 Търси фирма...">
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Потенциал</label>
          <div class="input-group">
            <select name="potential" id="potential" class="form-select">
              <?php foreach ($potentials ?? [] as $p): ?>
                <option value="<?= esc($p['name']) ?>" <?= (isset($client) && $client['potential'] == $p['name']) ? 'selected' : '' ?>><?= esc($p['name']) ?></option>
              <?php endforeach; ?>
            </select>
            <button type="button" class="btn btn-outline-secondary" onclick="openAddModal('potential')"><i class="fa fa-plus"></i></button>
          </div>
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Основна дейност</label>
          <div class="input-group">
            <select name="activity" id="activity" class="form-select">
              <?php foreach ($activities ?? [] as $a): ?>
                <option value="<?= esc($a['name']) ?>" <?= (isset($client) && $client['activity'] == $a['name']) ? 'selected' : '' ?>><?= esc($a['name']) ?></option>
              <?php endforeach; ?>
            </select>
            <button type="button" class="btn btn-outline-secondary" onclick="openAddModal('activity')"><i class="fa fa-plus"></i></button>
          </div>
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Статус</label>
          <div class="input-group">
            <select name="status" id="status" class="form-select">
              <?php foreach ($statuses ?? [] as $s): ?>
                <option value="<?= esc($s['name']) ?>" <?= (isset($client) && $client['status'] == $s['name']) ? 'selected' : '' ?>><?= esc($s['name']) ?></option>
              <?php endforeach; ?>
            </select>
            <button type="button" class="btn btn-outline-secondary" onclick="openAddModal('status')"><i class="fa fa-plus"></i></button>
          </div>
        </div>

        <div class="col-12">
          <label class="form-label fw-semibold">Основни продукти които предлага</label>
          <div class="input-group">
            <select name="products" id="products" class="form-select">
              <?php foreach ($products ?? [] as $p): ?>
                <option value="<?= esc($p['name']) ?>" <?= (isset($client) && $client['products'] == $p['name']) ? 'selected' : '' ?>><?= esc($p['name']) ?></option>
              <?php endforeach; ?>
            </select>
            <button type="button" class="btn btn-outline-primary" onclick="openProductsManager()"><i class="fa fa-gear"></i></button>
          </div>
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Основно лице за контакт и телефон</label>
          <input type="text" name="contact" class="form-control" value="<?= esc($client['contact'] ?? '') ?>">
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Тип ФИРМА</label>
          <select name="client_type" class="form-select">
            <?php $types = ['Малка фирма', 'Средна фирма', 'Голяма фирма']; ?>
            <?php foreach ($types as $t): ?>
              <option value="<?= $t ?>" <?= (isset($client) && $client['client_type'] == $t) ? 'selected' : '' ?>><?= $t ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Търговец (агент)</label>
          <select name="salesperson" class="form-select">
            <?php foreach ($agents ?? [] as $a): ?>
              <option value="<?= esc($a['agent']) ?>" <?= (isset($client) && $client['salesperson'] == $a['agent']) ? 'selected' : '' ?>><?= esc($a['agent']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="col-12">
          <label class="form-label fw-semibold">Особености</label>
          <textarea name="notes" class="form-control" rows="3"><?= esc($client['notes'] ?? '') ?></textarea>
        </div>

        <div class="col-12 text-end">
          <button type="submit" class="btn btn-primary"><i class="fa fa-save me-1"></i><?= isset($client) ? 'Обнови клиента' : 'Запази и прегледай' ?></button>
          <a href="/clients" class="btn btn-outline-secondary ms-2"><i class="fa fa-arrow-left me-1"></i>Назад</a>
        </div>
      </form>
    </div>
  </div>

  <!-- 🧩 Modal: Управление на продукти -->
  <div class="modal fade" id="productsModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Управление на продукти</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <ul id="productList" class="list-group"></ul>
          <div class="input-group mt-3">
            <input type="text" id="newProductName" class="form-control" placeholder="Нов продукт...">
            <button class="btn btn-success" onclick="addProduct()">Добави</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- 📦 JS -->
  <script>
  function openAddModal(type) {
    document.getElementById('optionType').value = type;
    document.getElementById('optionName').value = '';
    new bootstrap.Modal(document.getElementById('addOptionModal')).show();
  }

  async function saveOption() {
    const type = document.getElementById('optionType').value;
    const name = document.getElementById('optionName').value.trim();
    if (!name) return alert('Моля, въведи стойност!');
    const res = await fetch('/clients/addOption', {
      method: 'POST',
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: `type=${encodeURIComponent(type)}&name=${encodeURIComponent(name)}`
    });
    const data = await res.json();
    if (data.success) {
      const select = document.getElementById(type);
      const opt = new Option(data.name, data.name, true, true);
      select.add(opt);
      bootstrap.Modal.getInstance(document.getElementById('addOptionModal')).hide();
    } else alert(data.error || 'Грешка при записа');
  }

  async function openProductsManager() {
    const modal = new bootstrap.Modal(document.getElementById('productsModal'));
    modal.show();
    await loadProducts();
  }

  async function loadProducts() {
    const res = await fetch('/clients/products');
    const list = await res.json();
    const ul = document.getElementById('productList');
    ul.innerHTML = '';
    list.forEach(p => {
      const li = document.createElement('li');
      li.className = 'list-group-item d-flex justify-content-between align-items-center';
      li.innerHTML = `
        <input class="form-control form-control-sm me-2 flex-grow-1" value="${p.name}" onchange="editProduct(${p.id}, this.value)">
        <button class="btn btn-sm btn-outline-danger" onclick="deleteProduct(${p.id})"><i class="fa fa-trash"></i></button>
      `;
      ul.appendChild(li);
    });
  }

  async function addProduct() {
    const name = document.getElementById('newProductName').value.trim();
    if (!name) return alert('Въведи име!');
    const res = await fetch('/clients/products', {
      method: 'POST',
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: `name=${encodeURIComponent(name)}`
    });
    const data = await res.json();
    if (data.success) {
      document.getElementById('newProductName').value = '';
      await loadProducts();
      refreshProductSelect();
    } else alert(data.error);
  }

async function editProduct(id, name) {
  const res = await fetch('/clients/products', {
    method: 'PUT',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: `id=${encodeURIComponent(id)}&name=${encodeURIComponent(name)}`
  });
  const data = await res.json();
  if (!data.success) { alert(data.error || 'Грешка при редакция'); return; }
  refreshProductSelect();
}

async function deleteProduct(id) {
  if (!confirm('Изтриване на продукта?')) return;

  const res = await fetch('/clients/products', {
    method: 'DELETE',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: `id=${encodeURIComponent(id)}`
  });
  const data = await res.json();
  if (!data.success) { alert(data.error || 'Грешка при изтриване'); return; }

  await loadProducts();
  refreshProductSelect();
}


  async function deleteProduct(id) {
    if (!confirm('Изтриване на продукта?')) return;
    await fetch('/clients/products?id=' + id, { method: 'DELETE' });
    await loadProducts();
    refreshProductSelect();
  }

  async function refreshProductSelect() {
    const res = await fetch('/clients/products');
    const list = await res.json();
    const select = document.getElementById('products');
    select.innerHTML = '';
    list.forEach(p => {
      const opt = new Option(p.name, p.name);
      select.add(opt);
    });
  }
  </script>
  

<style>
.shortcut-add-client {
  position: fixed;
  bottom: 30px;
  right: 30px;
  width: 60px;
  height: 60px;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 1.4rem;
  z-index: 2000;
  transition: all 0.3s ease;
  background: #0d6efd;
}
.shortcut-add-client:hover {
  transform: scale(1.1);
  background: #0b5ed7;
}
</style>

<script>
async function loadFirms() {
  const res = await fetch('/clients/searchFirms');
  const data = await res.json();
  const select = document.getElementById('firmSelect');
  select.innerHTML = '<option value="">Избери фирма...</option>';
  data.forEach(f => {
    const opt = new Option(f.text, f.text);
    select.add(opt);
  });
}

// зареждаме фирмите и активираме търсенето
document.addEventListener('DOMContentLoaded', async () => {
  await loadFirms();

  const search = document.getElementById('firmSearch');
  const select = document.getElementById('firmSelect');

  search.addEventListener('input', () => {
    const term = search.value.toLowerCase();
    Array.from(select.options).forEach(opt => {
      if (opt.value === '') return;
      opt.style.display = opt.text.toLowerCase().includes(term) ? 'block' : 'none';
    });
  });
});
</script>

<!-- Modal за добавяне на нова опция (activity, potential, status) -->
<div class="modal fade" id="addOptionModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      
      <div class="modal-header">
        <h5 class="modal-title">Добавяне на стойност</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <input type="hidden" id="optionType">

        <label class="form-label">Име</label>
        <input type="text" id="optionName" class="form-control" placeholder="Въведи стойност...">
      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Затвори</button>
        <button type="button" class="btn btn-primary" onclick="saveOption()">Запази</button>
      </div>

    </div>
  </div>
</div>
</body>
</html>

