<!DOCTYPE html>
<html lang="bg">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Календар • ERP / CRM</title>

<!-- Bootstrap / FontAwesome -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- FullCalendar -->
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<style>
/* -------- Layout -------- */
body {
    background-color: #f8f9fc;
    font-family: 'Inter', 'Segoe UI', sans-serif;
}

/* Sidebar */
.modern-sidebar {
    position: fixed;
    top: 0; left: 0;
    width: 240px;
    height: 100vh;
    background: linear-gradient(180deg, #0d6efd 0%, #2563eb 100%);
    color: #fff;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    padding: 20px 0;
    box-shadow: 3px 0 15px rgba(0,0,0,.1);
}
.sidebar-nav a {
    padding: 12px 22px;
    color: rgba(255,255,255,0.92);
    text-decoration: none;
    font-weight: 500;
    display: flex;
    gap: 10px;
}
.sidebar-nav a:hover {
    background: rgba(255,255,255,0.12);
    color: #fff;
}
.sidebar-nav a.active {
    background: rgba(255,255,255,0.20);
    border-left: 4px solid #fff;
}

/* Main content */
.main-content {
    margin-left: 240px;
    padding: 2rem;
}

/* Calendar card */
.card {
    border-radius: 1rem;
    background: #fff;
    padding: 2rem;
    box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    border: none;
}

/* Calendar event styles */
.fc-event {
    border: none !important;
    border-radius: 8px !important;
    padding: 4px 8px !important;
    font-weight: 600 !important;
}
/* ===== STATUS COLORS ===== */
select#status option[value="НОВА"] {
    color: #0d6efd;
}
select#status option[value="В ПРОЦЕС НА РАБОТА"] {
    color: #fd7e14;
}
select#status option[value="ЗАВЪРШЕНА"] {
    color: #198754;
}
select#status option[value="НЕЗАВЪРШЕНА"] {
    color: #dc3545;
}

/* ===== PRIORITY COLORS ===== */
select#prioritet option[value="Висок"] {
    color: #dc3545;
}
select#prioritet option[value="Нормален"] {
    color: #0d6efd;
}
select#prioritet option[value="Нисък"] {
    color: #198754;
}
</style>
</head>

<body>

<!-- Sidebar -->
<aside class="modern-sidebar">
    <div class="sidebar-top">
        <div class="sidebar-logo text-center fw-bold" style="margin-bottom:30px;">
            <i class="fa-solid fa-chart-pie me-1"></i> Табло
        </div>
        <nav class="sidebar-nav">
         <a href="/dashboard#overview" class="nav-item active" data-target=".apps-header">
            <i class="fa-solid fa-layer-group"></i><span>Преглед</span>
          </a>
        
          <a href="/dashboard#tasks" class="nav-item" data-target=".tasks">
            <i class="fa-solid fa-list-check"></i><span>Задачи</span>
          </a>
        
          <a href="/dashboard#prihodi" class="nav-item" data-target=".prihodi">
            <i class="fa-solid fa-sack-dollar"></i><span>Приходи</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-building"></i><span>Активни</span>
          </a>
        
          <a href="/dashboard#firms" class="nav-item" data-target=".active-firms">
            <i class="fa-solid fa-ban"></i><span>Неактивни</span>
          </a>
            <a href="/clients"><i class="fa-solid fa-users"></i>Профили</a>
            <a href="/clients/create"><i class="fa-solid fa-user-plus"></i>Нов профил</a>
            <a class="active" href="/calendar"><i class="fa-solid fa-calendar-days"></i>Календар</a>
            <a href="/dashboard/cashflow"><i class="fa-solid fa-money-bill-transfer"></i>Разходи</a>
            <a href="/dashboard/debtors"><i class="fa-solid fa-user-clock"></i>Длъжници</a>
            <a href="/refillstock"><i class="fa-solid fa-boxes-packing"></i>Дозареждане</a>
            <a href="/analytics"><i class="fa-solid fa-chart-line"></i>Аналитика</a>
        </nav>
    </div>
</aside>

<!-- Main -->
<div class="main-content">
    <div class="card shadow-lg">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="fw-bold text-primary"><i class="fa-solid fa-calendar-check me-2"></i>Календар на задачите</h4>

        </div>
        <div id="calendar"></div>
    </div>
</div>

<!-- 🟩 Modal: Добавяне на нова задача -->
<div class="modal fade" id="addTaskModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content border-0 shadow-lg rounded-4">

      <div class="modal-header bg-primary bg-opacity-10 border-0">
        <h5 class="modal-title fw-bold text-primary">
          <i class="fa-solid fa-list-check me-2"></i>Задача
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
<form id="taskForm" class="row g-3">

<input type="hidden" id="taskId">

<!-- Фирма -->
<div class="col-md-6">
    <label class="form-label fw-semibold">Фирма <span class="text-danger">*</span></label>
    <select id="firmSelect" class="form-select form-select-sm" required>
        <option value="">Избери фирма</option>
    </select>
</div>

<!-- Потребител -->
<div class="col-md-6">
    <label class="form-label fw-semibold">Потребител <span class="text-danger">*</span></label>
    <select id="taskUserSelect" class="form-select form-select-sm" required>
        <option value="">Избери потребител</option>
    </select>
</div>

<!-- Град -->
<div class="col-md-4">
    <label class="form-label fw-semibold">Град <span class="text-danger">*</span></label>
    <input type="text" id="grad" class="form-control form-control-sm" required>
</div>

<!-- Адрес -->
<div class="col-md-4">
    <label class="form-label fw-semibold">Адрес <span class="text-danger">*</span></label>
    <input type="text" id="adres" class="form-control form-control-sm" required>
</div>

<!-- Телефон -->
<div class="col-md-4">
    <label class="form-label fw-semibold">Телефон <span class="text-danger">*</span></label>
    <input type="text" id="tel" class="form-control form-control-sm" required>
</div>

<!-- Дати -->
<div class="col-md-6">
    <label class="form-label fw-semibold">Начална дата</label>
    <input type="text" id="startDate" class="form-control form-control-sm date-picker" >
</div>

<div class="col-md-6">
    <label class="form-label fw-semibold">Крайна дата</label>
    <input type="text" id="endDate"   class="form-control form-control-sm date-picker" >

</div>

<!-- Приоритет -->
<div class="col-md-6">
    <label class="form-label fw-semibold">Приоритет</label>
    <select id="prioritet" class="form-select form-select-sm">
        <option value="Нормален">◼ Нормален</option>
        <option value="Висок">◼ Висок</option>
        <option value="Нисък">◼ Нисък</option>
    </select>
</div>

<!-- Оферта -->
<div class="col-md-3">
    <label class="form-label fw-semibold">Оферта №</label>
    <input type="text" id="oferta" class="form-control form-control-sm">
</div>

<!-- Стойност -->
<div class="col-md-3">
    <label class="form-label fw-semibold">Стойност на проекта</label>
    <input type="number" id="projectValue" class="form-control form-control-sm" step="0.01">
</div>

<!-- Документ -->
<div class="col-md-6">
    <label class="form-label fw-semibold">Документ към проекта</label>
    <input type="text" id="document" class="form-control form-control-sm" placeholder="Фактура / Протокол">
</div>

<!-- Описание -->
<div class="col-12">
    <label class="form-label fw-semibold">Описание <span class="text-danger">*</span></label>
    <textarea id="description" rows="3" class="form-control form-control-sm" required></textarea>
</div>

<!-- Коментар -->
<div class="col-12">
    <label class="form-label fw-semibold">Коментар</label>
    <textarea id="comment" rows="2" class="form-control form-control-sm"></textarea>
</div>

<!-- Статус -->
<div class="col-md-6">
    <label class="form-label fw-semibold">Статус</label>
    <select id="status" class="form-select form-select-sm">
        <option value="НОВА">НОВА</option>
        <option value="В ПРОЦЕС НА РАБОТА">В ПРОЦЕС НА РАБОТА</option>
        <option value="ЗАВЪРШЕНА">ЗАВЪРШЕНА</option>
        <option value="НЕЗАВЪРШЕНА">НЕЗАВЪРШЕНА</option>
    </select>
</div>

<div class="col-12 text-end mt-3">
    <button type="submit" class="btn btn-success btn-sm px-4">
        <i class="fa fa-save me-1"></i>Запази задача
    </button>
</div>

</form>

      </div>

    </div>
  </div>
</div>


<script>
const firmSelect     = document.getElementById("firmSelect");
const taskUserSelect = document.getElementById("taskUserSelect");
const status         = document.getElementById("status");
const prioritet      = document.getElementById("prioritet");
function applySelectColor(select) {
    select.style.color = select.options[select.selectedIndex].style.color;
}

status.addEventListener("change", () => applySelectColor(status));
prioritet.addEventListener("change", () => applySelectColor(prioritet));


function toISO(dateDMY) {
  if (!dateDMY) return "";
  const [d, m, y] = dateDMY.split("/");
  return `${y}-${m}-${d}`;
}

function fromISO(dateISO) {
  if (!dateISO) return "";
  const [y, m, d] = dateISO.split("-");
  return `${d}/${m}/${y}`;
}


/* ========================================================================
   CREATE / UPDATE TASK
======================================================================== */
function buildTask({ taskId = null }) {
  return {
    id: taskId || Date.now().toString(),
    firm: firmSelect.value,
    user: taskUserSelect.value,
    grad: grad.value,
    adres: adres.value,
    tel: tel.value,
    startDate: toISO(startDate.value) || new Date().toISOString().split("T")[0],
    endDate: toISO(endDate.value),
    prioritet: prioritet.value,
    oferta: oferta.value,
    projectValue: projectValue.value,
    document: document.value,
    description: description.value,
    comment: comment.value,
    status: status.value || "НОВА"
  };
}
document.getElementById("taskForm").addEventListener("submit", function (e) {
    e.preventDefault();

    const taskId = document.getElementById("taskId").value || Date.now().toString();

    const task = {
        id: taskId,
        firm: firmSelect.value,
        user: taskUserSelect.value,
        grad: grad.value,
        adres: adres.value,
        tel: tel.value,
        startDate: toISO(startDate.value),
        endDate: toISO(endDate.value),
        prioritet: prioritet.value,
        oferta: oferta.value,
        projectValue: projectValue.value,
        document: document.value,
        description: description.value,
        comment: comment.value,
        status: status.value
    };

    // Update existing or add new
    const index = tasks.findIndex(t => t.id === taskId);
    if (index !== -1) {
        tasks[index] = task;
    } else {
        tasks.push(task);
    }

    saveTasks();
    renderCalendar();

    bootstrap.Modal.getInstance(
        document.getElementById("addTaskModal")
    ).hide();
});
/* ========================================================================  
    STORAGE
========================================================================= */
let tasks = JSON.parse(localStorage.getItem("tasks") || "[]");
const saveTasks = () => localStorage.setItem("tasks", JSON.stringify(tasks));

/* ========================================================================  
    HELPERS
========================================================================= */
function daysBetween(d1, d2) {
    return Math.ceil((d2 - d1) / 86400000);
}


/* ========================================================================  
    FIRMS & USERS
========================================================================= */
let pendingFirm = null;
let pendingUser = null;

function loadFirmsTask() {
    fetch("/dashboard/loadFirmsFromDB")
        .then(r => r.json())
        .then(data => {
            firmSelect.innerHTML = `<option value="">Избери фирма</option>`;

            data.forEach(f => {
                firmSelect.innerHTML += `
                    <option value="${f.klient_name}"
                        data-grad="${f.klient_grad || ''}"
                        data-adres="${f.klient_adres || ''}"
                        data-tel="${f.klient_tel || ''}">
                        ${f.klient_name}
                    </option>`;
            });

            if (pendingFirm) {
                firmSelect.value = pendingFirm;
                firmSelect.dispatchEvent(new Event("change"));
                pendingFirm = null;
            }
        });
}

function loadUsersTask() {
    fetch("/dashboard/loadUsers")
        .then(r => r.json())
        .then(users => {
            taskUserSelect.innerHTML = `<option value="">Избери потребител</option>`;

            users.forEach(u => {
                const name = `${u.first_name} ${u.last_name}`;
                taskUserSelect.innerHTML += `<option value="${name}">${name}</option>`;
            });

            if (pendingUser) {
                taskUserSelect.value = pendingUser;
                pendingUser = null;
            }
        });
}



// Авто-попълване
document.getElementById("firmSelect").addEventListener("change", function () {
    const o = this.selectedOptions[0];
    grad.value = o.dataset.grad || "";
    adres.value = o.dataset.adres || "";
    tel.value = o.dataset.tel || "";
});

loadFirmsTask();
loadUsersTask();

/* ========================================================================  
    CALENDAR
========================================================================= */
let calendar;

function getEventColor(task) {
    const today = new Date();
    const end = task.endDate ? new Date(task.endDate) : null;

    if (task.status === "ЗАВЪРШЕНА") return "#198754";      // зелено
    if (task.status === "В ПРОЦЕС НА РАБОТА") return "#fd7e14"; // оранжево
    if (task.status === "НЕЗАВЪРШЕНА") return "#dc3545";   

    if (end && end < today) return "#dc3545"; 
    return "#0d6efd"; // нова
}
function renderCalendar() {
  calendar.removeAllEvents();

  const tasks = JSON.parse(localStorage.getItem("tasks") || "[]");

  tasks.forEach(task => {
    if (!task.startDate) return; // ❗ КЛЮЧОВО

    calendar.addEvent({
      id: task.id,
      title: `${task.firm} — ${task.status || "НОВА"}`,
      start: task.startDate,
      color: getEventColor(task),
      textColor: "#fff",
      extendedProps: { fullTask: task }
    });
  });
}


/* ========================================================================  
    FORM HANDLING
========================================================================= */
let pendingStatus = null;

function fillForm(task) {
    taskId.value = task.id;

    pendingFirm = task.firm;
    pendingUser = task.user;
    pendingStatus = task.status || "НОВА";

    adres.value = task.adres;
    tel.value = task.tel;

    startDate.value = fromISO(task.startDate);
    endDate.value = fromISO(task.endDate);

    prioritet.value = task.prioritet || "Нормален";
    oferta.value = task.oferta || "";
    projectValue.value = task.projectValue || "";
    document.value = task.document || "";
    description.value = task.description;
    comment.value = task.comment || "";

    loadFirmsTask();
    loadUsersTask();
    applySelectColor(status);
applySelectColor(prioritet);
}

function getDeadlineText(task) {
    if (task.status === "ЗАВЪРШЕНА") {
        return "✅ Задачата е завършена";
    }

    if (!task.endDate) {
        return "ℹ️ Няма крайна дата";
    }

    const today = new Date();
    const end = new Date(task.endDate);

    const diffDays = Math.ceil((end - today) / 86400000);

    if (diffDays > 0) {
        return `⏳ Остават ${diffDays} дни`;
    } else if (diffDays === 0) {
        return "⚠️ Краен срок: ДНЕС";
    } else {
        return `❌ Просрочено с ${Math.abs(diffDays)} дни`;
    }
}
/* ========================================================================  
    INIT
========================================================================= */
document.addEventListener("DOMContentLoaded", () => {

    calendar = new FullCalendar.Calendar(document.getElementById("calendar"), {
        initialView: "dayGridMonth",
        locale: "bg",
    

        dateClick(info) {
            document.getElementById("taskForm").reset();
            document.getElementById("taskId").value = "";
    
            document.getElementById("startDate").value = fromISO(info.dateStr);
            document.getElementById("endDate").value = "";
    
            new bootstrap.Modal(
                document.getElementById("addTaskModal")
            ).show();
        },
    
        /* =========================
           КЛИК ВЪРХУ СЪБИТИЕ
        ========================= */
        eventClick(info) {
            fillForm(info.event.extendedProps.fullTask);
    
            const modalEl = document.getElementById("addTaskModal");
            const modal = new bootstrap.Modal(modalEl);
            modal.show();
    
            modalEl.addEventListener("shown.bs.modal", () => {
                status.value = pendingStatus || "НОВА";
            }, { once: true });
        },
    

        eventDidMount(info) {
            const task = info.event.extendedProps.fullTask;
            if (!task) return;
        
            const tooltipText =
        `${task.firm}
        Статус: ${task.status}
        Приоритет: ${task.prioritet}
        ${getDeadlineText(task)}`;
        
            new bootstrap.Tooltip(info.el, {
                title: tooltipText,
                placement: "top",
                trigger: "hover",
                container: "body",
                html: false
            });
        }

    });

    calendar.render();
    renderCalendar();
});

</script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/bg.js"></script>

<script>
document.addEventListener("DOMContentLoaded", () => {
  flatpickr(".date-picker", {
    locale: "bg",
    dateFormat: "d/m/Y",
    allowInput: false,
    disableMobile: true
  });
});
</script>
</body>
</html>
