<!DOCTYPE html>
<html>

    <head> 
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Потребители</title>

        <link href="<?php echo base_url() ?>assets/bootstrap/css/bootstrap.min.css" rel="stylesheet">
        <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
        <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/bs/dt-1.10.18/fh-3.1.4/r-2.2.2/sc-1.5.0/sl-1.2.6/datatables.min.css"/>
        <link href="<?php echo base_url() ?>assets/css/navbar/navbar.css" rel="stylesheet">
        <link href="<?php echo base_url() ?>assets/css/login/userList.css" rel="stylesheet">

        <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
          <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
          <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

    </head> 

    <body>

        <?php echo isset($header) ? $header : '' ?>

        <div class="container">
            <br><br>
            <div id="infoMessage"><?php echo $message; ?></div>

            <h4 style="float:right;">СПИСЪК ПОТРЕБИТЕЛИ</h4>

            <ul class="nav nav-tabs" role="tablist">
                <li class="active">
                    <a  data-toggle="tab" aria-expanded="true" >Потребители</a>
                </li>
                <li>
                    <a  data-toggle="tab" aria-expanded="false" >Групи</a>
                </li>
            </ul>

            <div class="tab-content">
                <div class="tab-pane active" id="tab-users"> 

                    <table id="tbl_users" class="table table-striped table-bordered" cellpadding=0 cellspacing=10 >
                        <thead>
                            <tr>
                                <th class="username"><?php echo lang('Auth.index_username_th'); ?></th>
                                <th class="fname"><?php echo lang('Auth.index_fname_th'); ?></th>
<!--                             <th><?php //echo lang('Auth.index_lname_th');                                                   ?></th>-->
                                <th class="email"><?php echo lang('Auth.index_email_th'); ?></th>
                                <th class="groups"><?php echo lang('Auth.index_groups_th'); ?></th>
                                <th class="status"><?php echo lang('Auth.index_status_th'); ?></th>
                                <th class="no-sort"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $user): ?>
                                <tr>
                                    <td class="td_username"><?php echo htmlspecialchars($user -> username, ENT_QUOTES, 'UTF-8'); ?></td>
                                    <td class="td_username"><?php echo htmlspecialchars($user -> first_name, ENT_QUOTES, 'UTF-8'); ?></td>
    <!--                                    <td class="td_lastname"><?php //echo htmlspecialchars($user -> last_name, ENT_QUOTES, 'UTF-8');                                                  ?></td>-->
                                    <td class="td_email"><?php echo htmlspecialchars($user -> email, ENT_QUOTES, 'UTF-8'); ?></td>
                                    <td>
                                        <?php foreach ($user -> groups as $group): ?>
                                            <?php echo htmlspecialchars($group -> name, ENT_QUOTES, 'UTF-8') ?><br />
                                        <?php endforeach ?>
                                    </td>
                                    <td><?php echo ($user -> active) ? anchor('deactivate/' . $user -> id, lang('Auth.index_active_link'), ['onclick' => 'javasciprt: return confirm(\'Сигурнили сте, че искате да деактивирате потребител - ' . $user -> username . '\')']) : anchor("activate/" . $user -> id, lang('Auth.index_inactive_link')); ?></td>
                                    <td><?php echo anchor('edit_user/' . $user -> id, '<i class="glyphicon glyphicon-edit"></i>'); ?> |
                                        <?php echo anchor('delete_user/' . $user -> id, '<i class="glyphicon glyphicon-trash"></i>', ['class' => 'delete', 'onclick' => 'javasciprt: return confirm(\'Сигурнили сте, че искате да изтриете потребител - ' . $user -> username . '\')']); ?>              
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <div class="tab-pane" id="tab-groups">
                    <br><br>

                    <table id="tbl_groups" class="table table-striped table-bordered" cellpadding=0 cellspacing=10 >
                        <thead>
                            <tr>
                                <th><?php echo lang('Auth.index_group_th'); ?></th>
                                <th class="actionBtns no-sort"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            foreach ($groups as $group):
                                ?>
                                <tr>
                                    <td class="td_group"><?php echo htmlspecialchars($group -> name, ENT_QUOTES, 'UTF-8'); ?></td>
                                    <td><?php echo anchor('edit_group/' . $group -> id, '<i class="glyphicon glyphicon-edit" title="редакция на група"></i>'); ?>
                                        <?php if ($group -> id != 1) { ?>  
                                            |
                                            <?php echo anchor('edit_groupPermisions/' . $group -> id, '<i class="glyphicon glyphicon-lock" title="редакция на права"></i>'); ?> |
                                            <?php echo anchor('delete_group/' . $group -> id, '<i class="glyphicon glyphicon-trash" title="изтриване на група"></i>', ['class' => 'delete', 'onclick' => 'javasciprt: return confirm(\'Сигурнили сте, че искате да изтриете група - ' . $group -> name . '\')']); ?>               <?php } ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>

                        </tbody>
                    </table>

                </div>




            </div>
        </div>

        <script src="/assets/plugins/_bootstrap/jquery-3.3.1.min.js"></script>
        <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/v/bs/dt-1.10.18/fh-3.1.4/r-2.2.2/sc-1.5.0/sl-1.2.6/datatables.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
        <script src="/assets/js/_Global/ajax_config.js"></script>

        <script type="text/javascript">

            $(document).ready(function ( ) {

                // времеинтервал за премахване на message
                setTimeout(function () {
                    $('#infoMessage').remove();
                }, 4000); // <-- time in milliseconds
                // 
                //datatables
                $('table').DataTable({
                    responsive: false,
                    processing: true,
                    searching: true,
                    scrollCollapse: true,
                    autoWidth: false,
                    columnDefs: [ {
                            "targets": 'no-sort',
                            "orderable": false,
                            "searchable": false,
                            "width": '10%'
                        } ],
                    // columnDefs: [ {targets: [ 5 ], width: "10% !IMPORTANT", orderable: false, searchable: false} ],
                    language: {
                        "sProcessing": "Обработка...",
                        "sLengthMenu": "Покажи _MENU_ записа",
                        "sZeroRecords": "Няма намерени резултати",
                        "sEmptyTable": "Таблицата е празна",
                        "sInfo": "общо  _TOTAL_ записа",
                        "sInfoEmpty": "",
                        "sInfoFiltered": "",
                        "sInfoPostFix": "",
                        "sSearch": "Общ филтър:",
                        "sUrl": "",
                        "sInfoThousands": ",",
                        "sLoadingRecords": "Зареждане...",
                        "oPaginate": {
                            "sFirst": "Първи",
                            "sLast": "Последен",
                            "sNext": "Напред",
                            "sPrevious": "Назад"
                        }
                    },
                    lengthMenu: [ [ 10, 25, 50, 100, -1 ], [ 10, 25, 50, 100, "Всички" ] ]

                });

                $('a[data-toggle="tab"]').on('click', function (e) {

                    if ($(this).hasClass('active')) {
                        return false;
                    }

                    // Remove class from active tab
                    $(".nav-tabs > li").removeClass("active");

                    // Add class active to clicked tab
                    $(this).closest('li').addClass("active");
                    var clickedTab = $(".nav-tabs .active").index();
                    localStorage.setItem('clickedTab', clickedTab);

                    $(".tab-content > div").removeClass("active");

                    // Add class active to corresponding tab
                    $(".tab-content  > div").eq(clickedTab).addClass("active");

                });

                if (localStorage.getItem('clickedTab') != null) {
                    $('a[data-toggle="tab"]:eq(' + parseInt(localStorage.getItem('clickedTab')) + ')').trigger('click');
                }

            });
        </script>
    </body>
</html>