<?php

namespace IonAuth\Libraries;

use Config\Database;
use Config\Services;

/**
 * Name:  Ion Auth ACL
 *
 * Version: 1.0.0
 *
 * Location: http://github.com/steve-goodwin/ion_auth_acl
 *
 * Created:  18.09.2015
 *
 * Description:  Add's ACL (access control list) based on the existing Ion Auth library for codeigniter
 *
 */
class Ion_auth_acl {

    protected $db;
    protected $session;
    protected $user_id          = FALSE;
    protected $user_permissions = array();
    protected $user_groups      = array();

    function __construct(array $config = array()) {

        $this -> db      = Database::connect();
        $this -> session = Services::session();

        //$this -> ionAuth            = new IonAuth();
        $this -> Ion_auth_acl_model = new \IonAuth\Models\Ion_auth_acl_model();

        if (count($config) > 0)
            foreach ($config as $key => $val)
                $this -> {$key} = $val;
//        else
//           // $this->user_id = ( $this->ion_auth->logged_in() ) ? $this->ion_auth->user()->row()->id : FALSE;
//
//        if ($this -> ionAuth -> loggedIn()) {
//
//
//           $this -> userID      = $this -> ionAuth -> user() -> row() -> id; //public var
//            $this -> user_groups = $this -> ionAuth -> getUsersGroups($this -> userID) -> getRow() -> id;
//            // $this->user_permissions     =   $this->build_acl();
//     
//        }
    }

    /**
     * __call
     *
     * Acts as a simple way to call model methods without loads of stupid alias'
     *
     * */
    public function __call($method, $arguments) {
        if (!method_exists($this -> Ion_auth_acl_model, $method))
            throw new \Exception('Undefined method Ion_auth_acl::' . $method . '() called');

        return call_user_func_array(array($this -> Ion_auth_acl_model, $method), $arguments);
    }

    /**
     * __get
     *
     * Enables the use of CI super-global without having to define an extra variable.
     *
     * I can't remember where I first saw this, so thank you if you are the original author. -Militis
     *
     * @access	public
     * @param	$var
     * @return	mixed
     */
    public function __get($var) {

        $var = \Config\Database::connect();
        return $var;
        // return get_instance()->$var;
    }

    public function get_permision() {
        return $this -> Ion_auth_acl_model -> get_permission();
    }

    public function get_groupPerm($groupID = FALSE) {

        return $this -> Ion_auth_acl_model -> get_group_permissions($groupID);
    }

    /**
     * Has Permission
     *
     * Checks to see if a user should be granted a permission or not.
     *
     * @author Steve Goodwin
     * @param bool|FALSE $key
     * @param array $permissions
     * @return bool
     */
    public function group_permission($groupID = '') {
        return $this -> Ion_auth_acl_model -> get_group_permissions($groupID);
    }

    // valenti84 за валидация на права на групата
    public function has_permission($groupID = FALSE, $view = [], $btns = []) {

        if (!$groupID)
            return FALSE;


        $sql = $this -> Ion_auth_acl_model -> get_group_permissions($groupID);

        if (isset($view)) {

            if (empty($view['is_single']) && !empty($view['tab'])) {
                $tab = 'tab' . ucfirst($view['tab']);
                return in_array($tab, $sql['view_tab_allowed'][$view['view']]);
            }

            if (!empty($view['is_single'])) {
                $tab = $view['tab'];

                if ($tab == 'gensoftKlient') {
                    $tab = 'klient';
                }

                return in_array($tab, $sql['view_tab_allowed'][$view['view']]);
            }


            //return in_array($tab, $sql['view_allowed']);
        }

        if (isset($btns)) {

            $btnsAllowed = match (isset($btns['arg']) && $btns['arg'] == 1) {
                true => $sql['btns_allowed'] ?? [],
                false => $sql['btns_allowed'][$btns['view']][$btns['tab']] ?? [],
            };

            return in_array($btns['btn'], $btnsAllowed);

            //return dot_array_search($searchKey, $sql['btns_allowed']);
        }
    }

    /**
     * Is Allowed
     *
     * Checks to see if a permission should be allowed.
     * $resourse  = [home.promo]
     */
    public function isAllowed($groupID = null, $view = null, $btn = null, $btn_name = null) {

        if (!$groupID) {
            return false;
        }

        $arr = $this -> has_permission($groupID, $view, $btn, $btn_name);

        return $arr === true ? true : false;
    }

    public function is_allowed($groupId, $tip, $resourceName, array|string $actions): bool {
        static $cachedPermissions = [];

        if (!$groupId || !$resourceName || !$actions) {
            return false;
        }

        // Уеднаквяване – винаги работим с масив
        $actions = (array) $actions;

        if (!array_key_exists($groupId, $cachedPermissions)) {
            $row = $this -> db -> table('groups_permissions')
                    -> select('resource')
                    -> where('group_id', $groupId)
                    -> get()
                    -> getRow();

            $cachedPermissions[$groupId] = json_decode($row?->resource ?? '[]', true);
        }

        [$view, $name] = explode('.', $resourceName) + [null, null];
        $resource = $cachedPermissions[$groupId][$tip][$view][$name] ?? [];

        if (in_array('isActive', $actions, true)) {
            return ($resource['isActive'] ?? '0') == 1;
        }

        foreach ($actions as $action) {
            if (in_array($action, $tip == 'forms' ? $resource : $resource['denyBtns'] ?? [])) {
                return true;
            }
        }

        return false;
    }

    public function is_allowed2($key = FALSE, $permissions = array()) {
        if (!$key)
            return FALSE;

        $permissions || $permissions = $this -> user_permissions;

        return ( $this -> has_permission2($key, $permissions) && !$this -> is_inherited($key, $permissions) ) ? TRUE : FALSE;
    }

    public function has_permission2($key = FALSE, $permissions = array()) {
        if (!$key)
            return FALSE;

        $permissions || $permissions = $this -> user_permissions;

        $key = strtolower($key);
        d($key);
        d($permissions);
        if (array_key_exists($key, $permissions))
            return ( $permissions[$key]['value'] === '1' || $permissions[$key]['value'] === TRUE ) ? TRUE : FALSE;
        else
            return FALSE;
    }

    /**
     * Is Deny
     *
     * Checks to see if a permission should be denied.
     *
     * @author Steve Goodwin
     * @param bool|FALSE $key
     * @param array $permissions
     * @return bool
     */
    public function is_denied($key = FALSE, $permissions = array()) {
        if (!$key)
            return FALSE;

        $permissions || $permissions = $this -> user_permissions;

        if (array_key_exists($key, $permissions))
            return ( $permissions[$key]['value'] === FALSE && $permissions[$key]['inherited'] != TRUE) ? TRUE : FALSE;
        else
            return FALSE;
    }

    /**
     * Is Inherited
     *
     * Checks to see if a permission is inherited or not.
     *
     * @author Steve Goodwin
     * @param bool|FALSE $key
     * @param array $permissions
     * @param string $sub_key
     * @return bool
     */
    public function is_inherited($key = FALSE, $permissions = array(), $sub_key = 'inherited') {
        if (!$key)
            return FALSE;

        $permissions || $permissions = $this -> user_permissions;

        if (array_key_exists($key, $permissions))
            return ( $permissions[$key][$sub_key] === TRUE ) ? TRUE : FALSE;
        else
            return FALSE;
    }

    /**
     * Изчистване на кеша за конкретна група
     */
    public function clear_cache(int $groupId): void {
        $this -> session -> remove("permissions_group_$groupId");
    }

}
