<?php

namespace IonAuth\Config;

/**
 * Name:  Ion Auth ACL
 *
 * Version: 1.0.0
 *
 * Author: Steve Goodwin
 * 		  steve@weblogics.co.uk
 *         @steveg1987
 *
 * Location: http://github.com/steve-goodwin/ion_auth_acl
 *
 * Created:  18.09.2015
 *
 * Description:  Add's ACL (access control list) based on the existing Ion Auth library for codeigniter
 *
 * Requirements: PHP5 or above
 *
 */
/*
  | -------------------------------------------------------------------------
  | Tables.
  | -------------------------------------------------------------------------
  | Database table names.
 */
class Ion_auth_acl extends \CodeIgniter\Config\BaseConfig {

    public $databaseGroupName = '';
    public $tables = [
        'permissions'        => 'permissions',
        'groups_permissions' => 'groups_permissions',
        'users_permissions'  => 'users_permissions'
    ];


    /*
      | Permissions table column and Users / Groups permissions table column's you want to join WITH.
      |
      | Joins from permissions.perm_id
     */
    public $join = [
        'permissions' => 'perm_id'
    ];

    /*
      | -------------------------------------------------------------------------
      | Authentication options.
      | -------------------------------------------------------------------------
      | Default admin permission = admin_access
     */
    public $admin_permission = "admin_access";

}

/* End of file ion_auth_acl.php */
/* Location: ./application/config/ion_auth_acl.php */
