<?php
$general           = service('settings') -> get('App.general') ?? [];
$related_generator = $general['related_generator'] ?? [];
$cfg               = $related_generator ?? [];

$f         = $cfg['rel_field'] ?? 'product_name';
$lt        = $cfg['rel_like_type'] ?? 'both';
$minTimer  = isset($cfg['min_timer']) ? (int) ($cfg['min_timer'] / 60) : 5;
$crawlTime = isset($cfg['crawl_time']) ? (int) ($cfg['crawl_time'] / 60) : 1;

$substrLen = $cfg['rel_substr_len'] ?? 10;
$limitVal  = $cfg['rel_limit'] ?? 10;

$sc = !empty($cfg['rel_same_category']);
$ss = !empty($cfg['rel_same_subcategory']);
$oa = !empty($cfg['rel_only_active']);
?>


<div class="tab-pane fade related-card" id="tab-related" role="tabpanel">

    <!-- HEADER -->
    <div class="d-flex align-items-center justify-content-center mb-4">
        <h3 class="text-primary mb-0">
            <i class="fa fa-search me-2"></i>
            Генериране на свързани продукти
        </h3>
    </div>

    <section class="px-2" style="max-height:75vh;overflow-y: auto;">
        <!-- INFO -->
        <div id="accordion" class="info-multi round-10" style="background: transparent;">
            <div class="card px-1" style="background: transparent;border: 1px solid #fff;">
                <div>
                    <h5 class="mb-0">
                        <button class="btn btn-link w-100 text-left" data-toggle="collapse" data-target="#collapseOne">
                            <i class="fa fa-info-circle"></i>
                            <span>Легенда</span>
                        </button>
                    </h5>
                </div>

                <div id="collapseOne" class="collapse" data-parent="#accordion">
                    <div class="saas-sub py-3">
                        Инструментът автоматично намира и записва <b>свързани продукти</b>,
                        като сравнява имената, кодовете или OEM номерата на продуктите
                        по интелигентен SQL алгоритъм.

                        <br><br>

                        Системата взима част от текста на основния продукт (например първите
                        10 символа от името) и търси други продукти, които съдържат същата
                        последователност от символи.

                        <br><br>

                        По този начин автоматично се откриват продукти със сходни имена,
                        модели, марки или кодове – например:
                        <br>
                        • „Брава за Ford Focus“ → ще намери други брави за Ford Focus  
                        • OEM код → ще намери продукти със същия OEM  
                        • Част от артикулен код → ще намери сходни артикули

                        <br><br>

                        Можете да контролирате как точно се прави търсенето:
                        <br>
                        • По коя колона да се сравнява (име, OEM, код и др.)  
                        • Колко символа от началото да се използват  
                        • Какъв тип LIKE сравнение да се ползва (%...%, начало, край)  
                        • Колко резултата максимум да се запишат  

                        <br><br>

                        По желание системата може да ограничи резултатите:
                        <br>
                        • Само до същата категория  
                        • Само до същата подкатегория  
                        • Само до активни продукти  

                        <br><br>

                        При натискане на „Генерирай за продукт“,
                        системата автоматично записва намерените продукти
                        в полето <b>related_products</b> на избрания продукт.

                        <br><br>

                        Функцията „Масово генериране“ обработва целия каталог
                        на части (batch), за да не натоварва сървъра и
                        автоматично създава свързани продукти за всички артикули.
                    </div>
                </div>
            </div>
        </div>

        <!-- CONFIG -->
        <div class="bg-white px-2" style="border-radius: 14px;border: 1px solid #c9c9c9;box-shadow: 2px 2px 4px #c1c1c1;">
            <div class="row saas-header config-header">
                <i class="fa fa-sliders"></i>
                <span>КОНФИГУРАЦИЯ ЗА ТЪРСЕНЕ</span>
            </div>

            <!-- ROW 1 -->
            <div class="row g-4 mb-4 mt-3">

                <div class="col-lg-4">
                    <label>Поле за търсене</label>

                    <select id="rel_field" class="css-dropdown-p css-focus-strong css-border-none w-100 py-1">
                        <option value="product_name" <?= $f == 'product_name' ? 'selected' : '' ?>>Име на продукт</option>
                        <option value="gensoft_productName" <?= $f == 'gensoft_productName' ? 'selected' : '' ?>>Име на продукт Gensoft</option>
                        <option value="oem" <?= $f == 'oem' ? 'selected' : '' ?>>Оem</option>
                        <option value="kod" <?= $f == 'kod' ? 'selected' : '' ?>>Код</option>
                    </select>

                    <small class="text-muted">Колона за сравнение</small>
                </div>

                <div class="col-lg-2">
                    <label>Брой символи</label>

                    <input type="number" id="rel_substr_len"
                           class="css-input-p css-focus-strong css-border-none"
                           value="<?= $substrLen ?>">

                    <small class="text-muted">Символи от началото</small>
                </div>

                <div class="col-lg-3">
                    <label>Начин на сравнение</label>

                    <select id="rel_like_type" class="css-dropdown-p css-focus-strong css-border-none w-100 py-1">
                        <option value="both" <?= $lt == 'both' ? 'selected' : '' ?>>Частично съвпадение</option>
                        <option value="start" <?= $lt == 'start' ? 'selected' : '' ?>>Започва с името</option>
                        <option value="end" <?= $lt == 'end' ? 'selected' : '' ?>>Завършва с името</option>
                    </select>

                    <small class="text-muted">Тип на сравнение</small>
                </div>

                <div class="col-lg-3">
                    <label>Макс. резултати</label>

                    <input type="number" id="rel_limit"
                           class="css-input-p css-focus-strong css-border-none"
                           value="<?= $limitVal ?>">

                    <small class="text-muted">SQL LIMIT</small>
                </div>

            </div>

            <!-- ROW 2 -->
            <div class="row g-4 mb-4 justify-content-between">

                <div class="col">
                    <div class="related-switch">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox"
                                   id="rel_same_category" <?= $sc ? 'checked' : '' ?>>

                            <label class="form-check-label">Само съща категория</label>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="related-switch">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox"
                                   id="rel_same_subcategory" <?= $ss ? 'checked' : '' ?>>

                            <label class="form-check-label">Само съща подкатегория</label>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="related-switch">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox"
                                   id="rel_only_active" <?= $oa ? 'checked' : '' ?>>

                            <label class="form-check-label">Само активни продукти</label>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-primary p-1 mb-2">Настройки на времевите интервали за генериране</div>

            <div class="row g-4 mb-4 align-items-center">
                <div class="col-lg-4 d-flex flex-column">
                    <label>Интервал за авт. генериране (минути)</label>

                    <input type="number" id="rel_crawl_time"
                           class="css-input-p css-focus-strong css-border-none"
                           value="<?= $crawlTime ?>">

                    <small class="text-muted">Максимално време за масово генериране</small>
                </div>

                <div class="col-lg-4 d-flex flex-column">
                    <label>Макс. време за ръчно генериране (минути)</label>

                    <input type="number" id="rel_min_timer"
                           class="css-input-p css-focus-strong css-border-none"
                           value="<?= esc($minTimer) ?>">

                    <small class="text-muted">Пауза между batch стъпките</small>
                </div>

                <div class="col-lg-4 d-flex flex-column">
                    <label>Тестови Product ID</label>

                    <input type="number"
                           id="rel_product_id"
                           class="css-input-p css-focus-strong css-border-none"
                           placeholder="Пример: 952">

                    <small class="text-muted">За единичен продукт</small>
                </div>
            </div>

            <!-- ACTION -->
            <div class="related-actions row m-auto justify-content-end">

                <div class="col-lg-4 ms-auto">
                    <button type="button"
                            id="btnGenerateForProduct"
                            class="btn btn-primary round-10 w-100"
                            data-route="<?= route_to('RelatedRules-save') ?>">
                        <i class="fa fa-save me-2"></i>
                        Запази настройките
                    </button>
                </div>

            </div>
            <div id="relStatusBox" class="d-none mt-3"></div>
        </div>


        <hr class="my-4">

        <!-- BATCH -->
        <div class="bg-white px-2 my-3" style="border-radius: 14px;border: 1px solid #c9c9c9;box-shadow: 2px 2px 4px #c1c1c1;">

            <div class="row saas-header batch-header">
                <i class="fa fa-database"></i>
                <span>МАСОВО ГЕНЕРИРАНЕ</span>
            </div>

            <div class="row g-4 justify-content-around">

                <div class="col-lg-3">
                    <label>Брой продукти наведнъж</label>

                    <input type="number" id="batch_limit"
                           class="css-input-p css-focus-strong css-border-none"
                           value="500">

                    <small class="text-muted">
                        Колко продукта да се обработят при една стъпка
                    </small>
                </div>

                <div class="col-lg-3">
                    <label>Започни от продукт №</label>

                    <input type="number" id="batch_offset"
                           class="css-input-p css-focus-strong css-border-none"
                           value="0">

                    <small class="text-muted">
                        Ползва се при продължаване след прекъсване
                    </small>
                </div>

                <div class="col-lg-4">
                    <button id="btnGenerateBatch"
                            class="btn btn-warning round-10 w-100 mb-2"
                            data-route="<?= route_to('RelatedRules-generateBatch') ?>"
                            style="height:54px; font-weight:600;">

                        <i class="fa fa-industry me-2"></i>
                        Стартирай масово генериране
                    </button>
                </div>
            </div>

            <!-- PROGRESS -->
            <div id="batchProgressBox" class="p-3 d-none" >
                <div class="fw-semibold mb-2">
                    Batch Progress
                </div>

                <div class="progress">
                    <div id="batchProgressBar"
                         class="progress-bar progress-bar-striped progress-bar-animated"
                         style="width:0%">0%
                    </div>
                </div>

                <div class="mt-2 text-muted small">
                    Offset: <span id="batchProgressOffset">0</span> |
                    Processed: <span id="batchProgressProcessed">0</span>
                </div>
            </div>

        </div>
    </section>
</div>
