<?php
$preval            = service("settings") -> get("App.general")["preval"] ?? [];
$mode              = $preval["mode"] ?? "";
$old_base_currency = $preval["old_base_currency"] ?? "--";

// Set default base currency to BGN if not defined
$preval["base_currency"] = $preval["base_currency"] ?? "BGN";

// Determine button attributes for revaluation action
// Disable if in manual mode (requires settings save first)
$btnRevalueAttr  = $mode === "manual" ? 'style="opacity: 0.5;" title="Първо трябва да запазите настройките" disabled' : "";
?>
<div class="tab-pane fade" id="tab-preval" role="tabpanel">

    <h3 class="text-primary mb-3" style="font-weight:700;">
        <i class="fa fa-exchange"></i> Превалутиране
    </h3>

    <div class="card-saas" style="background:#f9fafb;border-left:6px solid #0d6efd;">
        <div class="saas-header" style="font-size:18px;">
            <i class="fa fa-info-circle"></i> Как работи превалутирането
        </div>

        <ul style="padding-left:18px;margin-bottom:0;color:#374151;font-size:14px;line-height:1.7;">
            <li>
                <b>Основна валута</b> – валутата, в която системата съхранява всички цени.
            </li>

            <li>
                При <b>смяна на основната валута</b> всички доставни и продажни цени
                се <b>преизчисляват автоматично</b> по текущия валутен курс.
            </li>

            <li>
                <b>Автоматичен режим</b> – използва курсове от Европейската централна банка (ЕЦБ).
            </li>

            <li>
                <b>Ръчен режим</b> – въвеждате собствени курсове за превалутиране.
            </li>

            <li>
                <b>Масовото превалутиране</b> може да се изпълни <b>само веднъж</b>
                след последното запазване на настройките.
            </li>

            <li>
                След успешно превалутиране операцията се <b>заключва</b>, за да се предотвратят грешки.
            </li>

            <li>
                За да разрешите ново превалутиране, трябва отново да <b>запазите настройките</b>.
            </li>

            <li>
                При активен <b>Gensoft</b> масовото превалутиране е <b>напълно забранено</b>.
            </li>

            <li style="color:#b91c1c;">
                Внимание: Превалутирането е <b>необратима операция</b>.
            </li>
        </ul>
    </div>

    <!-- API STATUS -->
    <div class="card-saas d-flex justify-content-between align-items-center">
        <div>
            <div class="saas-header">Статус на валутното API</div>
            <div id="apiStatusText" class="saas-sub">Проверка...</div>
        </div>

        <button id="btnCheckAPI" class="btn btn-saas btn-refresh" data-route="<?= route_to('Preval-checkAPI') ?>" type="button"  >
            <i class="fa fa-sync"></i> Провери връзката
        </button>
    </div>

    <!-- MODE -->
    <div class="card-saas">
        <div class="saas-header">Режим на работа</div>
        <div class="saas-sub">Изберете автоматичен или ръчен режим.</div>

        <label class="d-block">
            <input id="mode_auto" name="settings[preval][mode]" <?php
            (empty($mode) || $mode === 'auto') ? 'checked' : '';
            ?> type="radio" value="auto" >
            <strong>Автоматичен режим</strong> – взима курсове от API
        </label>

        <label class="d-block mt-2">
            <input id="mode_manual" name="settings[preval][mode]" type="radio" <?php
            echo $mode === "manual" && (print "checked");
            ?> value="manual" >
            <strong>Ръчен режим</strong> – въвеждане на собствени курсове
        </label>
    </div>

    <!-- MANUAL RATES -->
    <div id="manualBox" class="card-saas <?php
    $mode === "auto" &&
            (print "hide");
    ?>" >
        <div class="saas-header">Ръчни валутни курсове</div>

        <div class="row mt-3">
            <div class="col-md-4">
                <label>EUR → BGN</label>
                <input type="number" step="0.0001" class="form-control"
                       id="eur_bgn" name="settings[preval][eur_bgn]">
            </div>

            <div class="col-md-4">
                <label>USD → BGN</label>
                <input type="number" step="0.0001" class="form-control"
                       id="usd_bgn" name="settings[preval][usd_bgn]">
            </div>

            <div class="col-md-4">
                <label>EUR → USD (кръстосан)</label>
                <div class="input-group">
                    <input type="number" step="0.0001" class="form-control"
                           id="eur_usd" name="settings[preval][eur_usd]">
                    <button type="button" class="btn btn-saas btn-refresh" id="calcCrossRate">
                        <i class="fa fa-equals"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- WARNING: Manual mode validation requirement -->
        <div id="manualWarning" class="preval-manual-warning">
            ⚠️ При <b>ръчен режим</b> е задължително да въведете валидни валутни курсове (EUR → BGN и USD → BGN), за да могат настройките да бъдат записани.
        </div>
    </div>

    <!-- AUTO RATES CARD: Visible only in auto mode -->
    <div id="autoBox" class="card-saas <?php
    $mode === "manual" &&
            (print "hide");
    ?>" >
        <div class="saas-header">Автоматични курсове (ЕЦБ API)</div>

        <div class="row mt-3">
            <div class="col-md-4">
                <label>EUR → BGN</label>
                <input type="text" class="form-control"
                       id="api_eur_bgn" name="settings[preval][api_eur_bgn]" readonly value="<?=
                       $preval[
                       "api_eur_bgn"
                       ] ?? ""
                       ?>">
            </div>

            <div class="col-md-4">
                <label>USD → BGN</label>
                <input type="text" class="form-control"
                       id="api_usd_bgn" name="settings[preval][api_usd_bgn]" readonly value="<?=
                       $preval[
                       "api_usd_bgn"
                       ] ?? ""
                       ?>">
            </div>

            <div class="col-md-4">
                <label>EUR → USD</label>
                <input type="text" class="form-control"
                       id="api_eur_usd" name="settings[preval][api_eur_usd]" readonly value="<?=
                       $preval[
                       "api_eur_usd"
                       ] ?? ""
                       ?>">
            </div>
        </div>

        <button  id="refreshAutoRates" class="btn btn-saas btn-refresh mt-3" data-route="<?= route_to('Preval-getRates') ?>" type="button">
            <i class="fa fa-sync"></i> Обнови автоматичните курсове
        </button>
    </div>

    <!-- BASE CURRENCY -->
    <div class="card-saas">

        <div class="saas-sub mt-2" id="oldCurrencyBox" style="font-weight:600; color:#374151;">
            Предишна основна валута: <span id="oldCurrencyValue"><?= $old_base_currency ?></span>
        </div>
        <div class="saas-header">Основна валута на системата</div>

        <select name="settings[preval][base_currency]" id="base_currency" class="form-control w-50">
            <option <?php
            $preval["base_currency"] === "BGN" &&
                    (print "selected");
            ?> value="BGN">Лев (BGN)</option>
            <option <?php
            $preval["base_currency"] === "EUR" &&
                    (print "selected");
            ?> value="EUR">Евро (EUR)</option>
            <option  <?php
            $preval["base_currency"] === "USD" &&
                    (print "selected");
            ?> value="USD">Долар (USD)</option>
        </select>

        <div class="saas-sub mt-2">
            При смяна на основна валута всички цени ще бъдат автоматично конвертирани.
        </div>
    </div>

    <!-- MASS REVALUATION CARD: Critical operation -->
    <div class="card-saas">
        <div class="saas-header" style="color:#dc2626;">Масово превалутиране</div>

        <p class="saas-sub">
            Тази операция ще преобразува <b>всички доставни и продажни цени</b>.
            Действието е необратимо.
        </p>

        <?php
        $gensoftBlocked  = !empty($preval['gensoft_block']);
        $alreadyRevalued = !empty($preval['revalued']);

        $revalueDisabled = $gensoftBlocked || $alreadyRevalued;

        if ($gensoftBlocked) {
            $revalueTitle = "Превалутирането е блокирано от Gensoft";
        } elseif ($alreadyRevalued) {
            $revalueTitle = "Превалутирането вече е изпълнено";
        } else {
            $revalueTitle = "";
        }
        ?>

        <button id="btnRevalue"
                class="btn btn-danger-saas btn-saas"
                data-route="<?= route_to('Preval-updateDatabase') ?>"
                type="button"
                <?= $revalueDisabled ? 'disabled style="opacity:0.5"' : '' ?>
                <?= $revalueTitle ? 'title="' . $revalueTitle . '"' : '' ?>>

            <i class="fa fa-calculator"></i> Превалутирай база данни
        </button>

        <?php if (!empty($preval['revalued'])): ?>
            <div class="preval-revalued-info">
                ℹ️ Масовото превалутиране вече е извършено. За да го разрешите отново, сменете основната валута и запазете настройките.
            </div>
        <?php endif; ?>
    </div>

    <!-- GENSOFT TOGGLE -->
    <div class="card-saas">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <div class="saas-header">Gensoft активен</div>
                <div class="saas-sub">
                    При активен Gensoft масовото превалутиране е забранено.
                </div>
            </div>

            <label class="switch-saas">
                <input type="checkbox"
                       id="gensoftToggle"
                       data-url="<?= route_to('Preval-gensoftToggle') ?>"
                       <?= !empty($preval["gensoft_block"]) ? "checked" : "" ?>>
                <span class="slider-saas"></span>
            </label>
        </div>
    </div>

    <!-- SAVE SETTINGS BUTTON -->
    <div class="card-saas text-end">
        <button  id="btnSaveSettings"
                 class="btn btn-saas btn-success" 
                 data-route="<?= route_to('Preval-save') ?>"
                 type="button"
                 style="background:#10b981;border:none;">
            <i class="fa fa-save"></i> Запази настройки
        </button>
    </div>
</div>

<!-- SUCCESS MODAL -->
<div id="successModal" class="modal fade" tabindex="-1">
    <div class="modal-dialog modal-sm modal-dialog-centered">
        <div class="modal-content" style="border-radius:14px; overflow:hidden;">

            <div class="modal-body text-center" style="padding:20px 16px;">

                <div style="
                     width:55px;height:55px;
                     background:#e6f9ef;
                     border-radius:50%;
                     margin:0 auto 12px auto;
                     display:flex;align-items:center;justify-content:center;">
                    <i class="fa fa-check" style="font-size:26px;color:#10b981;"></i>
                </div>

                <h5 style="font-weight:700;color:#10b981;margin-bottom:10px;">
                    Настройките са записани
                </h5>

                <button type="button"
                        id="modalCloseBtn"
                        class="btn btn-saas"
                        style="background:#10b981;color:white;border:none;border-radius:10px;padding:6px 22px;">
                    Затвори
                </button>

            </div>
        </div>
    </div>
</div>


<!-- JavaScript configuration constants -->
<script>
    const GENSOFT_BLOCKED = <?= !empty($preval["gensoft_block"]) ? "true" : "false" ?>;
    const PREVAL_REVALUED = <?= !empty($preval["revalued"]) ? "true" : "false" ?>;
</script>

<!-- JavaScript for form validation and interaction -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const modeAuto = document.getElementById('mode_auto');
        const modeManual = document.getElementById('mode_manual');
        const eurBgn = document.getElementById('eur_bgn');
        const usdBgn = document.getElementById('usd_bgn');
        const eurUsd = document.getElementById('eur_usd');
        const saveBtn = document.getElementById('btnSaveSettings');

        // ===== Helper Functions =====

        /**
         * Validates if a value is a positive number
         * @param {*} v - Value to validate
         * @returns {boolean} True if valid positive number
         */
        function isValidNumber (v) {
            return ! isNaN(v) && v > 0;
        }

        /**
         * Calculates cross rate EUR/USD based on BGN pairs
         * Auto-populates the cross rate field
         */
        function calculateCrossRate () {
            const eur = parseFloat(eurBgn.value);
            const usd = parseFloat(usdBgn.value);
            if (isValidNumber(eur) && isValidNumber(usd)) {
                eurUsd.value = ( eur / usd ).toFixed(4);
            }
            else {
                eurUsd.value = '';
            }
        }

        const manualWarning = document.getElementById('manualWarning');

        /**
         * Updates save button state based on form validity
         * In manual mode, requires valid currency rates
         */
        function updateSaveButtonState () {
            // AUTO mode: always enabled
            if (modeAuto.checked) {
                saveBtn.disabled = false;
                saveBtn.style.display = '';
                if (manualWarning)
                    manualWarning.style.display = 'none';
                return;
            }

            // MANUAL mode: validate all three rate fields
            const eur = parseFloat(eurBgn.value);
            const usd = parseFloat(usdBgn.value);
            const cross = parseFloat(eurUsd.value);
            const valid = isValidNumber(eur) && isValidNumber(usd) && isValidNumber(cross);

            if (valid) {
                saveBtn.disabled = false;
                saveBtn.style.display = '';
                if (manualWarning)
                    manualWarning.style.display = 'none';
            }
            else {
                saveBtn.disabled = true;
                saveBtn.style.display = 'none';
                if (manualWarning)
                    manualWarning.style.display = '';
            }
        }

        // ===== Event Listeners =====

        // Recalculate cross rate when BGN rates change
        eurBgn.addEventListener('input', () => {
            calculateCrossRate();
            updateSaveButtonState();
        });

        usdBgn.addEventListener('input', () => {
            calculateCrossRate();
            updateSaveButtonState();
        });

        // Update save button when mode changes
        modeAuto.addEventListener('change', updateSaveButtonState);
        modeManual.addEventListener('change', updateSaveButtonState);

        // Initialize on page load
        calculateCrossRate();
        updateSaveButtonState();
    });
</script>

<!-- Custom CSS for revaluation UI elements -->
<style>
    /* ============================ PREVAL – CUSTOM UI MESSAGES ============================ */

    /* Manual mode warning styling */
    .preval-manual-warning {
        margin-top: 14px;
        padding: 10px 14px;
        background: #fff7ed;
        border-left: 4px solid #f97316;
        color: #7c2d12;
        font-size: 14px;
        border-radius: 8px;
    }

    /* Already revalued information styling */
    .preval-revalued-info {
        margin-bottom: 14px;
        padding: 10px 14px;
        background: #eff6ff;
        border-left: 4px solid #2563eb;
        color: #1e3a8a;
        font-size: 14px;
        border-radius: 8px;
        margin-top: 20px;
    }
</style>
