<!-- Общи настройки -->

<article class="tab-pane fade show active" id="tab-general">
    <hr class="nav-tabs">  

    <div class="mb-2 row">
        <label class="col-3 py-1 fw-400"><?= lang('LANG__nastrojki.label.logo') ?></label>
        <div class="col-7 pl-0">
            <input type="text" name="settings[logo]" class="css-input-p css-focus-strong css-border-none css-max-input-width fw-semi" value="<?= $settings -> logo ?? '' ?>">
        </div>
    </div>

    <div class="mb-2 row">
        <label class="col-3 py-1 fw-400"><?= lang('LANG__nastrojki.label.numPrecision') ?></label>
        <div class="d-flex">
            <?php
            if (isset($settings -> priceAccuracy)) {
                match ($settings -> priceAccuracy) {
                    '1' => $s1 = 'selected',
                    '2' => $s2 = 'selected',
                    '3' => $s3 = 'selected',
                    '4' => $s4 = 'selected',
                };
            } else {
                $selected = 'selected';
            }
            ?>
            <select class="css-dropdown-p css-focus-strong css-border-none fw-semi" name="settings[priceAccuracy]">
                <option <?= $s1 ?? '' ?> value="1">0.0</option>
                <option <?= $s2 ?? $selected ?? '' ?> value="2">0.00</option>
                <option <?= $s3 ?? '' ?> value="3">0.000</option>
                <option <?= $s4 ?? '' ?> value="4">0.0000</option>
            </select>
        </div>
    </div>

    <div class="mb-2 row">
        <label class="col-3 py-1 fw-400"><?= lang('LANG__nastrojki.label.dds') ?></label>
        <div class="col-7 pl-0">
            <input class="css-input-p css-focus-strong css-border-none css-max-input-width fw-semi" name="settings[dds]" type="text"  value="<?= $settings -> dds ?? '20' ?>">
        </div>
    </div>

    <div class="mb-2 row">
        <label class="col-3 py-1 fw-400"><?= lang('LANG__nastrojki.label.invoice_format') ?></label>
        <div class="col-7 pl-0">
            <input class="css-input-p css-focus-strong css-border-none css-max-input-width fw-semi" name="settings[invoice][pref]" type="text" value="<?= $settings -> invoice['pref'] ?? '' ?>">
        </div>
    </div>

    <div class="mb-2 row">
        <label class="col-3 py-1 fw-400">Обратен курс на евро</label>
        <div class="col-7 pl-0">
            <input class="css-input-p css-focus-strong css-border-none css-max-input-width fw-semi" name="settings[euroRate]" type="text" value="<?= $settings -> euroRate ?? '' ?>">
        </div>
    </div>

    <div class="mb-2 row">
        <label class="col-3 py-1 fw-400">Време на неактивност мин.</label>
        <div class="col-7 pl-0">
            <input class="css-input-p css-focus-strong css-border-none css-max-input-width fw-semi" name="settings[sessionTimeout]"  type="text" value="<?= $settings -> sessionTimeout ?? '20' ?>">
        </div>
    </div>

    <div class="mb-2 row">
        <label class="col-3 py-1 fw-400">
            Цени с ДДС
        </label>

        <div class="col-7 pl-0">
            <div class="form-check form-switch">
                <input 
                    class="js-passwordRequired form-check-input"
                    type="checkbox"
                    role="switch"
                    id="pricesWithVat"
                    data-route="<?= route_to('Nastrojka-save_prices_with_dds') ?>"
                    name="settings[prices_with_dds]"
                    value="1"
                    <?= !empty($settings -> prices_with_dds) ? 'checked' : '' ?>>

                <label class="form-check-label fw-semi" for="pricesWithVat">
                    <span id="js-priceLblDDS" class="<?= !empty($settings -> prices_with_dds) ? 'text-danger fw-bold' : '' ?>">
                        ЦЕНИ С ДДС
                    </span>
                    /
                    <span id="js-priceLblBezDDS" class="<?= empty($settings -> prices_with_dds) ? 'text-danger fw-bold' : '' ?>">
                        ЦЕНИ БЕЗ ДДС
                    </span>
                </label>
            </div>

            <small class="text-muted d-block mt-1">
                Определя дали въведените цени са крайни (с включено ДДС) или са без ДДС,
                което ще се начислява автоматично при фактуриране.
            </small>
        </div>
    </div>

    <button class="js-saveFormVisible css-btn-save btn p-1 btn-primary float-right align-self-end round-10" type="submit">
        <i class="fa fa-save m-1"></i>&nbsp;<?= lang('LANG__global.btn.save') ?>
    </button>
</article>
