<article class="tab-pane fade" id="tab-db">
    <h4 class="text-center"><i class="fa fa-database"></i>&nbsp;БАЗА ДАННИ</h4>

    <hr class="nav-tabs"> 

    <div class="mt-4">
        <div class="row">

            <div class="col-md-8">
                <div class="h-100 bg-white round-10" style="border: 1px solid #c9c9c9;">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <span>Избор на таблици за зануляване</span>
                    </div>

                    <div class="card-body p-0" style="max-height:67vh;overflow-y: auto;">
                        <table class="table table-striped table-sm table-hover mb-0">
                            <thead class="css-bg-purple">
                                <tr>
                                    <th><input id="masterCheck" type="checkbox" ></th>
                                    <th>Таблица</th>
                                    <th>Редове</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php foreach ($dbManager_list as $k => $row): ?>
                                    <tr>
                                        <td>
                                            <input class="tbl-check" type="checkbox" value="<?= $row['tbl'] ?>">
                                        </td>

                                        <td class="text-left">
                                            <div><?= $row['tbl'] ?></div>
                                            <div class="tbl-desc"><?= $row['desc'] ?></div>
                                        </td>

                                        <td><span class="badge-count <?= $row['rows'] > 0 ? 'bg-green' : '' ?> "><?= $row['rows'] ?></span></td>
                                    </tr>
                                <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card danger-zone">
                    <div class="card-header bg-danger text-white">
                        Изтриване на избраните
                    </div>

                    <div class="card-body flex-col">
                        <div class="mb-4" style="font-size:13px;">
                            <strong>Информация:</strong>
                            <ul class="mb-0 pl-3 mt-2">
                                <li>Действието използва <b>TRUNCATE TABLE</b></li>
                                <li>Данните се изтриват без възможност за връщане</li>
                                <li>Подходящо за логове, кеш и временни таблици</li>
                                <li>Използвай внимателно при core таблици</li>
                            </ul>
                        </div>

                        <div class="form-group text-center">
                            <label class="fw-bold">Напиши delete за потвърждение</label>
                            <input id="confirmInput" class="css-input-p css-focus-strong css-border-none mt-2" type="text" placeholder="delete">
                        </div>

                        <button id="truncateBtn" 
                                class="btn btn-danger round-10 mt-3"  
                                data-route="<?= route_to('DBManager-truncateTables') ?>"
                                disabled>ЗАНУЛИ ИЗБРАНИТЕ ТАБЛИЦИ</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

</article>
<style>

    .card-header {
        font-weight: 600;
        background: #fff;
        border-bottom: 1px solid #f0f0f0;
        font-size: 15px;
    }

    .danger-zone {
        border: 2px solid #dc3545;
        background: #fff7f7;
        height: 100%;
    }

    .danger-zone .card-header {
        font-size: 16px;
        letter-spacing: .3px;
    }


    .table tbody tr:hover {
        background: #fafbfe;
    }

    .tbl-desc {
        font-size: 12px;
        color: #8a93a6;
        margin-top: 2px;
    }

    .btn-group-top button {
        margin-left: 6px;
    }

    .badge-count {
        font-size: 12px;
        padding: 6px 12px;
        border-radius: 20px;
        background: #eef1f7;
        color: #444;
        font-weight: 600;
    }

    .card-body.flex-col {
        display: flex;
        flex-direction: column;
        justify-content: center;
        padding: 30px;
    }

    .danger-zone label {
        color: #dc3545;
        font-size: 12px;
    }

    #truncateBtn {
        font-weight: 600;
        padding: 12px;
        font-size: 15px;
        box-shadow: 0 6px 14px rgba(220,53,69,.25);
    }

    #truncateBtn:disabled {
        box-shadow: none;
    }

    input#confirmInput {
        text-align: center;
        letter-spacing: 2px;
    }
</style>

<script>
    $('#confirmInput').on('keyup', function () {
        $('#truncateBtn').prop('disabled', $(this).val() !== 'delete');
    });

    $('#truncateBtn').on('click', function () {
        let route = $(this).data('route');
        let tablesNames = $('table:visible tbody input[type="checkbox"]:checked').map(function () {
            return this.value;
        }).get();

        console.log(route);

        $.ajax({
            url: route,
            type: 'POST',
            dataType: 'json',
            global: false,
            data: {'tablesNames': tablesNames},
            success: function (res) {

            }
        });

    });

    // Маркирай всички (бутон)
    $('#masterCheck').on('click', function () {
        let isChecked = $(this).is(':checked');

        $(this).closest('table').find('tbody input[type="checkbox"]').prop('checked', isChecked);
    });
</script>
