<?php

namespace App\Setups\Models;

use \App\Models\BaseModel as BaseModel;

class MODEL__relatedRules extends BaseModel {

    // основен продукт
    public function get_baseProduct($productId = '') {
        if (empty($productId)) {
            return;
        }

        return $this -> db -> table(self::TBL_PRODUCT)
                        -> where("product_id", $productId)
                        -> get() -> getRowArray();
    }

    public function get_activeProductsBatch(int $limit, int $offset): array {
        return $this -> db -> table(self::TBL_PRODUCT)
                        -> select('product_id')
                        -> groupStart()
                        -> where('Active', 1)
                        -> orWhere('Active IS NULL', null, false)
                        -> groupEnd()
                        -> orderBy('product_id', 'ASC')
                        -> limit($limit, $offset)
                        -> get() -> getResultArray();
    }

    // извл на свързаните продукти
    public function get_relatedProducts($productId, $baseProduct, $search = []) {
        if (empty($productId) || empty($search['field']) || empty($search['like'])) {
            return [];
        }

        $builder = $this -> db -> table(self::TBL_PRODUCT);

        $builder -> select('product_id');
        $builder -> like($search['field'], $search['like'], $search['like_type'] ?? 'both');
        $builder -> where('product_id !=', $productId);

        // Само активни
        if (!empty($search['onlyActive'])) {
            $builder -> groupStart()
                    -> where('Active', 1)
                    -> orWhere('Active IS NULL', null, false)
                    -> groupEnd();
        }

        // Същата категория
        if (!empty($search['sameCategory']) && !empty($baseProduct['category_id'])) {
            $builder -> where('category_id', $baseProduct['category_id']);
        }

        // Същата подкатегория
        if (!empty($search['sameSubcategory']) && !empty($baseProduct['subCat_id'])) {
            $builder -> where('subCat_id', $baseProduct['subCat_id']);
        }

        if (!empty($search['limit'])) {
            $builder -> limit((int) $search['limit']);
        }

        return $builder -> get() -> getResultArray();
    }

    public function save_relatedProducts($productId, $rows = []) {
        if (empty($productId) || empty($rows)) {
            return false;
        }

        $relatedIds = [];

        foreach ($rows as $r) {
            $relatedIds[] = (string) $r['product_id'];
        }

        $ok = $this -> db -> table(self::TBL_PRODUCT)
                -> where('product_id', $productId)
                -> update(['related_products' => json_encode($relatedIds)]);

        return [
            'ok'  => $ok,
            'ids' => $relatedIds
        ];
    }

}
