<?php

namespace App\Setups\Models;

use DateTime;
use DateTimeZone;
use Config\Services;
use \App\Models\BaseModel as BaseModel;

class MODEL__preval extends BaseModel {

    public function update_multi_dB(float $mult, array &$general): array {
        if ($mult <= 0) {
            throw new \InvalidArgumentException('Invalid multiplier');
        }

        $debug = [
            'status'     => 'started',
            'multiplier' => $mult,
            'steps'      => [],
            'tables'     => [],
        ];
        $this -> db -> transBegin();

        try {
            // 1️⃣ Основни продуктови таблици
            $this -> update_productTables($mult);
            $debug['steps'][] = 'update_productTables';

            // 2️⃣ order_cart JSON
            $debug['order_cart'] = $this -> updateOrderJson(self::TBL_ORDERCART, $mult, 3);
            $debug['steps'][]    = 'update_orderCartJson';

            // 3️⃣ order JSON
            $debug['order']   = $this -> updateOrderJson(self::TBL_ORDER, $mult, 5);
            $debug['steps'][] = 'update_orderJson';

            $debug['ofer_special'] = $this -> updateQtyPriceJsonTable(self::TBL_SPECIAL, $mult);
            $debug['steps'][]      = 'updateOfferSpecialJson';

            $debug['ofer_biznesKlient'] = $this -> updateQtyPriceJsonTable(self::TBL_BIZNESKLIENT, $mult);
            $debug['steps'][]           = 'updateOfferBiznesKlientJson';

            $debug['ofer_promo'] = $this -> updateQtyPriceJsonTable(self::TBL_PROMO, $mult);
            $debug['steps'][]    = 'updateOfferPromoJson';

            $debug['ofer_promoKl'] = $this -> updateQtyPriceJsonTable(self::TBL_PROMOKL, $mult);
            $debug['steps'][]      = 'updateOfferPromoKlJson';

            $debug['ofer_baner'] = $this -> updateQtyPriceJsonTable(self::TBL_BANER, $mult);
            $debug['steps'][]    = 'updateOfferBanerJson';

            if ($this -> db -> transStatus() === false) {
                throw new \RuntimeException('Database transaction failed');
            }

            $this -> db -> transCommit();

            // маркираме че е преоценено
            $general['preval']['revalued'] = true;

            $debug['status'] = 'ok';
            $debug['check']  = [
                '1_unit_converted'   => round(1 * $mult, 4),
                '10_units_converted' => round(10 * $mult, 4),
            ];

            return $debug;
        } catch (\Throwable $e) {
            $this -> db -> transRollback();
            throw $e; // ❗ оставяме controller-а да реши какво да върне
        }
    }

    function update_productTables(float $mult): void {

        // Update delivery price
        $this -> db -> table(self::TBL_PRODUCT)
                -> set('price_dostavna', "ROUND(price_dostavna * $mult, 4)", false)
                -> where('gensoft_item_id is null')
                -> update();

        // Price level fields to be converted
        $fields = [
            'cenaB',
            'cenaA',
            'cenaSpec',
            'cenaKl',
            'cenaKKC',
            'cenaIndiv',
            'zavishena_zena',
            'zavishenaKl_zena',
            'cenaPromo',
            'cenaPromoKl',
        ];

        foreach ($fields as $field) {
            $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL)
                    -> set($field, "ROUND($field * {$mult}, 4)", false)
                    -> update();
        }
    }

    private function updateOrderJson(string $table, float $mult, int $sampleLimit = 3): array {
        $debug = [
            'table'        => $table,
            'rows_found'   => 0,
            'rows_updated' => 0,
            'errors'       => [],
            'samples'      => [],
        ];

        $rows = $this -> db -> table($table)
                        -> select('order_id, product_json')
                        -> where('product_json IS NOT NULL')
                        -> get() -> getResultArray();

        $debug['rows_found'] = count($rows);

        foreach ($rows as $row) {
            if (!$row['product_json']) {
                continue;
            }

            $json = json_decode($row['product_json'], true);

            if (!is_array($json)) {
                $debug['errors'][] = "Invalid JSON (order_id={$row['order_id']})";
                continue;
            }

            $before  = $json;
            $total   = 0.0;
            $changed = false;

            foreach ($json as &$item) {
                if (!isset($item['price']) || !is_numeric($item['price'])) {
                    continue;
                }

                $priceNew = round((float) $item['price'] * $mult, 2);

                if ($priceNew != $item['price']) {
                    $item['price'] = $priceNew;
                    $changed       = true;
                }

                $qty   = isset($item['qty']) && is_numeric($item['qty']) ? (float) $item['qty'] : 1;
                $total += $priceNew * $qty;
            }
            unset($item);

            if (!$changed) {
                continue;
            }

            $this -> db -> table($table)
                    -> where('order_id', $row['order_id'])
                    -> update([
                        'product_json' => json_encode(
                                $json,
                                JSON_UNESCAPED_UNICODE | JSON_PRESERVE_ZERO_FRACTION
                        ),
                        'total_price'  => round($total, 2),
            ]);

            $debug['rows_updated']++;

            if (count($debug['samples']) < $sampleLimit) {
                $debug['samples'][] = [
                    'order_id' => $row['order_id'],
                    'before'   => $before,
                    'after'    => $json,
                ];
            }
        }

        return $debug;
    }

    function updateQtyPriceJsonTable(string $table, float $mult): array {

        $debug = [
            'table'        => $table,
            'rows_found'   => 0,
            'rows_updated' => 0,
            'errors'       => [],
            'samples'      => [],
        ];

        $rows = $this -> db -> table($table)
                        -> select('id, qtyPrice_json')
                        -> where('qtyPrice_json IS NOT NULL')
                        -> get() -> getResultArray();

        $debug['rows_found'] = count($rows);

        foreach ($rows as $row) {
            if (empty($row['qtyPrice_json'])) {
                continue;
            }

            $json = json_decode($row['qtyPrice_json'], true);

            if (!is_array($json)) {
                $debug['errors'][] = "Invalid JSON (id={$row['id']})";
                continue;
            }

            $before = $json;

            foreach ($json as &$item) {
                if (!isset($item['price'])) {
                    continue;
                }

                $item['price'] = round((float) $item['price'] * $mult, 2);
            }
            unset($item);

            $this -> db -> table($table)
                    -> where('id', $row['id'])
                    -> update([
                        'qtyPrice_json' => json_encode($json, JSON_UNESCAPED_UNICODE | JSON_PRESERVE_ZERO_FRACTION)
            ]);

            $debug['rows_updated']++;

            if (count($debug['samples']) < 3) {
                $debug['samples'][] = [
                    'id'     => $row['id'],
                    'before' => $before,
                    'after'  => $json,
                ];
            }
        }

        return $debug;
    }

}
