<?php

namespace App\Setups\Models;

use \App\Models\BaseModel as BaseModel;

class MODEL__nastrojka extends BaseModel {

    protected const TBL_SP_SITE = '_sp_site';

    public function get__site() {
        return $this -> db -> table(self::TBL_SP_SITE)
                        -> get() -> getResultArray();
    }

    // извл на страниците за нас, политики и т.н за портала
    public function get__portal_setings($key = null) {
        $sql = $this -> db -> table(self::TBL_SETINGS_PORTAL)
                        -> where('key', $key)
                        -> get() -> getRow();
//dd($sql);
        return $sql;
    }

    // изв на всички продукти с цена ккц
    public function get__all_product_with_priceKkc() {
        $sql = $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL)
                        -> where('cenaKKC IS NOT NULL')
                        -> get() -> getResultArray();

        return $sql;
    }

    public function update__discountPrices($products = []) {
        $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL)
                -> updateBatch($products, 'product_priceLevel_id');
    }

    public function backupMultiPrices() {
        $this -> db -> transStart();
        $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL_BACKUP) -> truncate();

        // Backup all current product price levels
        $select = $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL)
                -> select('*, NOW() ')
                -> getCompiledSelect();

        $this -> db -> query("INSERT INTO " . self::TBL_PRODUCT_PRICE_LEVEL_BACKUP . "$select");

        $this -> db -> transComplete();
    }

    public function restoreMultiPrices() {
        // Restore prices from backup table
        $this -> db -> query("UPDATE " . self::TBL_PRODUCT_PRICE_LEVEL . " p
            JOIN " . self::TBL_PRODUCT_PRICE_LEVEL_BACKUP . " b
             ON b.product_priceLevel_id = p.product_priceLevel_id
                SET
                  p.cenaB    = b.cenaB,
                  p.cenaA    = b.cenaA,
                  p.cenaSpec = b.cenaSpec,
                  p.cenaKl   = b.cenaKl,
                  p.cenaKKC  = b.cenaKKC,
                  p.klientIds_to_cenaIndiv = b.klientIds_to_cenaIndiv,
                  p.date_changed = NOW()
            
        ");
    }

    public function format_allPpoduktModel($format = '') {
        $formatQuery = $format === 'uppercase' ? 'UPPER(model)' :
                "CONCAT(
                    LEFT(model, REGEXP_INSTR(model, '[^0-9 ]') - 1),
                    UPPER(SUBSTRING(model, REGEXP_INSTR(model, '[^0-9 ]'), 1)),
                    SUBSTRING(model, REGEXP_INSTR(model, '[^0-9 ]') + 1)
                 )";

        $this -> db -> table(self::TBL_MODEL)
                -> set('model', $formatQuery, false)
                -> where('model is not null')
                -> update();
    }

    public function save__site($data = []) {

//        $fh = fopen(dirname(getcwd(), 2) . '/public_html/demo.offertabg.com/config.php', 'r') or die();
//
//        while (!feof($fh)) {
//            $line = fgets($fh, 4096);
//            if (preg_match('/DB_DATABASE/', $line)) {
//                $env['db_name'] = trim(preg_replace('/.* =/', '', $line));
//            }
//            if (preg_match('/DB_PASSWORD/', $line)) {
//                $env['db_password'] = trim(preg_replace('/.* =/', '', $line));
//            }
//            if (preg_match('/DB_USERNAME/', $line)) {
//                $env['db_username'] = trim(preg_replace('/.* =/', '', $line));
//            }
//            if (preg_match('/DB_PREFIX/', $line)) {
//                $env['db_prefix'] = trim(preg_replace('/.* =/', '', $line));
//            }
//        } fclose($fh);

        $custom = [
            'hostname' => 'localhost',
            'username' => trim($data['site_dbUser']),
            'password' => trim($data['site_dbPass']),
            'database' => trim($data['site_db']),
            'DBDriver' => 'MySQLi',
            'port'     => 3306,
        ];

        $db = \Config\Database::connect($custom);

        // тестване на конекцията към базата данни на ел магазин
        if (!$db -> getVersion()) {
            return $db -> getVersion();
        }

        $db -> close();

        return $this -> db -> table(self::TBL_SP_SITE) -> upsert($data);
    }

    public function save_portal($data = []) {
        $builder = $this -> db -> table(self::TBL_SETINGS_PORTAL);

        // Ако няма ID — проверка дали съществува запис по key
        if (empty($data['settings_portal_id'])) {
            $isExist = $builder
                    -> select('settings_portal_id')
                    -> where('key', $data['key'])
                    -> countAllResults();

            if ($isExist > 0) {
                unset($data['settings_portal_id']);
            } else {
                $builder -> insert($data);
                return;
            }
        }

        // Ако има ID или е направена проверка — правим update
        $builder -> set($data)
                -> where('key', $data['key'])
                -> update();
    }

    public function delete__site($id = '') {
        $this -> db -> table($this -> tbl_site)
                -> where('sp_site_id', $id) -> delete();
    }

}
