<?php

namespace App\Setups\Models;

use \App\Models\BaseModel as BaseModel;

class MODEL__dbManager extends BaseModel {

    // основен продукт
    public function get_tables() {

        $tables = [
            self::TBL_PRODUCT                    => ['desc' => 'Основни продукти'],
            self::TBL_KLIENT                     => ['desc' => 'Клиенти'],
            self::TBL_BRAND                      => ['desc' => 'Марки'],
            self::TBL_MODEL                      => ['desc' => 'Модели'],
            self::TBL_ZENOVA_LISTA               => ['desc' => 'Цеенови листи'],
            self::TBL_PROMO                      => ['desc' => 'Промоции'],
            self::TBL_BANER                      => ['desc' => 'Заявка за банер'],
            self::TBL_BIZNESKLIENT               => ['desc' => 'Бизнес ферти'],
            self::TBL_SPECIAL                    => ['desc' => 'Оферти'],
            self::TBL_ORDER                      => ['desc' => 'Поръчки'],
            self::TBL_ORDERRETURN                => ['desc' => 'Поръчки - върнати'],
            self::TBL_ORDERCART                  => ['desc' => 'Поръчки - незаписани'],
            self::TBL_PRODUCT_PRICE_LEVEL        => ['desc' => 'Ценови нива'],
            self::TBL_PRODUCT_PRICE_LEVEL_BACKUP => ['desc' => 'Ценови нива backup'],
            self::TBL_PRODUCT_IN_ZENOVALISTA     => ['desc' => 'Продукти в ценова листа'],
            self::TBL_PRODUCT_IN_PROMOLISTA      => ['desc' => 'Продукти в промо листа'],
            self::TBL_PRODUCT_IN_PROMOKL         => ['desc' => 'Продукти в промо листа клиент'],
            self::TBL_PRODUCT_CHAR_VALUE         => ['desc' => 'Х-ки на продукт'],
            self::TBL_USERS                      => ['desc' => 'Потребители от системата'],
            self::TBL_USERSITE                   => ['desc' => 'Потребители от сайт'],
        ];

        $result = [];
        foreach ($tables as $table => $meta) {
            $rows = $this -> db -> table($table)
                            -> select('1', false)
                            -> limit(1)
                            -> get() -> getRow();

            $result[] = [
                'tbl'  => $table,
                'desc' => $meta['desc'],
                'rows' => $rows ? 1 : 0
            ];
        }

        return $result;
    }

    public function truncate_tables($tablesNames = []) {
        foreach ($tablesNames as $table) {
            $this -> db -> table($table) -> truncate();
        }

        return true;
    }

    // извл на свързаните продукти
    public function get_relatedProducts($productId, $baseProduct, $search = []) {
        if (empty($productId) || empty($search['field']) || empty($search['like'])) {
            return [];
        }

        $builder = $this -> db -> table(self::TBL_PRODUCT);

        $builder -> select('product_id');
        $builder -> like($search['field'], $search['like'], $search['like_type'] ?? 'both');
        $builder -> where('product_id !=', $productId);

        // Само активни
        if (!empty($search['onlyActive'])) {
            $builder -> groupStart()
                    -> where('Active', 1)
                    -> orWhere('Active IS NULL', null, false)
                    -> groupEnd();
        }

        // Същата категория
        if (!empty($search['sameCategory']) && !empty($baseProduct['category_id'])) {
            $builder -> where('category_id', $baseProduct['category_id']);
        }

        // Същата подкатегория
        if (!empty($search['sameSubcategory']) && !empty($baseProduct['subCat_id'])) {
            $builder -> where('subCat_id', $baseProduct['subCat_id']);
        }

        if (!empty($search['limit'])) {
            $builder -> limit((int) $search['limit']);
        }

        return $builder -> get() -> getResultArray();
    }

    public function save_relatedProducts($productId, $rows = []) {
        if (empty($productId) || empty($rows)) {
            return false;
        }

        $relatedIds = [];

        foreach ($rows as $r) {
            $relatedIds[] = (string) $r['product_id'];
        }

        $ok = $this -> db -> table(self::TBL_PRODUCT)
                -> where('product_id', $productId)
                -> update(['related_products' => json_encode($relatedIds)]);

        return [
            'ok'  => $ok,
            'ids' => $relatedIds
        ];
    }

}
