<?php

namespace App\Setups\Controllers;

use \App\Controllers\ApiQurier;
use \App\Controllers\Ajax\SeoController;
use \App\Setups\Models\MODEL__nastrojka;
use \App\Models\MODEL__gensoft;
use \App\Models\common\MODEL__global;
use \App\Libraries\Pagination;

class Nastrojka extends \App\Controllers\BaseController {

    protected $viewPath = 'Setups\Views\nastrojki\\';
    protected MODEL__gensoft $MODEL__gensoft;
    protected MODEL__nastrojka $MODEL__nastrojka;
    protected MODEL__global $MODEL__global;
    protected ApiQurier $ApiQurier;
    protected SeoController $SeoController;
    protected CronDashboard $CronDashboard;
    protected DBManager $DBManager;
    protected Language $Language;

    public function __construct() {
        parent::__construct();

        $this -> viewSetPath    = $this -> viewPath . 'page\set\\';
        $this -> viewPortalPath = $this -> viewPath . 'page\portal\\';

        $this -> MODEL__gensoft   = new MODEL__gensoft();
        $this -> ApiQurier        = new ApiQurier();
        $this -> SeoController    = new SeoController();
        $this -> CronDashboard    = new CronDashboard();
        $this -> DBManager        = new DBManager();
        $this -> MODEL__global    = new MODEL__global();
        $this -> MODEL__nastrojka = new MODEL__nastrojka();
        $this -> Language         = new Language();
        $this -> Pagination_lib   = new Pagination();
    }

    public function index() {
        $isRefresh       = $this -> request -> getVar('isRefresh');
        $settingsService = service('settings');
        $var             = $this -> request -> getVar();
        $view            = $var['view'] ?? null;

        // Breadcrumbs
        $this -> breadcrumb -> add('Home', '/');
        $this -> breadcrumb -> add(lang('LANG__nastrojki.title'), '/');

        // Portal settings block
        if ($view === 'portal') {
            $portal_setings = $this -> MODEL__nastrojka -> get__portal_setings($var['key'] ?? $var['link']);
        }

        if ($view === 'seo') {
            $perPage = $this -> request -> getVar('perPage') ?? 25;
            $page    = (int) $this -> request -> getVar('page');

            $offset = ($page > 1) ? ($perPage * ($page - 1)) : 0;

            $seoResult = $this -> SeoController -> list(['offset' => $offset, 'per_page' => $perPage]);

            $countTotalPag = $seoResult['totalRows'];

            $total_pages   = ceil($countTotalPag / ($perPage ?: 1)); // ako $perPage ==0
            $seoPagination = $this -> Pagination_lib -> generate(['page' => $page, 'total_pages' => $total_pages]);
        }

        if ($view === 'gensoft') {
            $kontragents = $this -> MODEL__gensoft -> get__kontragents();
            $kasi_banki  = $this -> MODEL__gensoft -> get__kasiBanki();
        }

        if ($view === 'set') {
            $cronJobs       = $this -> CronDashboard -> index();
            $dbManager_list = $this -> DBManager -> index();

            // ===== RELATED RULES (CRON CONFIG) =====
            $db = \Config\Database::connect();

            $rules = $db -> table('_related_products_rules')
                    -> orderBy('id', 'DESC')
                    -> get()
                    -> getResultArray();
        }


        // API куриер
        $speedy_profilSender = json_decode($this -> ApiQurier -> speedy_profilSender(), true);
        $profilSender        = $this -> ApiQurier -> EcontRequest('Profile/ProfileService.getClientProfiles.json', [0])['profiles'] ?? [];

        $еcontAgents = !empty($profilSender) ? $this -> ApiQurier -> EcontRequest(null, null, 'https://ee.econt.com/suggest_autocorrect.php?method=GetEeReadyParcelAgent&id_client=' . $profilSender[0]['client']['id'])['data'] : []; // упълномощено лице за еконт

        $pageTitle = [
            'set'     => '<i class="fa fa-cogs"></i> НАСТРОЙКA СИСТЕМА',
            'portal'  => '<i class="fa fa-cogs"></i> НАСТРОЙКА ПОРТАЛ',
            'firma'   => '<i class="fa fa-cogs"></i> ДАННИ ЗА ФИРМАТА',
            'seo'     => '<i class="fa fa-cogs"></i> SEO НАСТРОЙКИ',
            'gensoft' => '<i class="fa fa-cogs"></i> GENSOFT',
        ];

        $data = [
            'page_title'     => $pageTitle[$view],
            'breadcrumb'     => $this -> breadcrumb -> render(),
            'addCSS'         => $this -> addCSS(),
            'addJS'          => $this -> addJS($view),
            'message'        => session() -> getFlashdata('message'),
            'settings'       => (object) $settingsService -> get('App.general'),
            'gensoft'        => (object) $settingsService -> get('App.gensoft'),
            'firma'          => (object) $settingsService -> get('App.firma'),
            'sitesList'      => $this -> MODEL__nastrojka -> get__site(),
            'seo'            => [
                'list'       => $seoResult['rows'] ?? [],
                'totalRows'  => $countTotalPag ?? '',
                'pagination' => $seoPagination ?? []
            ],
            'cronJobs'       => $cronJobs ?? [],
            'dbManager_list' => $dbManager_list ?? [],
            'rules'          => $rules ?? [],
            $seoResult['rows'] ?? [],
            'kontragents'    => $kontragents ?? [],
            'kasi_banki'     => $kasi_banki ?? [],
            'econt'          => [
                'agents'  => $еcontAgents,
                'senders' => $profilSender,
            ],
            'speedy'         => [
                'senders' => $speedy_profilSender['clients'] ?? [],
            ],
            //'portal'            => (object) service('settings') -> get('App.portal'),
            'portal_setings' => $portal_setings ?? [],
            // --- View paths mapping -------------------------
            'view'           => [
                'set'     => $this -> viewPath . 'VIEW__nastrojki_set',
                'firma'   => $this -> viewPath . 'VIEW__nastrojki_firma',
                'sites'   => $this -> viewPath . 'VIEW__nastrojki_sites',
                'portal'  => $this -> viewPath . 'VIEW__nastrojki_portal',
                'gensoft' => $this -> viewPath . 'VIEW__nastrojki_gensoft',
                'seo'     => $this -> viewPath . 'VIEW__nastrojki_seo',
                'page'    => [
                    'set'    => [
                        'general'             => $this -> viewSetPath . 'VIEW__nastrojki_page-set-general',
                        'cronJobs'            => $this -> viewSetPath . 'VIEW__nastrojki_page-set-cronJobs',
                        'curier'              => $this -> viewSetPath . 'VIEW__nastrojki_page-set-curier',
                        'zenoobr'             => $this -> viewSetPath . 'VIEW__nastrojki_page-set-zenoobr',
                        'preval'              => $this -> viewSetPath . 'VIEW__nastrojki_page-set-preval',
                        'func'                => $this -> viewSetPath . 'VIEW__nastrojki_page-set-func',
                        'related'             => $this -> viewSetPath . 'VIEW__nastrojki_page-set-related',
                        'variation_generator' => $this -> viewSetPath . 'VIEW__nastrojki_page-set-variation-generator',
                        'db'                  => $this -> viewSetPath . 'VIEW__nastrojki_page-set-db',
                    ],
                    'portal' => [
                        'logo'             => $this -> viewPortalPath . 'VIEW__nastrojki_page-portal-logo',
                        'home_banerBlock1' => $this -> viewPortalPath . 'VIEW__nastrojki_page-portal-home_banerBlock1',
                        'slideshow'        => $this -> viewPortalPath . 'VIEW__nastrojki_page-portal-slideshow',
                        'infoPages'        => $this -> viewPortalPath . 'VIEW__nastrojki_page-portal-infoPages',
                        'order'            => $this -> viewPortalPath . 'VIEW__nastrojki_page-portal-order',
                        'func'             => $this -> viewPortalPath . 'VIEW__nastrojki_page-portal-func',
                        'links'            => $this -> viewPortalPath . 'VIEW__nastrojki_page-portal-links',
                        'companyData'      => $this -> viewPortalPath . 'VIEW__nastrojki_page-portal-companyData'
                    ],
                ]
            ],
        ];

        $loadview = view($this -> viewPath . 'VIEW__nastrojki', $data);

        return $isRefresh ? $loadview : $this -> render_template($this -> viewPath . 'VIEW__nastrojki', $data);
    }

    // SEO page view loader 
    // Generates breadcrumb and loads the SEO settings page.
    public function seo() {
        $this -> breadcrumb -> add('Home', '/');
        $this -> breadcrumb -> add('Настройки', '/nastrojka');
        $this -> breadcrumb -> add('SEO настройки', '/nastrojka?view=seo');

        $data = [
            'page_title' => 'SEO настройки',
            'breadcrumb' => $this -> breadcrumb -> render(),
            'addCSS'     => $this -> addCSS(),
            'addJS'      => $this -> addJS(),
        ];

        return $this -> render_template($this -> viewPath . 'VIEW__nastrojki_seo', $data);
    }

    // заявки към генсофт за създаване на колоната ITEM_ID в необх таблици
    public function gensoft_sql(string $action = '') {
        $success = $this -> MODEL__gensoft -> executeSqlQueries($action);
        return $this -> response -> setJSON($success);
    }

    // форматиране текста на моделите на продукт с ГЛАВНИ или с 1-ва Главна буква
    public function format_allPpoduktModel() {
        $format = $this -> request -> getVar('format');

        $this -> MODEL__nastrojka -> format_allPpoduktModel($format);
        return json_encode(true);
    }

    public function delete_site(int $id) {
        $this -> MODEL__nastrojka -> delete__site($id);

        return redirect() -> back();
    }

    //Saves or updates site configuration.
    public function save_site() {
        $form = $this -> request -> getVar('form');

        $result = $this -> MODEL__nastrojka -> save__site($form);

        if ($result === 1) {
            $this -> returnResponse(true, $form['site_name'], lang('LANG__nastrojki.returnResponse.ok.newSite'), 1);
        } elseif ($result === 2) {
            $this -> returnResponse(true, $form['site_name'], lang('LANG__nastrojki.returnResponse.ok.editSite'), 1);
        }

        return json_encode(true);
    }

// запис на страници за сайта
    public function save_portal() {
        $urlParams = $this -> request -> getVar();
        $portalId  = $urlParams['settings_portal_id'] ?? null;
        $form      = $urlParams['settings'] ?? [];
        $key       = $urlParams['key'] ?? null;

        if (empty($form) || empty($key)) {
            return;
        }

        // Filter out empty text data
        if (!empty($form['text']) && is_array($form['text'])) {
            foreach ($form['text'] as $k => $item) {
                if (is_array($item)) {
                    $filtered = array_filter($item, fn($val) => $val !== '');

                    if (!empty($filtered)) {
                        $form['text'][$k] = $filtered;
                    } else {
                        unset($form['text'][$k]);
                    }
                }
            }

            $jsonEncoded = json_encode(
                    in_array($key, ['slideshow', 'slideshowDilar', 'home_banerBlock1', 'home_banerBlock1Dilar']) && !empty($form['text']) ? array_values($form['text']) : $form['text'], JSON_UNESCAPED_UNICODE);
        }


        $data = [
            'settings_portal_id' => $portalId,
            'key'                => $key,
            'text'               => $jsonEncoded ?? $form['text'] ?? null
        ];

        $this -> MODEL__nastrojka -> save_portal($data);

        return json_encode('');
    }

    // Saves different types of settings: set, firma, sites, gensoft.
    public function save($arg = '') {
        $settings = service('settings');
        // Get all POST form data
        $form     = $this -> request -> getVar('settings') ?? [];

        $form = array_filter($form, function ($value) {
            return $value != '';
        });

        $form['zenoobr'] = array_filter($form['zenoobr'] ?? []);

        $form['zenoobr'] = [
            'B_discount'    => $form['zenoobr']['B_discount'] ?? null,
            'A_discount'    => $form['zenoobr']['A_discount'] ?? null,
            'A_turnover'    => $form['zenoobr']['A_turnover'] ?? null,
            'A_from'        => $form['zenoobr']['A_from'] ?? null,
            'A_to'          => $form['zenoobr']['A_to'] ?? null,
            'Spec_discount' => $form['zenoobr']['Spec_discount'] ?? null,
            'Spec_turnover' => $form['zenoobr']['Spec_turnover'] ?? null,
            'Spec_from'     => $form['zenoobr']['Spec_from'] ?? null,
            'Spec_to'       => $form['zenoobr']['Spec_to'] ?? null,
        ];

        // Определяме ключа
        $key = match ($arg) {
            'set' => 'App.general',
            'firma' => 'App.firma',
            'sites' => 'App.sites',
            'gensoft' => 'App.gensoft',
            default => null
        };

        if (!$key) {
            return $this -> response -> setJSON(['error' => 'Invalid key']);
        }

        // Взимаме СТАРИТЕ настройки
        $old = $settings -> get($key) ?? [];

        // MERGE: старите + новите
        $new = array_replace_recursive($old, $form);

        // Запис
        $settings -> set($key, $new);

        return $this -> response -> setJSON(['ok' => true]);
    }

    public function save_price_type() {
        // Allow only AJAX requests
        if (!$this -> request -> isAJAX()) {
            return $this -> response -> setJSON(['ok' => false]);
        }

        // Load settings service and current general settings
        $settingsService = service('settings');
        $settings        = $settingsService -> get('App.general') ?? [];

        // Get selected price type from POST
        $newType = $this -> request -> getPost('price_type');

        // Validate price type
        if (!in_array($newType, ['gensoft', 'multi', 'discount'], true)) {
            return $this -> response -> setJSON(['ok' => false]);
        }

        // --------------------------------------------------
        // 1. Merge discount settings sent from the frontend
        // --------------------------------------------------
        $postZenoobr = $this -> request -> getPost('settings')['zenoobr'] ?? [];

        if (!empty($postZenoobr)) {
            $settings['zenoobr'] = array_merge(
                    $settings['zenoobr'] ?? [],
                    $postZenoobr
            );
        }

        // --------------------------------------------------
        // 2. Handle price data depending on selected type
        // --------------------------------------------------
        if ($newType === 'multi') {
            // Restore previously backed up multi prices
            $this -> MODEL__nastrojka -> restoreMultiPrices();
        }

        if ($newType === 'discount') {
            // Backup current multi prices and recalculate discount prices
            $this -> MODEL__nastrojka -> backupMultiPrices();
            $this -> recalculateDiscountPrices($settings['zenoobr']);
        }

        // --------------------------------------------------
        // 3. Save selected price type to settings
        // --------------------------------------------------
        $settings['zenoobr']['price_type'] = $newType;
        $settingsService -> set('App.general', $settings);

        return $this -> response -> setJSON(['ok' => true]);
    }

    protected function recalculateDiscountPrices(array $zenoobr) {
        // Discount percentages
        $B = (float) ($zenoobr['B_discount'] ?? 0);
        $A = (float) ($zenoobr['A_discount'] ?? 0);
        $S = (float) ($zenoobr['Spec_discount'] ?? 0);

        // Get all products with defined KKC price
        $products = $this -> MODEL__nastrojka -> get__all_product_with_priceKkc();

        foreach ($products as &$p) {

            // Base price is KKC
            $kkc = (float) $p['cenaKKC'];

            // Calculate prices using discount formula
            $p['cenaB']    = round($kkc * (1 - $B / 100), 4);
            $p['cenaA']    = round($kkc * (1 - $A / 100), 4);
            $p['cenaSpec'] = round($kkc * (1 - $S / 100), 4);

            // Update change timestamp
            $p['date_changed'] = date('Y-m-d H:i:s');
        }

        // Batch update calculated prices
        $this -> MODEL__nastrojka -> update__discountPrices($products);
    }

    public function toggleGensoftPreval() {
        if (!$this -> request -> isAJAX()) {
            return $this -> response -> setJSON(['ok' => false]);
        }

        $enabled = (int) ($this -> request -> getPost('enabled') ?? 0);

        $settingsService = service('settings');

        $general = $settingsService -> get('App.general') ?? [];

        $general['preval']['gensoft_block'] = $enabled;

        $settingsService -> set('App.general', $general);

        return $this -> response -> setJSON([
                    'ok'      => true,
                    'enabled' => $enabled
        ]);
    }

    public function save_prices_with_dds() {
        if (!$this -> request -> isAJAX()) {
            return $this -> response -> setJSON(['ok' => false]);
        }

        $settings      = service('settings') -> get('App.general') ?? [];
        $pricesWithDds = $this -> request -> getPost('settings')['prices_with_dds'] ?? 0;
        $pricesWithDds = (int) !!$pricesWithDds;

        $settings['prices_with_dds'] = $pricesWithDds;

        service('settings') -> set('App.general', $settings);

        return $this -> response -> setJSON([
                    'ok'              => true,
                    'prices_with_dds' => $pricesWithDds
        ]);
    }

    // ==== зареждане на css файлове в header на html странiцата ====
    public function addCSS() {

        return [
            'css/layouts/tables',
            'css/nastroiki/nastroiki',
            'css/nastroiki/nastroikiCronJobs',
            'css/nastroiki/nastroikiSeo',
            'css/nastroiki/nastroikiPreval',
            'css/nastroiki/nastroikiRelatedProducts',
            'plugins/jTippy_popupTitle/jTippy.min',
        ];
    }

    // ==== зареждане на js файлове в footer на html страноцата
    public function addJS($view) {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/curierLocator'
        ];

        $plugins = match ($view) {
            'seo' =>
            [
                'plugins/stickyTableHeaders/stickytableheaders',
                'plugins/tblColumnToggle/jquery.pageLength'
            ],
            'portal' =>
            [
                'plugins/ckeditor/ckeditor',
                'plugins/ckeditor/ckeditor_config',
                'plugins/ckfinder/ckfinder'
            ],
            default => [],
        };

        $default = match ($view) {
            'seo' => ['js/nastrojki/nastrojkiSeo'],
            'gensoft' => ['js/nastrojki/nastrojki'],
            'set' =>
            [
                'js/nastrojki/nastrojki',
                'js/nastrojki/nastrojkiPreval',
                'js/nastrojki/nastrojkiCronJobs',
                'js/nastrojki/nastrojkiRelatedProducts',
            ],
            'portal' => ['js/nastrojki/nastrojki_portal', 'js/nastrojki/nastrojki'],
            default => [],
        };

        $modals = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
