<?php
$request = \Config\Services::request();

$general = service('settings') -> get('App.general') ?? [];
helper('colorRows'); // Load the helper

/* --- Основни настройки ------------------------------------ */
$preval    = $general['preval'] ?? [];
$priceType = $general['zenoobr']['price_type'] ?? 'discount';
$currency  = $preval['base_currency'] ?? 'BGN';

$_isRoundedToFirst = (bool) ($ofer -> isRoundedToFirst ?? false);
$_priceAccuracy    = $_isRoundedToFirst ? 1 : ($general['priceAccuracy'] ?? 2);

/* --- Валута ---------------------------------------------- */
$_default_valutaSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв'
};

$_labelValuta = "<div class='w-50 m-auto' style='background-color:#C61111;color:#fff!important;padding:1px 6px;border-radius:4px;font-size:0.85em;'> $currency </div>";

$_mqrka = isset($mqrka) ? array_column($mqrka, null, 'sp_mqrka_id') : [];
?>

<table id="tbl_products" class="table table-striped table-bordered table-sm mt-5" cellspacing="0" width="100%">
    <thead  class="thead-dark">
        <tr>
            <th  colspan="2"></th> 
            <th class="text-center"></th> 
            <th></th>  

            <th>
                <input id="filter" class="pr-4" type="search" placeholder="<?= lang('LANG__global.placeholder.filter') ?>">
            </th>

            <th class="bg-danger" colspan="9">

                <span><?= lang('LANG__zenovaOferta.tbl.th.dilarZeni') ?></span>
            </th>   
        </tr>

        <tr class="text-center">
            <th class="w-2 align-middle"></th> 
            <th class="w-6"></th>
            <th class="w-2 align-middle"><i class="fa fa-globe"></i></th>
            <th class="w-5 align-middle"><?= lang('LANG__zenovaOferta.tbl.th.marka') ?></th>
            <th class="w-15 align-middle" data-field="name"><?= lang('LANG__zenovaOferta.tbl.th.product') ?></th>
            <th class="w-10 align-middle"><?= lang('LANG__zenovaOferta.tbl.th.description') ?></th>
            <th class="w-5 align-middle">Налич. </th> 
            <th class="w-5 align-middle"><?= lang('LANG__zenovaOferta.tbl.th.zenaB') ?><?= $_labelValuta ?></th>
            <th class="w-5 align-middle"><?= lang('LANG__zenovaOferta.tbl.th.zenaA') ?><?= $_labelValuta ?></th>
            <th class="w-5 align-middle"><?= lang('LANG__zenovaOferta.tbl.th.zenaSpec') ?><?= $_labelValuta ?></th>
            <th class="w-5 align-middle"><?= lang('LANG__zenovaOferta.tbl.th.zenaKlKl') ?><?= $_labelValuta ?></th>
            <th class="w-5 align-middle"><?= lang('LANG__zenovaOferta.tbl.th.zenaKkz') ?><?= $_labelValuta ?></th>
            <th class="w-5 align-middle"><?= lang('LANG__zenovaOferta.tbl.th.zenaDostavna') ?><?= $_labelValuta ?></th>
            <th class="w-7 align-middle"><?= lang('LANG__zenovaOferta.tbl.th.img') ?></th>
        </tr>       
    </thead>

    <tbody> 
        <?php
        if (!isset($list)) {
            return;
        }

        $_colorRows = json_decode((string) $ofer?->colorRows, true) ?? [];
        $_clRow     = [];

        foreach ($list as $key => $row) {
            $_gensoftJson = json_decode((string) $row['gensoft_json']);
            $_clRow       = generate_colorRows(['list' => $list, 'key' => $key, 'colspan' => 12, 'colorRows' => $_colorRows]);

            $_mqrka_unit = $_mqrka[$row['sp_mqrka_id']]['mqrka_unit'] ?? '';
            ?> 

            <tr class="text-center" data-id="<?= $row['product_id'] ?>"> 
                <td class="align-middle"></td> 

                <td class="action align-middle"></td> 

                <td class="align-middle" style="background: #96e1ff;">
                    <input type="checkbox" <?= !empty($row['sp_site_id']) ? 'checked' : '' ?> title="добавяне на продукта към сайт" value="1">
                </td> 

                <td class="productBrandImg align-middle">
                    <img class="mw-100 m-auto" src="<?= $row['image_brand'] != '' ? $_ENV['app.imageCasheDir'] . $row['image_brand'] . '/' . pathinfo($row['image_brand'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image_brand'], PATHINFO_EXTENSION) : '' ?>" onerror="this.onerror=null;this.src='';" data-img="<?= $row['image_brand'] ?>" alt=" ">
                </td> 

                <td class="productName align-middle text-left" <?= empty($row['gensoft_item_id']) ? '' : "title='Gensoft номеклатура: . {$row['gensoft_productName']}'" ?>>
                    <?= empty($row['product_name']) ? '<b class="bg-danger">Липсва продуктово име</b><br>' . $row['gensoft_productName'] : $row['product_name'] ?>

                    <span class="hide"><?= $row['gensoft_productName'] ?></span>

                    <div>
                        <?php
                        if ($row['gensoft_item_id']) {
                            echo '<img class="w-20" src="' . $_ENV['app.imageDataDir'] . 'logos/genSoft.jpg" alt="">';
                        }
                        // echo $_gensoftJson -> qty_safe ?? '' ? '<p class="bg-secondary m-2">' . $_ENV['app.sklad4'] . '</p>' : '';
                        ?>  
                    </div>
                </td> 

                <td class="productDesk text-left">
                    <div class="maxHeight">
                        <?= $row['description'] ?>
                    </div>

                    <?php if (!empty($row['description'])) { ?>
                        <i class="fa fa-info-circle text-primary text-center d-block cursor-pointer" data-toggle="tooltip" title="<?= htmlentities($row['description']) ?>" ></i> 
                    <?php } ?>
                </td> 

                <!--  наличност -->
                <td class="align-middle">
                    <br>

                    <?= ($row['nalichnost'] ?? 0) . ' ' . $_mqrka_unit ?>

                    <?php
                    if ($_gensoftJson -> kol_lock ?? null) {
                        echo '<div><small>запаз. - ' . $_gensoftJson -> kol_lock . $_mqrka_unit . '</small></div>';
                    }
                    ?> 

                    <?php if ($_ENV['app.gensoftEnable'] && !empty($row['gensoft_item_id'])): ?>
                        <div>
                            <button class="getGensoftInfo btn text-primary " data-route="<?= route_to('Popup_izboProduct-getGensoftInfo') ?>" data-name="<?= $row['gensoft_productName'] ?? 'null' ?>" type="button">
                                <i class="fa fa-info-circle"></i>
                            </button>
                        </div>
                    <?php endif ?>
                </td> 

                <td class="align-middle">
                    <?= $row['cenaB'] > 0 ? sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaB']) . ' ' . $_default_valutaSymbol : '' ?>
                </td> 

                <td class="align-middle">
                    <?= $row['cenaA'] > 0 ? sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaA']) . ' ' . $_default_valutaSymbol : '' ?>  
                </td> 

                <td class="align-middle">
                    <?= $row['cenaSpec'] > 0 ? sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaSpec']) . ' ' . $_default_valutaSymbol : '' ?>
                </td> 

                <td class="align-middle">
                    <?= $row['cenaKl'] > 0 ? sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaKl']) . ' ' . $_default_valutaSymbol : '' ?>
                </td>     

                <td class="align-middle">
                    <?= $row['cenaKKC'] > 0 ? sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaKKC']) . ' ' . $_default_valutaSymbol : '' ?>
                </td> 

                <td class="align-middle" style="background: #b0ff93">
                    <?= sprintf('%0.' . $_priceAccuracy . 'f', $row['price_dostavna']) . ' ' . $_default_valutaSymbol ?>
                </td> 

                <td class="productImage align-middle">
                    <?php
                    echo match ($row['badge_index']) {
                        '1' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/new_label.png"></div>',
                        '2' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/feature_label.png"></div>',
                        '3' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/hotSell.png"></div>',
                        '4' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/fix_label.png"></div>',
                        default => ''
                    };
                    ?>
                    <div class="d-flex">
                        <span class="<?= $row['image'] != '' ? 'fa fa-search-plus' : '' ?> position-absolute"></span>
                        <?php $_imgSrc = empty($row['image']) ? '' : $_ENV['app.imageCasheDir'] . $row['image'] . '/' . pathinfo($row['image'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image'], PATHINFO_EXTENSION) ?>
                        <img class="zoomImg mw-100 m-auto" src="<?= $_imgSrc ?>" data-zoom-image="<?= $_ENV['app.imageDir'] . $row['image'] ?>" onerror="this.onerror=null;this.src='                     ';" alt=" ">  
                    </div>
                </td>         
            </tr> 
            <?php
            echo implode('', $_clRow);
        }
        ?> 
    </tbody> 
</table>
