<?php
$request = \Config\Services::request();

$_mqrka = [];
if (isset($mqrka)) {
    $_mqrka = array_column($mqrka, null, 'sp_mqrka_id');
}
// SAFE CHECK - NO WARNINGS
if (is_object($ofer) && isset($ofer -> isRoundedToFirst)) {
    $_isRoundedToFirst = $ofer -> isRoundedToFirst;
} else {
    $_isRoundedToFirst = false;
}

$_isRoundedToFirst = $ofer -> isRoundedToFirst ?? false;
$_priceAccuracy    = $_isRoundedToFirst ? 1 : ($general['priceAccuracy'] ?? 2);

$preval   = service('settings') -> get('App.general')['preval'] ?? [];
$currency = $preval['base_currency'] ?? 'BGN';

$_default_valutaSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв'
};

$priceType = $general['zenoobr']['price_type'] ?? 'discount';

$urlParams = urldecode(http_build_query([
    'ctrl'       => 'zenova',
    'arg'        => $ofer -> id ?? '',
    'product_id' => '',
        ]));

$urlPrintParams = urldecode(http_build_query([
    'tab' => 'zenova',
    'id'  => $ofer -> id ?? '',
        ]));
?>

<!--  БУТОНИ В ОФЕРТАТА ЗА ЗА ЗАПИС, ИЗТРИВАНЕ, ПРЕДПЕЧАТ и др.-->
<!--  ИНФОРМАЦИЯ ОТ ДЯСНО -->
<!--  ==========================  -->
<header  class="col-auto">
    <!-- тип на оферата -->
    <h5 class="m-0"><?= lang('LANG__zenovaOferta.breadcrumbs.info') ?></h5>

    <div style="font-size: 12px;">
        <!-- дата на създаване -->
        <i class="fa fa-calendar"></i>&nbsp;<?= lang('LANG__zenovaOferta.breadcrumbs.dateCreate') . ' <br>' . ( $ofer -> date_create ?? '') ?>  

    </div>
</header>

<!--  БУТОНИ ЗА ОФЕРТАТА -->
<!--  ==========================  -->
<div class="col d-flex justify-content-end mt-2 gap-3">
    <div class="btn-group d-flex gap-5 mr-3">
        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'site')): ?>
            <a id="popupToSite" class="btn btn-default" data-route="<?= route_to('Popup_toSite-open', 'zenova') ?>" style="min-width: 80px;">
                <i class="d-flex justify-content-center fa fa-globe"></i>Сайтове
            </a>
        <?php endif ?>

        <!-- бутон избор на продукт -->
        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'prodIzbor')): ?>
            <a id="izbor-product" class="btn btn-default" data-route="<?= route_to('Popup_izboProduct-open', $urlParams) ?>" style="min-width: 150px;">
                <i class="d-flex justify-content-center fa fa-book"></i><?= lang('LANG__global.btn.izborProduct') ?>
            </a>
        <?php endif ?>

        <?php if (!$_ENV['app.gensoftEnable'] && $priceType != 'gensoft') : ?>
            <a id="new_product" class="btn btn-default" data-route="<?= route_to('Popup_editProduct-open', $urlParams) ?>" style="min-width: 160px;">
                <i class="d-flex justify-content-center fa fa-plus"></i><?= lang('LANG__global.btn.newProduct') ?>
            </a> 
        <?php endif ?>
    </div>

    <div class="btn-group d-flex gap-5">
        <!-- бутон запис на оферта -->
        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'save')): ?>
            <button id="save-ofer" class="btn btn-primary" data-delete-product="" type="submit">
                <i class="d-flex justify-content-center fa fa-save"></i><?= lang('LANG__global.btn.save') ?>
            </button> 
        <?php endif ?>

        <!-- бутон изтриване на оферта -->
        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'trash')): ?>
            <a id="delete-ofer" class="btn btn-danger text-white px-2" href="<?= route_to('Zenova-delete', $ofer -> id ?? '') ?>"  <?= empty($ofer -> id) ? 'disabled' : '' ?> onclick="javasciprt: return confirm('<?= lang('LANG__global.js.confirm.deleteOferta', [$ofer -> offersName ?? '']) ?>')">
                <i class="d-flex justify-content-center fa fa-trash"></i><?= lang('LANG__global.btn.delete') ?>
            </a>
        <?php endif ?>

        <!-- бутон предпечат -->
        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'print')): ?>
            <a id="prinPreview" class="btn btn-warning text-dark px-2" href="<?= route_to('PrintPreview', $urlPrintParams) ?>" <?= empty($ofer -> id) ? 'disabled' : '' ?> target="_blank">
                <i class="d-flex justify-content-center fa fa-print"></i><?= lang('LANG__global.btn.printPreview') ?> 
            </a> 
        <?php endif ?>

        <div class="btn-group d-flex gap-5">
            <!-- бутон ценообразуване main -->   
            <?php
            if ($priceType != 'gensoft' && $priceType != 'discount'):
                if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'zenoobr')):
                    ?>
                    <a id="zenoobrazuvane-btn" class="btn btn-success dropdown-toggle dropdown-toggle-split h-100" data-toggle="dropdown" <?= empty($ofer -> id) ? 'disabled' : '' ?>>
                        <i class="d-flex justify-content-center fa fa-dollar"></i><?= lang('LANG__global.btn.zenoobr') ?>
                    </a> 
                <?php endif ?>
            <?php endif ?>

            <ul class="dropdown-menu">
                <!-- нормално ценообр. -->
                <li class="d-flex w-100 align-items-center justify-content-center mb-1">
                    <a id="zenoobrazuvane" class="btn css-btn-save w-100" data-route="<?= route_to('Popup_zenoobrazuvane-open', $ofer -> id ?? '') ?>">Нормално
                    </a> 
                </li>

                <!-- Индивидуално ценообр. -->
                <li class="d-flex w-100 align-items-center justify-content-center">
                    <a id="zenoobrazuvanePrivate" class="btn css-btn-save w-100" data-route="<?= route_to('Popup_zenoobrazuvane-open', $ofer -> id ?? '') ?>" data-action="zenoobr" <?= empty($ofer -> chk_zonoobr) ? 'disabled' : '' ?>>Индивидуално
                    </a> 
                </li>
            </ul>
        </div>

        <!-- бутон нова оферта -->
        <a id="newOfer" class="btn btn-default px-2" href="<?= route_to('Zenova-new') ?>">
            <i class="d-flex justify-content-center fa fa-plus"></i><?= lang('LANG__global.btn.newOfer') ?>
        </a> 

        <!-- бутон отказ  -->
        <a id="exitOfer" class="btn btn-default px-2" href="<?= route_to('tabZenova') ?>">
            <i class="d-flex justify-content-center fa fa-reply-all"></i><?= lang('LANG__global.btn.cansel') ?> 
        </a> 
    </div>
</div>
