<?php
if (is_object($ofer) && isset($ofer -> isRoundedToFirst)) {
    $_isRoundedToFirst = $ofer -> isRoundedToFirst;
} else {
    $_isRoundedToFirst = false;
}

$_isRoundedToFirst = $ofer -> isRoundedToFirst ?? false;
$_priceAccuracy    = $_isRoundedToFirst ? 1 : ($general['priceAccuracy'] ?? 2);

$preval   = service('settings') -> get('App.general.preval') ?? [];
$currency = $preval['base_currency'] ?? 'BGN';

$_default_valutaSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв'
};

$priceType = $general['zenoobr']['price_type'] ?? 'discount';

$urlParams = [
    'ctrl'       => 'special',
    'product_id' => '',
    'arg'        => '',
];

$urlPrintParams = urldecode(http_build_query([
    'tab' => 'special',
    'id'  => $ofer -> id ?? '',
        ]));
?>
<!--  БУТОНИ В ОФЕРТАТА ЗА ЗА ЗАПИС, ИЗТРИВАНЕ, ПРЕДПЕЧАТ и др.-->

<!--  ИНФОРМАЦИЯ ОТ ДЯСНО -->
<!--  ==========================  -->
<header class="col-auto">
    <!-- тип на оферата -->
    <h5 class="m-0">Oферти</h5>

    <div style="font-size: 12px;">
        <!-- дата на създаване -->
        <i class="fa fa-calendar"></i>&nbsp;<?= lang('LANG__special.breadcrumbs.date_create') . '<br>' . ( $ofer -> date_create ?? '') ?>  

    </div>
</header>

<!--  БУТОНИ ЗА ОФЕРТАТА -->
<!--  =============================================  -->
<div class="col d-flex justify-content-end">
    <div class="btn-group d-flex gap-5 mr-3">

        <!-- бутон избор на ценова листа -->
        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'zenListaIzbor') && $priceType != 'gensoft'): ?>
            <a id="izbor-zenova" class="btn btn-info border-1 text-white" data-route="<?= route_to('POPup_zenovaLista-open', urldecode(http_build_query($urlParams))) ?>">
                <i class="d-flex justify-content-center fa fa-bars"></i><?= lang('LANG__global.btn.izborZenovaLista') ?>
            </a>
        <?php endif ?>

        <!-- бутон генериране на URL линк за продукти -->
        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'zenListaIzbor')): ?>
            <a id="genOfertUrlLink" class="btn btn-info border-1 text-white">
                <i class="d-flex justify-content-center fa fa-link"></i>
                <span>URL link</span>
            </a>
        <?php endif ?>

        <!-- бутон избор на продукт -->
        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'prodIzbor')): ?>
            <a id="izbor-product" class="btn btn-default border-1" data-route="<?= route_to('Popup_izboProduct-open', urldecode(http_build_query($urlParams))) ?>">
                <i class="d-flex justify-content-center fa fa-book"></i><?= lang('LANG__global.btn.izborProduct') ?>
            </a>
        <?php endif ?>

        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'newProd') && $priceType != 'gensoft'): ?>
            <a id="new_product" class="btn btn-default border-1" data-route="<?= route_to('Popup_editProduct-open', urldecode(http_build_query($urlParams))) ?>">
                <i class="d-flex justify-content-center fa fa-plus"></i><?= lang('LANG__global.btn.newProduct') ?>
            </a> 
        <?php endif ?>
    </div>

    <div class="btn-group d-flex gap-5">
        <!-- бутон запис на оферта -->
        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'save')): ?>
            <button id="save-ofer" class="btn btn-primary border-1 px-2" type="submit">
                <i class="d-flex justify-content-center fa fa-save"></i><?= lang('LANG__global.btn.save') ?></button> 
        <?php endif ?>

        <!-- бутон изтриване на оферта -->
        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'trash')): ?>
            <?php if (!in_array((int) ($ofer -> id ?? ''), explode(',', $_ENV['app.exclude_zenovaIds']))): ?>
                <a id="delete-ofer" class="btn btn-danger text-white border-1 px-2" href="<?= route_to('Special-delete', $ofer -> id ?? '') ?>" <?= empty($ofer -> id) ? 'disabled' : '' ?> onclick="javasciprt: return confirm('<?= lang('LANG__global.js.confirm.deleteOferta', [$ofer -> offersName ?? '']) ?>')">
                    <i class="d-flex justify-content-center fa fa-trash"></i><?= lang('LANG__global.btn.delete') ?></a>
            <?php endif ?>
        <?php endif ?>

        <!-- бутон клониране на поръчка -->
        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'clone') && $priceType != 'gensoft'): ?>
            <a id="cloneOfer" class="btn btn-yahoo border-1 px-2" data-route="<?= route_to('Special-clone', $urlPrintParams) ?>"
               data-name="<?= $ofer -> offersName ?? '' ?>" <?= empty($ofer -> id) ? 'disabled' : '' ?> >
                <i class="d-flex justify-content-center fa fa-clone"></i>Клонирай</a> 
        <?php endif ?>

        <!-- бутон предпечат -->
        <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'forms', 'print')): ?>
            <a id="prinPreview" class="btn border-1 px-2" href="<?= route_to('PrintPreview', $urlPrintParams) ?>"  <?= empty($ofer -> id) ? 'disabled' : '' ?> target="_blank">
                <i class="d-flex justify-content-center fa fa-print"></i><?= lang('LANG__global.btn.printPreview') ?> </a> 
        <?php endif ?>

        <!-- бутон нова оферта -->
        <a id="newOfer" class="btn btn-default border-1 px-2" href="<?= route_to('Special-new') ?>">
            <i class="d-flex justify-content-center fa fa-plus"></i><?= lang('LANG__global.btn.newOfer') ?></a> 

        <!-- бутон отказ  -->
        <a id="exitOfer" class="btn btn-default border-1 px-2" href="<?= route_to('tabSpecial') ?>">
            <i class="d-flex justify-content-center fa fa-reply-all"></i><?= lang('LANG__global.btn.cansel') ?></a> 
    </div>
</div>
