<?php

namespace App\Modules\provider\Models;

use \App\Models\BaseModel as BaseModel;

class MODEL__providerMainPage extends BaseModel {

    public function __construct() {
        parent::__construct();
    }

    // извл. на доставчиците (те са от Gensoft)
    // ======================================
    function get__providers() {

        $group_provider = $this -> db -> table('_provider_group')
                        -> orderBy('provider_group_name', 'ASC')
                        -> get() -> getResultArray();

        $provider_inGroup = $this -> db -> table('_provider_inGroup')
                        -> join('_provider', 'provider_id', 'inner')
                        -> get() -> getResultArray();

        $provider = $this -> db -> table('_provider')
                        -> get() -> getResultArray();

        return ['group' => $group_provider, 'provider_inGroup' => $provider_inGroup, 'provider' => $provider];
    }

    function autocomplete($searchName = '') {
        return $this -> db -> table(self::TBL_PROVIDER)
                        -> like('provider_name', $searchName, 'both')
                        -> get() -> getResultArray();
    }

    function create_provider($name = '') {
        $this -> db -> table(self::TBL_PROVIDER)
                -> set('provider_name', $name)
                -> insert();
    }

    function delete_provider($id = '') {
        $this -> db -> table(self::TBL_PROVIDER)
                -> where('provider_id', $id)
                -> delete();

        $this -> delete_inGroup('provider_id', $id);
    }

    function create_providerGroup($name = '') {
        $this -> db -> table(self::TBL_PROVIDER_GROUP)
                -> set('provider_group_name', $name)
                -> insert();
    }

    function save_providerGroup($data = []) {
        $this -> db -> table(self::TBL_PROVIDER_GROUP)
                -> set('provider_group_name', $data['name'])
                -> where('provider_group_id', $data['id'])
                -> update();
    }

    function delete_providerGroup($groupId = '') {
        $this -> db -> table(self::TBL_PROVIDER_GROUP)
                -> where('provider_group_id', $groupId)
                -> delete();

        $this -> delete_inGroup('provider_group_id', $groupId);
    }

    function add_inGroup($data = []) {

        $isExist = $this -> db -> table(self::TBL_PROVIDER_INGROUP)
                -> where('provider_id', $data['provider_id'])
                -> where('provider_group_id', $data['provider_group_id'])
                -> countAllResults();

        if ($isExist == 0) {
            $this -> db -> table(self::TBL_PROVIDER_INGROUP) -> insert($data);
            return $this -> db -> insertID();
        }

        return null;
    }

    function delete_inGroup($column, $value) {
        $this -> db -> table(self::TBL_PROVIDER_INGROUP)
                -> where($column, $value)
                -> delete();
    }

}
