<?php

namespace App\Modules\provider\Controllers;

use \App\Controllers\BaseController as BaseController;
use \App\Models\common\MODEL__global;
use \App\Modules\provider\Models\MODEL__providerMainPage;

class Provider_mainPage extends BaseController {

    protected $viewPath = 'Modules\provider\Views\mainPage\\';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__providerMainPage = new MODEL__providerMainPage();
        $this -> MODEL__global  = new MODEL__global();
        helper('url');
    }

    public function index() {

        $data = [
            'page_title'  => 'Табло',
            'session'     => $this -> session -> get('tabSesion'),
            'breadcrumbs' => $this -> breadcrumb -> render(),
            'message'     => session() -> getFlashdata('message'),
            'addCSS'      => $this -> addCSS(),
            'addJS'       => $this -> addJS(),
            'providers'   => $this -> MODEL__providerMainPage -> get__providers(),
            'view__table' => $this -> viewPath . 'VIEW__provider-mainPage-list'
        ];

        return $this -> render_template($this -> viewPath . 'VIEW__provider-mainPage', $data);
    }

    // създав. на нов доставчик
    public function autocomplete() {
        $searchName = $this -> request -> getVar('searchName');
        $response   = $this -> MODEL__providerMainPage -> autocomplete($searchName);

        return json_encode($response);
    }

    // създав. на нов доставчик
    public function create_provider() {
        $name = $this -> request -> getVar('provider_name');
        $this -> MODEL__providerMainPage -> create_provider($name);

        return redirect() -> back();
    }

    // създав. на нова група
    public function create_groupProvider() {
        $groupName = $this -> request -> getVar('provider_group_name');
        $this -> MODEL__providerMainPage -> create_providerGroup($groupName);

        return redirect() -> back();
    }

    // редакция на  група
    public function save_providerGroup($groupId = '') {
        $name = trim($this -> request -> getVar('doomEditElement'));

        $data = [
            'id'   => $groupId,
            'name' => $name
        ];

        $this -> MODEL__providerMainPage -> save_providerGroup($data);

        //return redirect() -> back();
    }

    // 
    public function add_inGroup($id = '') {
        $providerName = $this -> request -> getVar('providerName');

        $data = [
            'provider_id'       => $this -> request -> getVar('providerId'),
            'provider_group_id' => $this -> request -> getVar('providerGroupId')
        ];

        $lastId = $this -> MODEL__providerMainPage -> add_inGroup($data);

        $json = '';
        if ($lastId) {
            helper('providers');

            $data['lastId']        = $lastId;
            $data['provider_name'] = $providerName;
            $json                  = ['isNew' => true, 'li' => generate_li($data)];
        }

        return json_encode($json);
    }

    // премахване на дост. от група
    public function delete_inGroup($id = '') {
        $this -> MODEL__providerMainPage -> delete_inGroup('provider_id', $id);
        return redirect() -> back();
    }

    // премахване на доставчик
    public function delete_provider($id = '') {
        $this -> MODEL__providerMainPage -> delete_provider($id);
        return redirect() -> back();
    }

    // премахване на група
    public function delete_providerGroup($groupId = '') {
        $this -> MODEL__providerMainPage -> delete_providerGroup($groupId);
        return redirect() -> back();
    }

    // зареждане на css файлове в header на html странiцата
    // ====================================================
    public function addCSS() {

        return [
            'css/mainPage/mainPage',
            'css/common/treeView',
            'css/common/autocomplete_provider',
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins'
        ];

        $plugins = ['plugins/doomEdit/jquery.doomEdit'];

        $default = [
            'js/modul/provider/provider_mainPage'
        ];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

////echo json_encode($arr_merged, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT);
 //
//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
