<?php

namespace App\Modules\provider\Controllers;

use \App\Controllers\BaseController as BaseController;
use \App\Models\common\MODEL__global;
use \App\Modules\provider\Models\MODEL__provider;

class Provider extends BaseController {

    protected $viewPath = 'Modules\provider\Views\\';

    public function __construct() {
        parent::__construct();

        $this -> MODEL_provider = new MODEL__provider();
        $this -> MODEL__global  = new MODEL__global();
        helper('url');
    }

    public function index() {

        $data = [
            'page_title'  => 'Табло',
            'session'     => $this -> session -> get('tabSesion'),
            'breadcrumbs' => $this -> breadcrumb -> render(),
            'message'     => session() -> getFlashdata('message'),
            'addCSS'      => $this -> addCSS(),
            'addJS'       => $this -> addJS(),
            'providers'   => $this -> MODEL_provider -> get__providers(),
            'view__table' => $this -> viewPath . 'VIEW__provider-mainPage-list'
        ];

        return $this -> render_template($this -> viewPath . 'VIEW__provider-mainPage', $data);
    }

    public function edit($id = null) {

        //$this -> breadcrumb -> add('Home', '/');
        // $this -> breadcrumb -> add('Поръчки', '/');

        $data = [
            'page_title'     => lang('LANG__promo.breadcrumbs.info'),
            // 'breadcrumbs'    => $this -> breadcrumb -> render(),
            //'addCSS'     => $this -> addCSS(),
            'addJS'          => $this -> addJS(),
            'list'           => $this -> MODEL_provider -> get__provider($id),
            // VIEWS -----------------------------------------------------
            'view_leftAside' => $this -> viewPath . 'VIEW__provider-leftAside',
            'view_htmlTable' => $this -> viewPath . 'VIEW__provider-table',
            'view_files'     => $this -> viewPath . 'VIEW__provider-files',
            'view_actionBtn' => $this -> viewPath . 'VIEW__provider-actionBtn'
        ];

        //dd($data['list']);
        return $this -> render_template($this -> viewPath . 'VIEW__provider', $data);
    }

    public function submit($arg = 'tabProviders') {

        $form    = $this -> request -> getVar('form');
        $comment = $this -> request -> getVar('comment');

        $form['comment'] = json_encode($comment, JSON_UNESCAPED_UNICODE);

        $this -> MODEL_provider -> save__provider($form);

        return json_encode(['url' => route_to($arg)]);
    }

    // изтриване на оферта
    public function delete($id = null, $arg = 'providers') {

        if ($id) {
            $this -> MODEL_provider -> delete__provider($id);
            header('location: ' . base_url() . '?tab=' . $arg . '&page=1');
        }
    }

    // зареждане на css файлове в header на html странiцата
    // ====================================================
    public function addCSS() {

        return [
            'css/mainPage/mainPage',
            'css/common/treeView'
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins'
        ];

        $plugins = [];
        
        $default = [
            'js/modul/provider/provider'
        ];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

////echo json_encode($arr_merged, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT);
 //
//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
