<?php

namespace App\Modules\promo\Models;

use \App\Models\BaseModel as BaseModel;

class MODEL__promo extends BaseModel {

    function get__promo_by_id($id = '', $promoTip = '') {
        $promoTip = $promoTip ?? 'D';
        $table    = match ($promoTip) {
            'D' => self::TBL_PROMO,
            'K' => self::TBL_PROMOKL
        };

        $r = $this -> db -> table($table . ' o')
                        -> join(self::TBL_KLIENT . ' k', 'klient_id', 'left')
                        -> where('o.id', $id)
                        -> get() -> getRow();
        return $r;
    }

    // ИЗВЛИЧАНЕ НА продуктите в според офертата по ид
    function get__products_forOfer($id = '', $promoTip = '') {
        $promoTip = $promoTip ?? 'D';
        $table    = match ($promoTip) {
            'D' => self::TBL_PROMO,
            'K' => self::TBL_PROMOKL
        };

        $sql = $this -> db -> table($table . ' as o')
                -> join(self::TBL_PRODUCT . ' p', ' FIND_IN_SET(p.product_id, o.productsID) > 0', 'inner')
                -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' sp', 'product_id', 'left')
                -> join('(SELECT model_id,model FROM ' . self::TBL_MODEL . ' ) as pm', 'pm.model_id=p.model_id', 'left')
                -> join(self::TBL_BRAND . ' b', 'brand_id', 'left')
                -> join(self::TBL_PRODUCT_SITES . ' ps', 'product_id', 'left');

        if ($this -> db -> fieldExists('valuta_id', $table)) {
            $sql -> join(self::TBL_VALUTA . ' v', 'valuta_id', 'left');
        }

        $sql -> where('o.id', $id)
                -> groupBy('p.product_id')
                -> orderBy('FIND_IN_SET(p.product_id, o.productsID)');

        //dd();
        return $sql -> get() -> getResultArray();
    }

    // изв. на ценовото ниво за продукт/и
    function get_priceLevel_byProductIds($data = []) {

        $r = $this -> db -> table(self::TBL_PRODUCT . ' p')
                -> select('p.product_id, sp.' . $data['priceLevel'] . ' as priceLevel')
                -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' sp', 'product_id', 'left');

        if (!empty($data['productIdArr'])) {
            $r -> whereIn('p.product_id', $data['productIdArr']);

            return $r -> get() -> getResultArray();
        } else {
            $r -> where('p.product_id', $data['productId']);

            return $r -> get() -> getRow();
        }
    }

    // показва или скрива промо цена в сайт по product_id
    function show_promoPrice($productId = null, $data = []) {

        // Определяне на полето, което ще се актуализира
        $field = match ($data['promoTip']) {
            'D' => 'is_promo',
            'K' => 'is_promoKl',
        };

        $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL)
                -> set($field, $data['isChecked'] === 'false' ? null : 1)
                -> where('product_id', $productId)
                -> update();
    }

    // показва или скрива промо цена в сайт по product_id
    function showHide_promoPrice_all($productIds = [], $data = []) {
        if (empty($productIds)) {
            return ['err' => 'Грешка: липсва id на продуктите'];
        }

        $field = match ($data['promoTip'] ?? '') {
            'D' => 'is_promo',
            'K' => 'is_promoKl',
            default => null
        };

        if (!$field) {
            return ['err' => 'Грешка: Невалиден тип на промоцията'];
        }

        $this -> db -> transStart();

        $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL)
                -> set($field, $data['action'] == 'show' ? 1 : null)
                -> whereIn('product_id', $productIds)
                -> update();

        if (!$this -> db -> transComplete()) { // Commit or rollback automatically
            return ['err' => 'Грешка: при изпълнение на sql заявката'];
        }

        $actionMessage = $data['action'] === 'show' ? 'видими' : 'премахнати';
        return ['success' => "Промо цените за всички продукти са {$actionMessage} във всички сайтове."];
    }

    function save_promo($id = null, $data = []) {
        if (!$data) {
            return []; // Return empty array or default data when tab is not provided
        }

        try {
            $this -> db -> transBegin();

            // обновяване/или нов запис на оферта
            $upsertData = $data['promo'];

            $zavishenaZena_arr     = $upsertData['zavishena_zena'] ?? [];
            $deletedProductIds_arr = $upsertData['deletedProductArrId'] ?? [];
            unset($upsertData['zavishena_zena'], $upsertData['deletedProductArrId']);

            $orderTip = $_REQUEST['promoTip'] ?? null;
            $table    = match ($orderTip) {
                'D' => self::TBL_PROMO,
                'K' => self::TBL_PROMOKL,
                default => throw new \Exception("Invalid db table match")
            };

            $table2 = match ($orderTip) {
                'D' => self::TBL_PRODUCT_IN_PROMOLISTA,
                'K' => self::TBL_PRODUCT_IN_PROMOKL,
                default => throw new \Exception("Invalid db table2 match")
            };

            // Check for duplicate offersName
            $existingOffer = $this -> db -> table($table)
                            -> select('id')
                            -> where('offersName', $upsertData['offersName'])
                            -> get() -> getRow();

            if ($existingOffer && (!$id || $existingOffer -> id != $id)) {
                $this -> db -> transRollback();
                return ['err' => "Това име {$upsertData['offersName']} вече съществува. Въведете друго име."];
            }

            $oferta  = $this -> db -> table($table) -> upsert($upsertData);
            // 1- ако е нов ред, 2- update, 0 -ако данните са същите
            $last_id = ($oferta === 1) ? $this -> db -> insertID() : null;

            $productPriceJson = json_decode($upsertData['qtyPrice_json'], true);
            $promoData        = [];
            $cenaPromoKey     = $orderTip == 'D' ? 'cenaPromo' : 'cenaPromoKl';
            $zavishenaZenaKey = $orderTip == 'D' ? 'zavishena_zena' : 'zavishenaKl_zena';
            $promoKey         = $orderTip == 'D' ? 'is_promo' : 'is_promoKl';

            
            foreach ($zavishenaZena_arr as $key => $val) {
                
                $promoData[] = [
                    'product_id'      => $key,
                    $cenaPromoKey     => $productPriceJson[$key]['price'] ?? null,
                    $zavishenaZenaKey => $val == '' ? null : $val
                ];
            }

            foreach ($data['zProduct'] as &$p) {
                $p['promoLista_id'] = $last_id ?? $id;
            }

            if (!empty($deletedProductIds_arr)) {
                // премахване от PRODUCT_IN_PROMOLISTA
                $this -> db -> table($table2)
                        -> whereIn('product_id', $deletedProductIds_arr)
                        -> delete();

                //премахване на промоцената като видимост
                $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL)
                        -> set($promoKey, NULL)
                        -> whereIn('product_id', $deletedProductIds_arr)
                        -> update();
            }

            if (!empty($promoData)) {
                $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL) -> upsertBatch($promoData);
            }

            // ако са нови продукти които не пресъстват в никоя ценова листа
            $this -> db -> table($table2) -> upsertBatch($data['zProduct']);

            if (!$this -> db -> transComplete()) { // Commit or rollback automatically
                $errorMessage = $this -> db -> error()['message'];
                return ['err' => $errorMessage];
            } else {
                return $last_id ?? $id; // презарежда с нова или същест оферта
            }
        } catch (DatabaseException $e) {
            $this -> db -> transRollback();
            return $e -> getMessage();
        }
    }

    function delete_promo($id = null, $tip = '') {

        $table = match ($tip) {
            'D' => self::TBL_PROMO,
            'K' => self::TBL_PROMOKL,
            default => throw new \Exception("Invalid db table match")
        };

        $this -> db -> table($table)
                -> where('id', $id)
                -> delete();
    }

}
