<?php

namespace App\Modules\promo\Controllers;

use \App\Controllers\BaseController as BaseController;
use \App\Models\common\MODEL__global;
use \App\Models\MODEL__offer_isOpen;
use \App\Models\common\MODEL__all_oferta;
use \App\Modules\promo\Models\MODEL__promo;

class Promo extends BaseController {

    protected MODEL__all_oferta $MODEL__all_oferta;
    protected MODEL__global $MODEL__global;
    protected MODEL__promo $MODEL__promo;
    protected $viewPath = 'Modules\promo\Views\\';
    protected $tip      = 'promo';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global     = new MODEL__global();
        $this -> MODEL__all_oferta = new MODEL__all_oferta();
        $this -> MODEL__promo      = new MODEL__promo();

        helper('url');
    }

    public function index() {
        $settings = service('settings');
        $general  = $settings -> get('App.general') ?? [];
        $preval   = $settings -> get('App.general.preval') ?? [];

        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $promoTip = $urlParams['promoTip'] ?? null;
        $id       = $urlParams['id'] ?? null;

        if (is_numeric($id)) {
            $this -> session -> set('oferId', $id);
            $this -> session -> set('openedTab', $this -> tip);
        }

        //$this -> breadcrumb -> add('Home', '/');
        // $this -> breadcrumb -> add('Поръчки', '/');

        $data = [
            'page_title'             => 'Промоции',
            // 'breadcrumbs'    => $this -> breadcrumb -> render(),
            'addCSS'                 => $this -> addCSS(),
            'addJS'                  => $this -> addJS(),
            'ofer'                   => $this -> MODEL__promo -> get__promo_by_id($id, $promoTip),
            'status'                 => $this -> MODEL__global -> get__status(),
            'shablon'                => $this -> MODEL__global -> get__shablons(),
            'list'                   => $this -> MODEL__promo -> get__products_forOfer($id, $promoTip),
            'mqrka'                  => $this -> MODEL__global -> get__mqrka(),
            'valuta'                 => $this -> MODEL__global -> get__valuta(),
            'modulTip'               => $this -> tip,
            'general'                => $general,
            'preval'                 => $preval,
            // VIEWS -----------------------------------------------------
            'view_global_klientData' => 'common/VIEW__glob-klientData',
            'view_leftAside'         => $this -> viewPath . 'VIEW__promo-leftAside',
            'view_htmlTable'         => $this -> viewPath . 'VIEW__promo-table',
            'view_files'             => $this -> viewPath . 'VIEW__promo-files',
            'view_actionBtn'         => $this -> viewPath . 'VIEW__promo-actionBtn'
        ];

        //dd($data['list']);
        return $this -> render_template($this -> viewPath . 'VIEW__promo', $data);
    }

    // изв. на ценовото ниво за продукт/и
    public function getPriceLevel() {

        $priceLevel   = $this -> request -> getVar('priceLevel');
        $productId    = $this -> request -> getVar('productId');
        $productIdArr = $this -> request -> getVar('productIdArr');

        $data = [
            'priceLevel'   => $priceLevel,
            'productId'    => $productId,
            'productIdArr' => $productIdArr,
        ];

        $response = $this -> MODEL__promo -> get_priceLevel_byProductIds($data);

        $json = empty($productIdArr) ? ['priceLevel' => $response -> priceLevel] : ['allLevel' => $response];

        return json_encode($json);
    }

    public function showPromoPrice_onSite($productId = null, $promoTip = null) {
        $isChecked = $this -> request -> getVar('isChecked');

        $data = [
            'promoTip'  => $promoTip,
            'isChecked' => $isChecked,
        ];

        $this -> MODEL__promo -> show_promoPrice($productId, $data);
    }

    // за всички продукти показвне на промо цената в сайтове
    public function showHidePromoPrice_all_onSite() {
        $action     = $this -> request -> getVar('action') ?? null;
        $promoTip   = $this -> request -> getVar('promoTip') ?? null;
        $productIds = $this -> request -> getVar('productIds') ?? null;

        $data = [
            'action'   => $action,
            'promoTip' => $promoTip,
        ];

        $response = $this -> MODEL__promo -> showHide_promoPrice_all($productIds, $data);
        return json_encode($response);
    }

    public function submit() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $promoTip = $urlParams['promoTip'] ?? null;
        $id       = $urlParams['id'] ?? null;

        $form                = json_decode($this -> request -> getVar('form'), true);
        $deletedProductArrId = array_filter($this -> request -> getVar('deletedProductArrId'));

        $form['promo'] = $this -> changeArr($form['promo'] + ($form['colorRows'] ?? []) + ['deletedProductArrId' => $deletedProductArrId], [
            'all'    => [
                'json' => [
                    'colorRows',
                    'qtyPrice_json'
                ],
                'imp'  => ['productsID']
            ],
            'update' => [
                'user' => 'userName_modify',
                'date' => 'date_update'
            ],
            'create' => [
                'user' => 'userName_create',
                'date' => 'date_create' // име на sql колоната 
            ]
                ], $id, true);

        array_merge($form['promo'], $form['autocomplete'] ?? []);

        $response = $this -> MODEL__promo -> save_promo($id, $form);

        if (isset($response['err'])) {
            return json_encode($response, JSON_UNESCAPED_UNICODE);
        }

        // ако е нова оферта се заклучва към потребителя който я е създал
        if (!is_numeric($id) && !empty($response)) {
            $MODEL__offer_isOpen = new MODEL__offer_isOpen();
            $MODEL__offer_isOpen -> checkAndLockOffer($response, $this -> tip, $this -> user -> id);
        }

        return json_encode(['id' => $response]); // last id на оферта ако е нова оферта
    }

    // изтриване на оферта
    public function delete() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $promoTip = $urlParams['arg'] ?? null;
        $id       = $urlParams['id'] ?? null;

        if ($id) {
            $this -> MODEL__promo -> delete_promo($id, $promoTip);
            return redirect() -> to(html_entity_decode(route_to('tabPromo', "promoTip=$promoTip")));
        }
    }

    // зареждане на css файлове в header на html странiцата
    // ====================================================
    public function addCSS() {

        return [
            'plugins/currency-flags/currency-flags',
            'css/layouts/autocomplete',
            'css/layouts/global',
            'css/layouts/tables',
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/choose-color/choose-color',
            'plugins/tableRow_move/tableRow_move',
            'plugins/jqueryAlert/jqueryConfirm',
            'plugins/timepicker/datepicker',
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/klient_modify_inOfer',
            'js/_Global/inOfer/leftAsideActions',
            'js/_Global/inOfer/tableActions',
        ];

        $plugins = [
            'plugins/sessionOferTimeout/jquery.idleCat.min',
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/tableRow_move/tableRow_move',
            'plugins/jqueryAlert/jqueryConfirm',
            'plugins/img/jquery.elevatezoom',
            'plugins/tableSearchRow/tableSearchRow',
            //'plugins/stickyTableHeaders/jquery.table.freezeHeader',
            'plugins/stickyTableHeaders/stickytableheaders',
            'plugins/timepicker/datepicker',
            'plugins/choose-color/choose-color',
        ];
        $default = ['js/modul/promo/promo'];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

////echo json_encode($arr_merged, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT);
 //
//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
