<?php
$level                 = $ctrl['level'];
$singleChildCategoryId = $ctrl['singleChildCategoryId'];
$childCategoriesArr    = $ctrl['childCategoriesArr'];
$catAtributes          = $ctrl['catAtributes'];
$routeNew              = route_to('POPup_categoryAttr-save', "new=1&childCatId=$singleChildCategoryId");
?>


<div class="input-group p-2" role="group">
    <input id="js-inputValue" class="form-control"  type="text"  placeholder="Нова характеристика">

    <div class="input-group-append">
        <button id="js-create_newAtributes" class="btn btn-success"
                data-route="<?= $routeNew ?>"
                type="button">

            <i class="fa fa-plus"></i>&nbsp;Добави
        </button>
    </div>
</div> 

<!-- breadcrumbs -->
<small class="col mb-1">
    <?php
    if (!empty($childCategoriesArr)) {
        $names = array_column($childCategoriesArr, 'name');
        echo '<mark><i>' . implode('&nbsp;<i class="fa fa-angle-right"></i>&nbsp;', $names) . '</i><mark>';
    }
    ?>
</small>

<?php
if (empty($catAtributes)) {
    echo '<p class="col text-danger mt-2">Няма харалтеристики за избраната подкатегория.</p>';
}

if (!empty($catAtributes)) :
    ?>
    <ul id="js-sortable" class="ul-sortable list-unstyled pl-3">
        <?php
        foreach ($catAtributes as $i => $row) :
            $id    = $row['category_characteristic_id'];
            $pos   = $row['category_char_position'] ?? '';
            $clTxt = $row['is_visible'] == 0 ? '' : 'text-info';
            $clEye = $row['is_visible'] == 0 ? '-slash' : '';
            $name  = $row['value'];
            $coint = $i + 1 . '.';

            $routeReorder = route_to('POPup_categoryAttr-reorder');
            $routeVisible = route_to('POPup_categoryAttr-isVisible', $row['category_characteristic_id']);
            $routeSave    = route_to('POPup_categoryAttr-save', "curentId=$id&childCatId=$singleChildCategoryId");
            $routeDelete  = route_to('POPup_categoryAttr-delete', $row['category_characteristic_id']);
            ?>

            <li class="p-2 d-flex border-bottom" data-id="$id" data-sub-id="<?= $singleChildCategoryId ?>" data-pos="<?= $pos ?>">

                <span class="count"><?= $coint ?></span>

                <div class="btnGroup btn-group">
                    <!-- местене на реда -->
                    <i class="fa fa-arrows p-1"></i>

                    <!-- ръчно определяне на позицията на реда -->
                    <i class="rowPosition p-1 border-0 fa fa-list" data-route="<?= $routeReorder ?>" title="Преместване на този ред на конкретна позиция"></i>

                    <!-- дали да се показва в сайта -->
                    <i class="isVisibleCatAttr <?= $clTxt ?> btn-outline-secondary p-1 border-0 fawhite fa fa-eye$clEye" data-route="<?= $routeVisible ?>"></i>

                    <!-- редакция -->
                    <i class="edit btn-outline-primary text-primary p-1 fawhite fa fa-edit" data-route="<?= $routeSave ?>" title="редакция"></i>

                    <!-- изтриване -->
                    <i class="delete btn-outline-danger text-danger fawhite p-1 fa fa-trash" data-route="<?= $routeDelete ?>" title="изтриване"></i>
                </div>

                <label class="name"><?= $name ?></label>
            </li>

        <?php endforeach; ?>
    </ul>
<?php endif; ?>
