<?php

// Рекурсивна функция за дървото (може да се сложи в helper или директно във view)
function renderSubCategories($categories, $rootCatId, $level = 1, $breadcrumb = []) {
    $out = '';

    foreach ($categories as $cat) {
        if ((int) $cat['parent_id'] !== (int) $rootCatId) {
            continue;
        }

        $categoryId    = (int) $cat['category_id'];
        $categoryTitle = esc($cat['category_name']);

        $hasChildren = (bool) array_filter($categories, fn($c) => (int) $c['parent_id'] == $categoryId);
        $iconFolder  = $hasChildren ? '<i class="css-icon-hover fa fa-folder"></i>' : '';

        // Бутон "Добави" само ако не е достигнато 5-то ниво
        // "Добави" бутон до 4-то ниво
        $btnAdd = ($level < 4) ? '<button class="css-icon-hover btn-showAddSubForm btn btn-outline-success border-0 px-1 py-0 btn-sm" data-action="new"><i class="fa fa-plus"></i></button>' : '';

        // data-root-id само на първо ниво подкатегории
        $attrRootId = ($level == 1) ? "data-root-id='$rootCatId'" : '';

        $route_new             = route_to('POPup_category-save2', $categoryId, 'new');
        $route_edit            = route_to('POPup_category-save2', $categoryId, 'edit');
        $route_delete          = route_to('POPup_category-delete2', $categoryId);
        $route_removeImage     = route_to('POPup_category-setImage');
        $route_reorderPosition = route_to('POPup_category-reorder2');
        $route_changeParent    = route_to('POPup_category-changeParent');
        $route_setImage        = route_to('POPup_category-setImage');
        $route_seo             = route_to('POPup_category-seo', $categoryId);

        // Активен/отворен клас (ако breadcrumb е подаден)
        $isActive    = in_array((string) $categoryId, $breadcrumb);
        $liClass     = $isActive ? ' active' : '';
        $styleCursor = $hasChildren ? 'cursor:pointer' : '';

        // Дали да показваш децата разгънати (ако е по пътя)
        $children = renderSubCategories($categories, $categoryId, $level + 1, $breadcrumb);

        $imagePath      = $cat['image_cat'] ?? '';
        $hasImage       = !empty($imagePath);

        $cameraClass    = $hasImage ? 'd-none' : '';
        $removeBtnClass = $hasImage ? '' : 'invisible';
        $zoomBtnClass   = $hasImage ? '' : 'invisible';
        $imgSrc         = $hasImage ? ($_ENV['app.imagePortalDir'] . $imagePath) : '';

        $out .= <<<HTML
                <li class="py-1 $liClass" $attrRootId data-id="$categoryId" data-title="$categoryTitle" style="$styleCursor">
                  <div class="category-row d-flex p-0" data-id="$categoryId">
                   <span class="child category-icon">$iconFolder</span>
                   
                    <div class="image-block d-flex">
                        <!-- Премахни бутонче -->
                        <span class="removeCatImg btn btn-sm btn-danger rounded-0 $removeBtnClass" data-route="$route_removeImage" title="Премахни"><i class="fa fa-times"></i></span>
                
                        <span class="zoomImg btn btn-sm btn-secondary rounded-0 px-1 mr-2 $zoomBtnClass"><i class="fa fa-search-plus"></i></span>

                        <button class="catImg border-1" type="button" data-route="$route_setImage">
                            <i class="camera fa fa-camera px-2 text-secondary border-0 $cameraClass"></i>
                            <img class="js-image" src="$imgSrc" alt=" " onerror="this.onerror=null;this.src='';" style="width: 20px;">
                        </button>
                    </div>
                   
                   <span class="cat-title flex-fill w-50">$categoryTitle</span>

                    <div class="btnGroup">
                        $btnAdd
                       <!-- SEO -->
                       <button class="css-icon-hover btn-seo btn border-0 px-1 py-0 btn-sm" data-action="seo" data-route="$route_seo" title="SEO настройки">
                           <i class="fa fa-star-o"></i>
                       </button>
                
                       <!-- Edit -->
                       <button class="css-icon-hover btn-edit btn btn-outline-info border-0 px-1 py-0 btn-sm" data-action="edit" data-route="$route_edit"><i class="fa fa-edit"></i></button>
                       
                       <!-- Delete -->
                       <button class="css-icon-hover btn-del btn btn-outline-danger border-0 px-1 py-0 btn-sm" data-route="$route_delete"><i class="fa fa-trash"></i></button>
                        
                       <!-- Move -->
                       <span class="css-icon-hover btn btn-sm fa fa-arrows-alt px-1 handle" data-route-reorder="$route_reorderPosition" data-route-changeparent="$route_changeParent" style="cursor:move"></span>
                     </div>
                  </div>
                    
                  <div class="showAddSubForm ml-3 hide">
                    <div class="css-text-purple breadcrumbs col mb-1"></div>
                    <div class="input-group">
                        <div class="input-group-append d-flex col">
                          <input class="name css-focus-strong css-border-none form-control form-control-sm round-10 css-input-p" type="text" placeholder="Въведете име на нова подкатегория">
                          <button class="submit-new-subCat css-btn-save round-10 btn btn-success btn-sm" data-route="$route_new" type="button">Запис</button>
                          <button class="css-btn-close round-10 btn btn-sm btn-cancel" type="button">Отказ</button> 
                        </div>
                    </div>
                 </div>
            HTML;

        if ($children) {
            $style = $isActive ? '' : 'display:none';
            $out   .= "<ul class=\"category-tree\" data-parent-id=\"$categoryId\"  style=\"$style\">$children</ul>";
        }

        $out .= '</li>';
    }
    return $out;
}
?>

<div class="row py-4">
    <!-- Лява колона: главни категории -->
    <div id="block-mainCat" class="col-5 pr-2" style="border-right: 1px solid #a0adf6;">
        <h5><i class="fa fa-cube"></i>&nbsp;Главни категории</h5> 

        <input id="mainCatSearch" class="mb-2 round-10 css-input-p css-focus-strong" placeholder="Търсене в главни категории">

        <!-- създаване на нова главна категория-->
        <div id="block-createRootCat" class="input-group w-75">
            <input id="rootCatName" class="form-control form-control-sm css-focus-strong rounded-left" type="text" placeholder="Въведете име на нова главна категория">

            <div class="input-group-append">
                <button id="btn-createRootCat" class="btn-sm btn btn-primary css-btn-save rounded-right" data-route="<?= route_to('POPup_category-save2', 'null', 'new') ?>">
                    <i class="fa fa-save"></i>
                </button>
            </div>
        </div>

        <br>

        <ul id="mainCat" class="treeview p-2 list-group ul-root">
            <?php
            foreach ($mcats as $row) :
                $_isActive = in_array($row['category_id'], $breadcrumbs) ? 'active' : '';
                $_hasImage = !empty($row['image_cat']);

                if ($_isActive == 'active') {
                    $_rootCatId = $row['category_id'];
                }
                ?>
                <li class="row py-1 align-items-center <?= $_isActive ?>" data-id="<?= $row['category_id'] ?>" data-title="<?= $row['category_name'] ?>" data-isroot="1">   
                   
                    <div class="category-row flex-fill p-0">
                        <span class="category-icon pl-1">
                            <i class="fa <?= !empty($row['isChildren']) ? 'fa-angle-right text-primary' : '' ?>"></i>
                        </span>

                        <div class="image-block d-flex">
                            <!-- Премахни бутонче -->
                            <span class="removeCatImg <?= $_hasImage ? '' : 'invisible' ?> btn btn-sm btn-danger rounded-0" data-route="<?= route_to('POPup_category-setImage') ?>" title="Премахни"><i class="fa fa-times"></i></span>

                            <span class="zoomImg <?= $_hasImage ? '' : 'invisible' ?> btn btn-sm btn-secondary rounded-0 px-1 mr-2"><i class="fa fa-search-plus"></i></span>

                            <button class="catImg border-1" type="button" data-route="<?= route_to('POPup_category-setImage') ?>">
                                <i class="camera fa fa-camera px-2 text-secondary border-0 <?= $_hasImage ? 'd-none' : '' ?>"></i>

                                <img class="js-image" src="<?= $_ENV['app.imagePortalDir'] . $row['image_cat'] ?>" alt=" " onerror="this.onerror=null;this.src='';" style="width: 20px;">
                            </button>
                        </div>

                        <label class="categoryName cat-title flex-fill"><?= $row['category_name'] ?></label>

                        <div class="btnGroup">
                            <!-- SEO Settings button -->
                            <button class="btn-seo btn css-icon-hover"
                                    data-action="seo"
                                    data-route="<?= route_to('POPup_category-seo', $row['category_id']) ?>"
                                    title="SEO настройки">
                                <i class="fa fa-star-o"></i>
                            </button>

                            <!-- Edit button -->
                            <button class="btn-editRoot btn btn-outline-info border-0 px-1" data-route="<?= route_to('POPup_category-save2', $row['category_id'], 'edit') ?>" title="Редактирай"><i class="fa fa-edit"></i></button>

                            <!-- Delete button -->
                            <button class="btn-del btn btn-outline-danger px-1 border-0" data-route="<?= route_to('POPup_category-delete2', $row['category_id']) ?>" title="Изтрий"><i class="fa fa-trash"></i></button>

                            <!-- Move button -->
                            <span class="btn btn-sm fa fa-arrows-alt px-1 handle" data-route-reorder="<?= route_to('POPup_category-reorder2') ?>" data-route-changeparent="<?= route_to('POPup_category-changeParent') ?>"  style="cursor:move"></span>
                        </div>
                    </div>
                <?php endforeach ?>
        </ul>
    </div>

    <!-- Дясна колона: подкатегории -->
    <div id="block-subCat" class="col">
        <h5><i class="fa fa-sitemap"></i>&nbsp;Подкатегории на главна категория <span id="breadcrumbs" class="css-text-purple"><?= $activeMainCatText ?? '' ?></span></h5>

        <input id="subCatSearch" class="mb-2 round-10 css-input-p css-focus-strong" placeholder="Търсене в подкатегории">

        <!-- създаване на нова подкатегория към главна категория-->
        <div id="block-createSubCat_to_rootCat" class="input-group <?= empty($breadcrumbs) ? 'hide' : '' ?>">
            <div class="col"></div>
            <div class="d-flex col input-group-append">
                <input class="name form-control form-control-sm css-focus-strong rounded-left" type="text" placeholder="въведете име на нова подкатегория">

                <button class="submit-new-subCat btn btn-sm css-btn-save rounded-right" data-root-id="<?= $_rootCatId ?? '' ?>" data-route="<?= route_to('POPup_category-save2', $_rootCatId ?? 'null', 'new') ?>" type="button">
                    <i class="fa fa-save"></i>
                </button>
            </div>
        </div>

        <br>

        <!-- Дървото се дефинира тук! -->
        <?php foreach ($mcats as $row): ?>
            <ul id="tree-<?= $row['category_id'] ?>"
                class="category-tree treeview pl-1"
                data-parent-id="<?= $row['category_id'] ?>"
                style="<?= in_array($row['category_id'], $breadcrumbs) ? '' : 'display:none' ?>">
                    <?= renderSubCategories($scats, $row['category_id'], $level = 1, $breadcrumbs) ?>
            </ul>
        <?php endforeach ?>
    </div>
</div>


<script>
    $(document).on('submit', '#form-category-seo', function (e) {
        e.preventDefault();

        const $form = $(this);
        const actionUrl = $form.attr('action');
        const formData = $form.serialize();

        $.post(actionUrl, formData, function (response) {
            if (response.status === 'success') {
                $('#modal_categorySEO').modal('hide');
                showSuccessModal(response.message || 'SEO settings saved successfully.');
                setTimeout(() => {
                    location.reload();
                }, 2000);
            }
            else {
                alert('Error saving SEO settings.');
            }
        }).fail(function (xhr) {
            alert('Request failed: ' + xhr.status);
            console.error(xhr.responseText);
        });
    });

    function showSuccessModal (message) {
        $('#modal_success').remove();
        const modalHTML = `
    <div class="modal fade" id="modal_success" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content border-success">
          <div class="modal-header bg-success text-white py-2">
            <h6 class="modal-title"><i class="fa fa-check-circle mr-1"></i> Success</h6>
            <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
              <span>&times;</span>
            </button>
          </div>
          <div class="modal-body text-center">
            <p class="mb-0">${message}</p>
          </div>
        </div>
      </div>
    </div>`;
        $('body').append(modalHTML);
        const $m = $('#modal_success');
        $m.modal('show');
        setTimeout(() => $m.modal('hide'), 1800);
    }
</script>
