<!-- доставчик  modal -->
<div class="modal fade" id="modal_valuta" tabindex="-1"  data-backdrop="static" data-keyboard="false" role="dialog">
    <div class="modal-dialog mx-auto m-0" role="document" style="max-width: 40vw;">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><?= lang('popup/LANGpop__valuta.title') ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>

            <div class="modal-body overflow-auto" style="max-height: 75vh">

                <table id="tbl_valuta" class="table-striped table-bordered table-sm" cellspacing="0" width="100%" >
                    <thead class="bg-black">
                        <tr>
                            <th></th>
                            <th><?= lang('popup/LANGpop__valuta.label.name') ?></th>
                            <th><?= lang('popup/LANGpop__valuta.label.code') ?></th>
                            <th><?= lang('popup/LANGpop__valuta.label.symbol') ?></th>
                            <th><?= lang('popup/LANGpop__valuta.label.value') ?></th>
                            <th><?= lang('popup/LANGpop__valuta.label.default') ?></th>
                            <th></th>
                        </tr>
                        <tr>
                            <th></th>
                            <th><input name="valuta_name" type="text"></th>
                            <th><input name="valuta_code" type="text"></th>
                            <th><input name="valuta_symbol" type="text"></th>
                            <th><input name="valuta_val" type="text"></th>
                            <th></th>

                            <th class="action"> 
                                <button class="save btn py-0" data-route="<?= route_to('POPup_valuta-save') ?>" type="button">
                                    <i class="bg-white p-1 border-0 fa fa-plus"></i>
                                </button>
                            </th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php foreach ($list as $row) { ?>
                            <tr data-id="<?= $row['valuta_id'] ?>">

                                <td></td>

                                <td>
                                    <input class="id"
                                           name="valuta_id"
                                           type="hidden" 
                                           value="<?= $row['valuta_id'] ?>">

                                    <input name="valuta_name"
                                           type="hidden" 
                                           value="<?= $row['valuta_name'] ?>">

                                    <span> <?= $row['valuta_name'] ?></span> 
                                </td>

                                <td>
                                    <input name="valuta_code"
                                           type="hidden" 
                                           value="<?= $row['valuta_code'] ?>">

                                    <span> <?= $row['valuta_code'] ?></span>
                                </td>

                                <td>
                                    <input name="valuta_symbol"
                                           type="hidden" 
                                           value="<?= $row['valuta_symbol'] ?>">

                                    <span> <?= $row['valuta_symbol'] ?></span>

                                </td>

                                <td> 
                                    <input name="valuta_val"
                                           type="hidden" 
                                           value="<?= $row['valuta_val'] ?>">

                                    <span> <?= $row['valuta_val'] ?></span>
                                </td>

                                <td>
                                    <input class="isDefault" name="valuta_isDefault" data-route="<?= route_to('POPup_valuta-set_defaultValuta', $row['valuta_id'], $row['valuta_name']) ?>" type="radio" value="Y" <?= $row['valuta_isDefault'] == 'Y' ? 'checked' : '' ?>>
                                </td>

                                <td class="action text-center">

                                    <div class="btnGroup1 btn-group btn-group-sm">
                                        <button type="button" class="edit btn">
                                            <i class="btn-outline-primary p-1 border-0 fa fa-edit"></i>
                                        </button>

                                        <button class="delete btn" data-route=" <?= route_to('POPup_valuta-delete', $row['valuta_id'], $row['valuta_name']) ?>" data-name="<?= $row['valuta_name'] ?>" type="button">
                                            <i class="btn-outline-danger p-1 border-0 fa fa-trash"></i>
                                        </button>
                                    </div>

                                    <div class="btnGroup2 btn-group btn-group-sm hide">
                                        <button type="button" class="save btn" data-route="<?= route_to('POPup_valuta-save') ?>">
                                            <i class="btn-outline-primary p-1 border-0 fa fa-save"></i>
                                        </button>

                                        <button type="button" class="cansel btn">
                                            <i class="btn-outline-secondary p-1 border-0 fa fa-reply-all"></i>
                                        </button>
                                    </div>

                                </td>
                            </tr>
                        <?php } ?>
                    </tbody> 
                </table>   

            </div>

            <div class="modal-footer">
                <b class="col text-red"><?= lang('LANG__global.requiredFields') ?></b>
                <div class="btn-group  btn-group"> 
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?= lang('LANG__global.btn.cansel') ?></button> 
                </div>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->

    <?php if (isset($addJS) && is_array($addJS)) { ?>
        <?php foreach ($addJS as $js) { ?>
            <script src="<?= auto('assets/' . $js . '.js'); ?>"></script>
        <?php } ?>
    <?php } ?>    

    <script>
        var LANGpop__valuta = <?php print_r(json_encode(lang('popup/LANGpop__valuta.js'))) ?>
    </script> 
</div><!-- /.modal -->
