<?php
$_locale    = service('settings') -> get('App.defaultLocale');
$_isGensoft = $_ENV['app.gensoftEnable'];
?>

<div id="modal_mqrka" class="modal fade" tabindex="-1"  data-backdrop="static" data-keyboard="false" role="dialog" aria-hidden="true" style="z-index:5000">

    <!-- --- ЗАРЕЖДАНЕ НА CSS ОТ CONTROLLER --- -->
    <?php if (isset($addCSS) && is_array($addCSS)) { ?>
        <?php foreach ($addCSS as $css) { ?>
            <link rel="stylesheet" type="text/css" href="<?= auto('assets/' . $css . '.css'); ?>">
        <?php } ?>
    <?php } ?>

    <div class="modal-dialog modal-dialog-centered w-30 mw-100" role="document">
        <div id="modal-fullscreen" class="css-background css-box-shadow modal-content">
            <div class="modal-header p-2">
                <h4 class="modal-title"><?= lang('popup/LANGpop__mqrka.title') ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>

            <?php if ($_isGensoft): ?>
                <div class="row col">
                    <div class="col-2">
                        <img class="w-100" src="<?= $_ENV['app.imageDataDir'] ?>logos/genSoft.jpg" alt="">
                    </div>

                    <div class="col">
                        <div class="fw-400 font-size-13">Мерните единици идват от Gensoft</div>
                        <div class="fw-400 font-size-13">При промяна на мер. ед. в Gensoft ще бъде отразена и тук</div>
                    </div>
                </div>
            <?php endif ?>

            <div class="modal-body overflow-auto" style="height: calc(100vh - 200px);">
                <div class="container-fluid">
                    <div id="html" class="row justify-content-between" data-route="<?= route_to('POPup_mqrka-open') . '?isRefresh=1' ?>">

                        <table class="table table-striped table-sm" cellspacing="0" width="100%">
                            <thead class="css-background text-center">
                                <?php if (!$_isGensoft): ?>
                                    <tr>
                                        <th>
                                            <!--  Въвеведете имe -->
                                            <input class="name css-input-p css-focus-strong css-border-none" name="mqrka_name" type="text" placeholder="<?= lang('popup/LANGpop__mqrka.placeholder.enterName') ?>">
                                        </th>

                                        <th>
                                            <!--  Въвеведете символ -->
                                            <input class="unit css-input-p css-focus-strong css-border-none" name="mqrka_unit" type="text">
                                        </th>

                                        <th></th>

                                        <th>
                                            <i class="save btn-outline-primary p-1 border-0 fa fa-save float-right clearfix mr-1" data-route="<?= route_to('POPup_mqrka-save') ?>" title="<?= lang('LANG__global.btn.save') ?>"></i>
                                        </th>
                                    </tr>
                                <?php endif ?>

                                <tr>
                                    <?php if (!$_isGensoft): ?>
                                        <th class="w-50 text-left">
                                            <?= lang('popup/LANGpop__mqrka.tbl.th.name') ?>
                                        </th>
                                    <?php endif ?>

                                        <th class="text-left">
                                        <?= lang('popup/LANGpop__mqrka.tbl.th.symbol') ?>
                                    </th>

                                    <th class="w-10">Тип</th>

                                    <?php if (!$_isGensoft): ?>
                                        <th class="w-2"></th>
                                    <?php endif ?>
                                </tr>
                            </thead>

                            <tbody>
                                <?php foreach ($mqrka as $row) { ?>
                                    <tr class="notAutoNum" data-id="<?= $row['sp_mqrka_id'] ?>">
                                        <?php if (!$_isGensoft): ?>
                                            <td>
                                                <input class="id"
                                                       name="sp_mqrka_id"
                                                       type="hidden" 
                                                       value="<?= $row['sp_mqrka_id'] ?>">

                                                <input class="name"
                                                       name="mqrka_name"
                                                       type="hidden" 
                                                       value="<?= $row['mqrka_name'] ?>">

                                                <span> <?= $row['mqrka_name'] ?></span> 
                                            </td>
                                        <?php endif ?>

                                        <td>
                                            <input class="unit"
                                                   name="mqrka_unit"
                                                   type="hidden" 
                                                   value="<?= $row['mqrka_unit'] ?>">

                                            <span> <?= $row['mqrka_unit'] ?></span>      
                                        </td>

                                        <td>
                                            <select class="mqrka_tip css-dropdown-p css-focus-strong css-border-none" name="mqrka_tip" data-route="<?= route_to('POPup_mqrka-changeTip', $row['sp_mqrka_id']) ?>">

                                                <option value="">---</option>
                                                <option value="K"  <?= $row['mqrka_tip'] == 'K' ? 'selected' : '' ?>>количество</option>
                                                <option value="T"  <?= $row['mqrka_tip'] == 'T' ? 'selected' : '' ?>>тегло</option>
                                                <option value="R"  <?= $row['mqrka_tip'] == 'R' ? 'selected' : '' ?>>размер</option>
                                            </select>      
                                        </td>

                                        <?php if (!$_isGensoft): ?>
                                            <td>
                                                <div class="btnGroup1 btn-group btn-group-sm float-right">                                           <!-- редакция -->
                                                    <i class="edit btn-outline-primary p-1 border-0 fa fa-edit" title="<?= lang('LANG__global.btn.edit') ?>"></i>

                                                    <!-- изтриване -->
                                                    <i class="delete btn-outline-danger p-1 border-0 fa fa-trash" data-route="<?= route_to('POPup_mqrka-delete', $row['sp_mqrka_id'], $row['mqrka_name'] ?? '') ?>" data-name="<?= $row['mqrka_name'] ?>" title="<?= lang('LANG__global.btn.delete') ?>"></i>
                                                </div>

                                                <div class="btnGroup2 btn-group btn-group-sm float-right hide">
                                                    <i class="save btn-outline-primary p-1 border-0 fa fa-save" data-route="<?= route_to('POPup_mqrka-save') ?>" title="<?= lang('LANG__global.btn.save') ?>"></i>
                                                    <i class="cansel btn-outline-danger p-1 border-0 fa fa-reply-all" title="<?= lang('LANG__global.btn.cansel') ?>"></i>
                                                </div>
                                            </td>
                                        <?php endif ?>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="modal-footer">
                <div class="btn-group  btn-group-sm">
                    <button type="button" class="btn btn-default round-10" data-dismiss="modal"><?= lang('LANG__global.btn.cansel') ?></button> 
                </div>
            </div>
        </div><!-- /.modal-content -->


        <?php if (isset($addJS) && is_array($addJS)) { ?>

            <?php foreach ($addJS as $js) { ?>
                <script src="<?= auto('assets/' . $js . '.js'); ?>"></script>
            <?php } ?>
        <?php } ?>   

        <script>
            var LANGpop__mqrka = <?php print_r(json_encode(lang('popup/LANGpop__mqrka.js'))) ?>
        </script>   
    </div><!-- /.modal-dialog -->
</div>
