<?php
/* --- Основни настройки ------------------------------------ */
$settings = service('settings') -> get('App.general') ?? [];
helper('utils'); // helper 

$preval    = $settings['preval'] ?? [];
$zenoobr   = $settings['zenoobr'] ?? [];
$priceType = $zenoobr['price_type'] ?? '';
$currency  = $preval['base_currency'] ?? 'BGN';

/* --- Валута ---------------------------------------------- */
$_default_valutaCode = $currency;

/* --- Цени -------------------------------------------------- */
$_pricesWithDds = !empty($settings['prices_with_dds']);
//$_gensoftLabel  = $priceType === 'gensoft' ? 'ККЦ' : 'Цена';
$_pricesLabel   = $priceType !== 'gensoft' ? 'Дост. цена' : ($_pricesWithDds ? "ККЦ с ДДС" : 'ККЦ без ДДС');

/* --- Точност ------------------------------------------------- */
$_priceAccuracy        = $settings['priceAccuracy'];
$_default_valutaSymbol = service('settings') -> get('App.default_valutaSymbol');
?>
<div class="d-flex col align-items-center flex-wrap gap-3">

    <div class="mr-4">
        <label>
            <input id="selectPageRows" type="checkbox">&nbsp;Текуща страница 
        </label>

        <i class="fa fa-question-circle-o text-primary" data-toggle="tooltip" title="„Само тази страница“ маркира редовете, които виждате в момента"></i> 
        <small class="text-muted">(видимите редове)</small>
    </div>

    <div class="mr-4">
        <label>
            <input id="selectAllResults" type="checkbox">&nbsp;Всички резултати
        </label>

        <i class="fa fa-question-circle-o text-primary" data-toggle="tooltip" title="„Всички резултати“ ще добави <b>всички продукти</b>, отговарящи на текущите филтри"></i> 
        <small class="text-muted">(от всички страници)</small>
    </div>


    <?php if ($_ENV['app.gensoftEnable']): ?>
        <div>
            <label>
                <input id="hasGensoftPromo" data-sqlcol="gensoft_json" data-route="<?= route_to('Popup_izboProduct-refreshTable') ?>" type="checkbox" <?= isset($search['hasGensoftPromo']) ? 'checked' : '' ?> value="1">&nbsp;Промо цена
            </label>

            <i class="fa fa-question-circle-o text-primary" data-toggle="tooltip" title="Ще бъдат показани <b>всички продукти</b>, които <br> имат промоционална цена в <b>Gensoft</b>"></i> 
            <small>(Gensoft)</small>
        </div>
    <?php endif ?>

    <button id="clearFilters" class="fa fa-close btn text-red" data-route="<?= route_to('Popup_izboProduct-refreshTable') ?>" type="button" title="Изчисти филтрите"></button>
</div>

<div class="row mb-2 col justify-content-end">
    <div class="mx-3">
        <span class="text-muted"><?= lang('LANG__mainPage.tbl.footer.total') ?></span> 
        <span id="countResults" class="fw-bold"><?= $countTotalProducts ?></span>
        <span class="text-muted"><?= lang('LANG__mainPage.tbl.footer.records') ?></span>
    </div>
    <br> <br>

    <div>
        <label class="label">На страница:</label>
        <select id="perPage" class="css-dropdown-p css-focus-strong" data-route="<?= route_to('Popup_izboProduct-refreshTable') ?>">
            <?php foreach ([10, 20, 50, 100, 150, 200, 500, 700, 1000] as $n): ?>
                <option value="<?= $n ?>" <?= ($perPage ?? 10) == $n ? 'selected' : '' ?>><?= $n ?></option>
            <?php endforeach ?>
        </select>
    </div>
</div>

<div id="refreshTable">
    <div class="d-flex col overflow-auto" style=" max-height: calc(100vh - 220px);">
        <table id="izborProduct" class="table table-striped table-sm" cellspacing="0" width="100%">
            <thead class="css-background text-center">
                <tr>
                    <th colspan="2"></th>

                    <th>
                        <input  
                            class="css-input-p css-focus-strong css-border-none" 
                            data-sqlcol="product_name" 
                            data-route="<?= route_to('Popup_izboProduct-refreshTable') ?>"
                            placeholder="Филтър по име на продукт"
                            autofocus="" 
                            type="search" 
                            onfocus="this.setSelectionRange(this.value.length, this.value.length);"
                            value="<?= isset($search['name']) && $search['sqlCol'] == 'product_name' ? $search['name'] : '' ?>"
                            >
                    </th>

                    <th>
                        <input class="css-input-p css-focus-strong css-border-none" 
                               data-sqlcol="kod" 
                               data-route="<?= route_to('Popup_izboProduct-refreshTable') ?>"
                               placeholder="Филтър по код"
                               type="search" 
                               autofocus="" 
                               onfocus="this.setSelectionRange(this.value.length, this.value.length);"
                               value="<?= isset($search['name']) && $search['sqlCol'] == 'kod' ? $search['name'] : '' ?>">
                    </th>

                    <th></th>

                    <th>
                        <label>
                            <input id="inStock" class="f-stock" data-route="<?= route_to('Popup_izboProduct-refreshTable') ?>" type="checkbox" <?= isset($search['inStock']) ? 'checked' : '' ?> value="1" >
                        </label>
                    </th>

                    <th colspan="3">

                    </th>

                </tr>

                <tr>
                    <th class="w-1 align-middle">
    <!--                    <button id="selectAll" class="btn btn-sm btn-dedault p-1 text-white" type="button"><i class="fa fa-check"></i></button>-->
                    </th>

                    <th class="w-5 align-middle">Подкатегория</th>
                    <th class="w-10 align-middle"><?= lang('popup/LANGpop__izborProduct.table.thead.product') ?></th>
                    <th class="w-7 align-middle"><?= lang('popup/LANGpop__izborProduct.table.thead.kod') ?></th>
                    <th class="w-10 align-middle"><?= lang('popup/LANGpop__izborProduct.table.thead.opisanie') ?></th>
                    <th class="w-1 align-middle">Наличност</th>

                    <th class="w-2 align-middle"><?= $_pricesLabel; ?> 
                        <div style="background-color:#C61111;color:#fff!important;padding:1px 6px;border-radius:4px;font-size:0.85em;">
                            (<?= $_default_valutaCode ?>)
                        </div>
                    </th>

                    <th class="w-1 align-middle"><?= lang('popup/LANGpop__izborProduct.table.thead.img') ?></th>

                    <?php if ($_ENV['app.gensoftEnable']): ?>
                        <th class="w-1">Gensoft налич.</th>
                    <?php endif ?>
                </tr>
            </thead>

            <tbody>
                <?php
// ако има продукти които присъстват в промо или ценови при търсене по име
                if (!empty($searchResult)) {
                    $_resultType = $ctrl == 'zenova' ? 'ценови листи' : ($arg == 'D' ? 'дилърски промоции' : 'клиентски промоции');

                    // Ако няма 'oferName', значи търсим всички продукти
                    if (!isset($searchResult['oferName'])) {
                        echo '<tr class="notAutoNum bg-primary"><td></td>';
                        echo "<td colspan='8'>Резултат от търсенето по част от името на продукт в кои $_resultType присъства";

                        $htmlResult = '';

                        foreach ($searchResult as $offerName => $products) {
                            $_resultType = $ctrl == 'zenova' ? 'ценовa листа' : ($arg == 'D' ? 'дилърска промоция' : 'клиентска промоция');
                            $htmlResult  .= "<div class='boldblack'><small class='font-size-13'>$_resultType</small class='font-size-13'>&nbsp;$offerName</div>";

                            foreach ($products as $p) {
                                $htmlResult .= "<div>$p</div>";
                            }
                        }

                        $htmlResult = htmlentities($htmlResult);

                        echo "<button type='button' class='btn fa fa-info-circle text-white' data-toggle='tooltip' title='$htmlResult'></button>";
                        echo '</td></tr>';
                    }
                    // Ако има 'oferName', търсим конкретен продукт
                    elseif (is_string($searchResult['oferName']) && $searchResult['oferName'] != '' && $list != 'notInZenovaLista') {
                        $_resultType = $ctrl == 'zenova' ? 'ценова листа' : ($arg == 'D' ? 'дилърска промоция' : 'клиентска промоция');
                        $productName = $searchResult['productName'] ?? '';
                        $offerName   = $searchResult['oferName'];

                        echo '<tr class="notAutoNum bg-primary"><td></td>';
                        echo "<td colspan='8'>Търсеният продукт <b class='boldblack'>$productName</b> присъства в $_resultType <b class='boldblack'>$offerName</b></td></tr>";
                    }
                    // ако не присъства в никоя ценова листа
                    elseif ($list == 'notInZenovaLista') {
                        echo "<td colspan='8'>Търсеният продукт <b class='boldblack'>{$searchResult['productName']}</b> не присъства в никоя ценова листа</td></tr>";
                    }
                }
// Ако няма резултати
                elseif ($list == []) {
                    echo '<tr><td></td><td colspan="8">' . lang('popup/LANGpop__izborProduct.table.tbody.noSearchResult') . '</td></tr>';
                }

                foreach (is_array($list) ? $list : [] as $row) {
                    $_gensoftJson = json_decode((string) $row['gensoft_json'] ?: '{}', true);
                    ?> 
                    <tr data-id="<?= $row['product_id'] ?>"> 
                        <td class="text-center"></td>
                        <td><?= $row['category_name'] ?></td> 

                        <td>
                            <?php
                            echo empty($row['product_name']) ? $row['gensoft_productName'] : $row['product_name'];

                            if ($row['gensoft_item_id']) {
                                echo '<br><img class="w-10" src="' . $_ENV['app.imageDataDir'] . 'logos/genSoft.jpg" alt="">';
                            }
                            ?>
                        </td> 

                        <td class="text-center"><?= $row['kod'] ?></td> 

                        <td>
                            <div class="maxHeight" style="resize: vertical;height: 3em;">
                                <?= $row['description'] ?>
                            </div>

                            <?php if ($row['description'] != '') { ?>
                                <div class="d-flex justify-content-center">
                                    <i class="fa fa-info-circle text-primary" data-toggle="tooltip" title="<?= htmlentities($row['description']) ?>"></i> 
                                </div>
                            <?php } ?>
                        </td>

                        <td class="text-center"><?= $row['nalichnost'] ?></td> 

                        <td class="text-center">
                            <?php
                            $_promoPrice    = null;
                            $_peiceDostavna = h_toFixed($row['price_dostavna'] ?? null);
                            $_gsKKC         = h_toFixed($_gensoftJson['KKC'] ?? null); // gensoft KKC 
                            $_gPromoPercent = is_numeric($_gensoftJson['promoPercent'] ?? null) ? (float) $_gensoftJson['promoPercent'] : null; // gensoft промо % 

                            if ($_gPromoPercent && is_numeric($_gsKKC)) {
                                $_promoPrice = h_toFixed($_gsKKC * (1 + ($_gPromoPercent / 100)));
                            }

                            echo $priceType === 'gensoft' ? $_gsKKC : $_peiceDostavna;

                            if ($_promoPrice !== null && !empty($_gsKKC)):
                                ?>
                                <div>
                                    <small class="<?= $_gPromoPercent < 0 ? 'text-danger' : 'text-success' ?>">
                                        <?= ($_gPromoPercent > 0 ? '+' : '') . $_promoPrice . '&nbsp;&nbsp;(' . $_gPromoPercent . '%)' ?>
                                    </small>
                                </div>
                            <?php endif ?>
                        </td>

                        <td class="p-0 align-middle text-center"> 
                            <img class="mw-100" src="<?= $row['image'] != '' ? $_ENV['app.imageCasheDir'] . $row['image'] . '/' . pathinfo($row['image'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image'], PATHINFO_EXTENSION) : '' ?>" onerror="this.onerror=null;this.src='';" data-img="<?= $row['image'] ?>" alt="">
                        </td> 

                        <?php if ($_ENV['app.gensoftEnable']): ?>
                            <td class="actionButtons text-center align-middle">
                                <?php if (!empty($row['gensoft_item_id'])): ?>
                                    <button class="getGensoftInfo btn text-primary " data-route="<?= route_to('Popup_izboProduct-getGensoftInfo') ?>" data-name="<?= $row['gensoft_productName'] ?? 'null' ?>" type="button">
                                        <i class="fa fa-info-circle"></i>
                                    </button>
                                <?php endif ?>
                            </td> 
                        <?php endif ?>
                    </tr> 
                <?php } ?> 
            </tbody> 
        </table>
    </div>


    <!-- Pagination -->
    <div id="refreshPagnitation">
        <div id="pagination" class="d-flex col mt-2 justify-content-center">
            <ul class="pagination m-0">
                <?= $pagination ?>
            </ul>
        </div>
    </div>
</div>
