<?php
$generalSettings = service('settings') -> get('App.general') ?? [];
$priceType       = $generalSettings['zenoobr']['price_type'] ?? '';
$preval          = $generalSettings['preval'] ?? [];
$currency        = $preval['base_currency'] ?? 'BGN';

$_gensoft_itemExists = isset($list -> gensoft_item_id);
$gensoft             = json_decode($list -> gensoft_json ?? '{}', true);
$_gensoft_kkc        = $gensoft['KKC'] ?? '';

$defaultSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв'
};

$_pricesWithDds = !empty($generalSettings['prices_with_dds']);
//$_gensoftLabel  = $priceType === 'gensoft' ? 'ККЦ Генсофт' : 'Цена';
$_kkcLabel      = $_pricesWithDds ? "ККЦ с ДДС" : 'ККЦ без ДДС';

function generateLabelInput($label, $name, $value = '', $isDisabled = false) {
    echo '<section class="row mb-1">';
    echo '<label class="col-2">' . $label . '</label>';
    echo '<fieldset class="col">';
    echo '<input type="text" name="' . $name . '" value="' . $value . '" ' . ($isDisabled ? 'disabled' : '') . '>';
    echo '</fieldset>';
    echo '</section>';
}

/* function generateImage($d = []) {
  $image_path = $d['img_path'] ?? '';
  $inputName  = $d['input_name'] ?? '';

  $image_src      = empty($image_path) ? '' : $_ENV['app.imageDir'] . $image_path;
  $camera_class   = empty($image_path) ? 'w-100 m-auto fa fa-camera' : 'fa';
  $decodedImgPath = urldecode($image_path);

  $html = <<<HTML
  <p class="imgPreview card cursor-pointer border-1 px-1 m-1"  title="Директория на снимката:  $decodedImgPath">
  <span class="d-flex align-self-center" style="width: 70px; height: 50px;">
  <i class='camera fa-2x text-center text-secondary $camera_class'></i>
  <img class="mw-100 mh-100 m-auto" src="$image_src" alt="" onerror="this.onerror=null;this.src='';">
  <input class="avatar" $inputName type="hidden" value="$image_path">
  </span>

  <span>
  <button class="removeImage btn text-danger btn-sm px-1 py-0" type="button"><i class="fa fa-trash"></i></button>
  HTML;

  echo $html;
  }
 */

function generateImageAddt($d = []) {
    $image_path = $d['img_path'] ?? '';
    $inputName  = $d['input_name'] ?? '';

    $image_src      = empty($image_path) ? '' : $_ENV['app.imageDir'] . $image_path;
    $camera_class   = empty($image_path) ? 'w-100 m-auto fa fa-camera' : 'fa';
    $decodedImgPath = urldecode($image_path);

    $html = <<<HTML
                  <p class="imgPreview photo p-1 mb-0 text-center" style="border:1px solid #ccc; border-radius:4px;" title="Директория на снимката:  $decodedImgPath">
                    <span class="d-flex align-self-center" style="width: 70px; height: 50px;">
                       <i class='camera fa-2x text-center text-secondary $camera_class'></i>
                        <img class="mw-100 mh-100 m-auto" src="$image_src" alt=" " onerror="this.onerror=null;this.src='';">
                        <input class="avatar" name='$inputName' type="hidden" value="$image_path">
                    </span>

                    <button style="position: absolute;top: -8px;right: -10px;background: #facaca;border: 1px solid #9c9c9c !important;" class="removeImage btn text-danger btn-sm px-1 py-0 round-10" type="button"><i class="fa fa-close"></i></button>
                HTML;

    echo $html;
}

function generateBrandImage($d = []) {
    $image_path = $d['img_path'] ?? '';

    $image_src      = empty($image_path) ? '' : $_ENV['app.imageDir'] . $image_path;
    $camera_class   = empty($image_path) ? 'w-100 m-auto fa fa-camera' : 'fa';
    $img_class      = 'w-50px';
    $brand_route    = route_to('POPup_editProduct-set_imageToBrand');
    $decodedImgPath = urldecode($image_path);

    $html = <<<HTML
           
                    <p class="imgPreview col-5 p-1 mb-0 text-center position-relative cursor-pointer" data-route="$brand_route" data-role="_brand" data-is-brand="1" title="Директория на снимката:  $decodedImgPath" style="border:1px solid #ccc; border-radius:4px;position: relative;">
                     <span>Снимка марка</span>
            
                     <span class="" style="width: 70px; height: 50px;">
                       <i class='camera fa-2x text-center text-secondary $camera_class'></i>
                        <img class="mw-100 mh-100 $img_class m-auto" src="$image_src" alt="" onerror="this.onerror=null;this.src='';">
                        <input class="avatar" type="hidden" value="$image_path">
                     </span>

                     <button class="removeImage btn text-danger btn-sm px-1 py-0 round-10" data-is-brand data-route="$brand_route" type="button" style="position: absolute;top: -8px;right: -10px;background: #facaca;border: 1px solid #9c9c9c !important;"><i class="fa fa-close"></i></button>
                    </p>
          HTML;

    echo $html;
}

function generateModelImage($d = []) {
    $image_path = $d['img_path'] ?? '';

    $image_src      = empty($image_path) ? '' : $_ENV['app.imageDir'] . $image_path;
    $camera_class   = empty($image_path) ? 'w-100 m-auto fa fa-camera' : 'fa';
    $img_class      = 'w-50px';
    $brand_route    = route_to('POPup_editProduct-set_imageToBrand');
    $decodedImgPath = urldecode($image_path);

    $html = <<<HTML
                    <p class="imgPreview col-5 p-1 mb-0 text-center position-relative cursor-pointer" data-route="$brand_route" data-role="_models" title="Директория на снимката:  $decodedImgPath" style="border:1px solid #ccc; border-radius:4px;position: relative;">
                        <span>Снимка модел</span>
                        <span class="" style="width: 70px; height: 50px;">
                            <i class='camera fa-2x text-center text-secondary $camera_class'></i>
                            <img class="mw-100 mh-100 m-auto $img_class" src="$image_src" alt="" onerror="this.onerror=null;this.src='';">
                            <input class="avatar" type="hidden" value="$image_path">
                        </span>

                        <button class="removeImage btn text-danger btn-sm px-1 py-0 round-10" data-is-brand data-route="$brand_route" type="button" style="position: absolute;top: -8px;right: -10px;background: #facaca;border: 1px solid #9c9c9c !important;"><i class="fa fa-close"></i></button>
                    </p>
          HTML;

    echo $html;
}

$_mqrka  = $_razmer = $_teglo  = [];
foreach ($mqrka as $row) {
    match ($row['mqrka_tip']) {
        'K' => $_mqrka[]  = $row,
        'R' => $_razmer[] = $row,
        'T' => $_teglo[]  = $row,
        default => null
    };
}
?>

<!-- дали модела е свързан с марката-->
<input id="isModelToBrand" type="hidden" value="<?= $customConfig -> popup_product_edit['modelToBrand'] ?>">

<div class="container-fluid">
    <div class="row">

        <!--  ==== лява колона ============ -->
        <div class="col-sm-5 pr-3">

            <?php if ($_gensoft_itemExists) : ?>
                <section class="row mb-1">
                    <label class="col-2">GenSoft</label>
                    <fieldset class="col ml-1 text-blue">
                        <?= $list -> gensoft_productName ?? '' ?>
                    </fieldset>
                </section>
            <?php endif ?>

            <div class="form-group row align-items-center">
                <div class="col-md-2 mr-3">  
                    <label>Име&nbsp;<b class="text-red">*</b></label>
                </div>

                <div class="col">
                    <input class="css-input-p css-focus-strong css-border-none" type="text" name="form[product_name]" value="<?= $list -> product_name ?? '' ?>">
                </div>
            </div>

            <section class="row">
                <!-- Дясна колона: Марка + Лого, Код на доставчик -->
                <div style="border-right: 1px solid #bebebe;" class="col-md-7 pr-2">
                    <div class="mb-1 row align-items-center">
                        <label class="col-sm-4">Марка</label>

                        <div class="col">
                            <input id="brandId" class="hiddenId" name="form[brand_id]" type="hidden" value="<?= $list -> brand_id ?? '' ?>">

                            <button id="brand-name" class="dropdownBtn text-left btn-sm border-1 dropdown-toggle w-100 round-10 css-dropdown-p css-focus-strong css-border-none" 
                                    data-hx-get="<?= route_to('Dropdown-renderView', 'tip=brand') ?>" 
                                    data-hx-target="next .hx-box"
                                    type="button">
                                        <?= $list -> brandTxt ?? '' ?>
                            </button>

                            <div class="hx-box position-absolute w-98"></div> 
                        </div>
                    </div>

                    <div class="form-group row align-items-center">
                        <label class="col-sm-4">Модел <small>главен</small></label>

                        <div class="d-flex col">
                            <input id="brand_model_id" class="model hiddenId" name="form[model_id]" type="hidden" value="<?= $list -> model_id ?? '' ?>">

                            <button class="productModel  dropdownBtn text-left btn-sm border-1 dropdown-toggle w-100 round-10 css-dropdown-p css-focus-strong css-border-none mr-1"
                                    type="button" 
                                    data-hx-get="<?= route_to('Dropdown-renderView', 'tip=model') ?>" 
                                    data-hx-include="#brandId"
                                    data-hx-target="next .hx-box" >
                                        <?= $list -> model ?? '' ?> 
                            </button> 

                            <button id="js-btn-modelAddt" class="dropdownBtn btn-sm border-1 w-15 btn-outline-info round-10"
                                    hx-get="<?= route_to('Dropdown-renderView', 'tip=modelAddt') ?>" 
                                    hx-include="#productId2, #brandId, #brand_model_id"
                                    hx-target="next .hx-box"
                                    title="Добавяне на допълнителни модели към главния модел"
                                    type="button">

                                <?php
                                $_countM = !empty($list -> additional_models) ? count(explode(',', $list -> additional_models)) : 0;

                                $class_badge = $_countM > 0 ? 'info' : 'light'
                                ?>
                                <span id="js-countSelectedModelsAddt" class="badge badge-<?= $class_badge ?>"><?= $_countM ?></span>
                            </button> 

                            <div class="hx-box position-absolute w-250px mt-4" data-tip="model"></div> 
                        </div>

                    </div>

                    <!-- снимки - марка и модел -->
                    <div id="brandModelImgRow" class="form-group row align-items-center">
                        <label class="col-sm-4"></label>

                        <div class="col d-flex row justify-content-around">
                            <?php generateBrandImage(['input_name' => 'form[image_brand]', 'img_path' => $list -> image_brand ?? '', 'is_brand' => true, 'brand_id' => $list -> brand_id ?? null]) ?>

                            <?php generateModelImage(['input_name' => 'form[image_model]', 'img_path' => $list -> image_model ?? '']) ?>    
                        </div>
                    </div>

                    <!-- година -->
                    <?php if ($customConfig -> popup_product_edit['model_year']): ?>
                        <div class="form-group row align-items-center">
                            <label class="col-sm-4">Година</label>

                            <div class="col-sm-8">
                                <input type="hidden" id="modelYear-id" class="customDropdown hiddenId" name="form[model_var_id_year]" value="<?= $list -> model_var_id_year ?? '' ?>">

                                <div class="hx-box position-absolute w-98"></div> 

                                <button id="modelYear-name"
                                        class="dropdownBtn customDropdown text-left btn-sm border-1 dropdown-toggle w-100 round-10 css-dropdown-p css-focus-strong css-border-none"
                                        data-hx-get="<?= route_to('Dropdown-renderView', 'tip=modelYear') ?>"
                                        data-hx-target="next .hx-box"
                                        data-hx-include="#brandId, #brand_model_id"

                                        type="button">
                                            <?= $list -> selected_year ?? '' ?>
                                </button>

                                <div class="hx-box position-absolute w-98" data-tip="model_year"></div> 
                            </div>
                        </div>
                    <?php endif ?>

                    <!-- купе -->
                    <?php if ($customConfig -> popup_product_edit['model_kupe']): ?>
                        <div class="form-group row align-items-center">
                            <label class="col-sm-4">Купе</label>

                            <div class="col-sm-8">
                                <input type="hidden" id="modelKupe-id" class="customDropdown hiddenId" name="form[model_var_id_kupe]" value="<?= $list -> model_var_id_kupe ?? '' ?>">

                                <button id="modelKupe-name" class="dropdownBtn customDropdown text-left btn-sm border-1 dropdown-toggle w-100 round-10 css-dropdown-p css-focus-strong css-border-none"
                                        data-hx-get="<?= route_to('Dropdown-renderView', 'tip=modelKupe') ?>"
                                        data-hx-target="next .hx-box"
                                        data-hx-include="#brandId, #brand_model_id"
                                        type="button">
                                            <?= $list -> selected_kupe ?? '' ?> 
                                </button> 

                                <div class="hx-box position-absolute w-98" data-tip="model_kupe"></div> 
                            </div>
                        </div>
                    <?php endif ?>
                </div>

                <!-- Лява колона: Модел, Година, Купе, Код -->
                <div class="col-md-5 pl-2">
                    <!-- код -->
                    <div class="form-group row align-items-center">
                        <label class="col-sm-4">Код</label>

                        <div class="col-sm-8">
                            <input class="css-input-p css-focus-strong css-border-none" name="form[kod]" type="text" value="<?= $list -> kod ?? '' ?>"  <?= $_gensoft_itemExists ? 'disabled' : '' ?> data-clearable>
                        </div>
                    </div>

                    <!-- оем -->
                    <div class="form-group row align-items-center">
                        <label class="col-sm-4">OEM</label>

                        <div class="col-sm-8">
                            <input class="css-input-p css-focus-strong css-border-none" name="form[oem]" type="text" value="<?= $list -> oem ?? '' ?>" data-clearable>
                        </div>

                    </div>

                    <!-- upc -->
                    <div class="form-group row align-items-center">
                        <label class="col-sm-4">UPC</label>

                        <div class="col-sm-8">
                            <input class="css-input-p css-focus-strong css-border-none" name="form[upc]" type="text" value="<?= $list -> upc ?? '' ?>" data-clearable>
                        </div>

                    </div>

                    <!-- ean -->
                    <div class="form-group row align-items-center">
                        <label class="col-sm-4">EAN</label>

                        <div class="col-sm-8">
                            <input class="css-input-p css-focus-strong css-border-none" name="form[ean]" type="text" value="<?= $list -> ean ?? '' ?>" data-clearable>
                        </div>
                    </div>

                    <?php if ($customConfig -> popup_product_edit['kod_dostavchik']): ?>
                        <div class="form-group row align-items-center">
                            <label class="col-sm-4">Код на доставчик</label>
                            <div class="col-sm-8">
                                <input class="css-input-p css-focus-strong css-border-none" name="form[kod_dostavchik]" type="text" value="<?= $list -> kod_dostavchik ?? '' ?>" data-clearable>
                            </div>
                        </div>
                    <?php endif ?>
                </div>
            </section>

            <div class="section-divider mb-2"></div>

            <section class="row justify-content-between">
                <!-- наличност -->
                <div class="form-group w-25 px-2">
                    <label>Наличност<b class="text-red">*</b></label>

                    <div class="input-group">
                        <input class="js-isFocus css-input-p css-focus-strong css-border-none input-field" name="form[nalichnost]"
                               data-label="наличност"
                               data-isNumeric 
                               type="text"  
                               value="<?= $list -> nalichnost ?? '' ?>" <?= $_gensoft_itemExists ? 'disabled' : '' ?>>

                        <div class="input-group-append">
                            <select class="border-1 w-auto"
                                    name="form[sp_mqrka_id]"
                                    data-size="10"
                                    title="Изберете мерна единица">

                                <option value="">---</option>
                                <?php foreach ($_mqrka as $row) { ?>
                                    <option <?= isset($list -> sp_mqrka_id) && $list -> sp_mqrka_id == $row['sp_mqrka_id'] ? 'selected' : '' ?> value="<?= $row['sp_mqrka_id'] ?>">
                                        <?= $row['mqrka_unit'] ?>
                                    </option>
                                <?php } ?> 
                            </select>
                        </div>
                    </div>
                </div>

                <!-- размери -->
                <div class="form-group col-md-4">
                    <label>Размери (Д x Ш x В)</label>

                    <div class="input-group d-flex">
                        <?php
                        $_l         = $list -> length ?? '';
                        $_w         = $list -> width ?? '';
                        $_h         = $list -> height ?? '';
                        $_razmerVal = $_l . 'x' . $_w . 'x' . $_h
                        ?>

                        <input class="js-isFocus css-input-p css-focus-strong css-border-none mask input-field" 
                               name="form[razmer]" 
                               data-label="размер"
                               data-inputmask="'mask':'9{1,4} x 9{1,4} x 9{1,4}','tabThrough': true"  
                               inputmode="numeric" 
                               type="text" 
                               value="<?= $_razmerVal ?>">

                        <div class="input-group-append">
                            <select class="border-1 w-auto" name="form[sp_razmer_id]" title="Изберете единица">
                                <option value="">---</option>

                                <?php foreach ($_razmer as $row) { ?>
                                    <option <?= (isset($list -> sp_razmer_id) && $list -> sp_razmer_id == $row['sp_mqrka_id']) ? 'selected' : '' ?> value="<?= $row['sp_mqrka_id'] ?>"><?= $row['mqrka_unit'] ?></option>
                                <?php } ?> 
                            </select>
                        </div>
                    </div>
                </div>

                <!-- тегло -->
                <div class="form-group w-25 px-2">
                    <label>Тегло</label>

                    <div class="input-group">
                        <input class="js-isFocus css-input-p css-focus-strong css-border-none input-field" name="form[teglo]" 
                               data-isNumeric 
                               data-label="тегло"
                               type="text" 
                               value="<?= $list -> teglo ?? '' ?>">

                        <div class="input-group-append">
                            <select class="border-1 w-auto" name="form[sp_teglo_id]"  title="Изберете мерна единица">
                                <option value="">---</option>

                                <?php foreach ($_teglo as $row) { ?>
                                    <option <?= (isset($list -> sp_teglo_id) && $list -> sp_teglo_id == $row['sp_mqrka_id']) ? 'selected' : '' ?> value="<?= $row['sp_mqrka_id'] ?>"><?= $row['mqrka_unit'] ?></option>
                                <?php } ?> 
                            </select>
                        </div>
                    </div>
                </div>
            </section>

            <section class="row">
                <!-- дост цена -->
                <div class="form-group col-3">
                    <label class="required">Дост. цена</label>

                    <input id="priceDostavna"
                           class="validate css-input-p css-focus-strong css-border-none w-75"
                           name="form[price_dostavna]"
                           data-isNumeric
                           type="text"
                           value="<?= sprintf('%0.' . $priceAccuracy . 'f', $list -> price_dostavna ?? 0) ?>"
                           <?= $_gensoft_itemExists ? 'disabled' : '' ?>>

                    <span><?= $defaultSymbol ?></span>
                </div>

                <!-- ккц -->
                <div class="form-group col-3">
                    <label><?= $_kkcLabel ?></label>

                    <input id="kkc"
                           class="validate css-input-p css-focus-strong css-border-none w-75"
                           name="form[cenaKKC]"
                           data-isNumeric
                           type="text"
                           value="<?= $_gensoft_itemExists ? $_gensoft_kkc : sprintf('%0.' . $priceAccuracy . 'f', $list -> cenaKKC ?? 0) ?>"
                           <?= $_gensoft_itemExists ? 'disabled' : '' ?> >
                    
                    <span><?= $defaultSymbol ?></span>
                </div>
            </section>

            <section class="row justify-content-between gap-11">
                <div class="imgPreview photo-base col-md-3">
                    <label class="p-1">Базова снимка</label>

                    <span style="height: 110px;" class="d-flex cursor-pointer align-self-center" title="Директория на снимката: <?= $list -> image ?? '' ?>">
                        <i class="camera fa-2x text-center text-secondary <?= empty($list -> image) ? 'w-100 m-auto fa fa-camera' : 'fa' ?>"></i>
                        <img class="mw-100 mh-100 m-auto" src="<?= empty($list -> image) ? '' : $_ENV['app.imageDir'] . $list -> image ?>" alt=" " onerror="this.onerror=null;this.src='';">
                        <input class="avatar" name="form[image]" type="hidden" value="<?= $list -> image ?? '' ?>">      
                    </span>

                    <button type="button" class="removeImage btn btn-link text-danger btn-sm d-block ml-auto px-1 round-10" style="position: absolute;top: -8px;right: -10px;background: #facaca;border: 1px solid #9c9c9c !important;"><i class="fa fa-close"></i></button>
<!--                        <img src="https://img.icons8.com/ios/150/000000/camera--v1.png" alt="Базова снимка" style="width:50%; height:auto;">-->

                </div>

                <div class="form-group col-md-6 mb-0">
                    <label>Допълнителни снимки на продукта</label>

                    <?php
                    if (isset($list -> image_aditional)) {
                        $_adtImage = explode(',', $list -> image_aditional);
                    }

                    for ($i = 0; $i < 6; $i++) {
                        if ($i == 0 || $i == 3) {
                            $classMb = $i == 3 ? 'm-0' : '';
                            echo "<div class='photo-row $classMb'>";
                        }
                        generateImageAddt(['input_name' => 'form[image_aditional][]', 'img_path' => $_adtImage[$i] ?? '']);

                        if ($i == 2 || $i == 5) {
                            echo '</div>';
                        }
                    }
                    ?>
                </div>
            </section>
        </div>

        <!--  ====== средна колона ============ -->
        <div class="col-sm-5">
            <section class="row mb-1">	
                <label class="col-2 h-0"><?= lang('popup/LANGpop__editProduct.basikData.opisanie') ?>
                    <label class="css-btn-purple p-1 mb-1 w-100 round-10 cursor-pointer">
                        <input class="is_shortDesc" name="rd" type="radio">&nbsp;кратко    
                    </label>

                    <label class="css-btn-purple p-1 mb-3 w-100 round-10 cursor-pointer">
                        <input class="is_shortDesc" name="rd" data-long="1" type="radio" checked="checked">&nbsp;дълго
                    </label>

                    <label class="css-btn-purple p-1 w-100 round-10 cursor-pointer">
                        <button id="addAttrToDeskcription" class="text-white btn-sm btn" type="button" title="добавяне на х-ки в описанието на продукта"><i class="fa fa-plus"></i>&nbsp;х-ки</button>
                    </label>
                </label>

                <fieldset class="description col"> 
                    <textarea id="ck_area" name="form[description]"><?= htmlentities($list -> description ?? '') ?></textarea>  
                </fieldset> 

                <fieldset class="description col hide"> 
                    <textarea id="ck_shortDesc" name="form[short_description]"><?= html_entity_decode($list -> short_description ?? '') ?></textarea> 
                </fieldset> 
            </section>

            <section class="row my-2">	
                <label class="col-2"><?= lang('popup/LANGpop__editProduct.basikData.note') ?></label>
                <fieldset class="col"> 
                    <textarea class="css-input-p css-focus-strong css-border-none w-100" name="form[belezka]" rows="1"><?= $list -> belezka ?? '' ?></textarea>
                </fieldset> 
            </section>

            <section class="row mb-1">	
                <label class="col-2"><?= lang('popup/LANGpop__editProduct.basikData.label') ?></label>

                <fieldset class="col">
                    <!-- стикер нов-->
                    <input class="chk_label" name="form[badge_index][]" type="checkbox" <?= $list?->badge_index == 1 ? 'checked' : '' ?> value="1">
                    <img class="w-10 mr-3" src="<?= $_ENV['app.imageDataDir'] ?>labels/new_label.png">
                    <!-- стикер очакван -->
                    <input class="chk_label" name="form[badge_index][]" type="checkbox" <?= $list?->badge_index == 2 ? 'checked' : '' ?> value="2">
                    <img class="w-10 mr-3" src="<?= $_ENV['app.imageDataDir'] ?>labels/feature_label.png">
                    <!-- стикер промо -->
                    <input class="chk_label" name="form[badge_index][]" type="checkbox" <?= $list?->badge_index == 3 ? 'checked' : '' ?> value="3">
                    <img class="w-10 mr-3" src="<?= $_ENV['app.imageDataDir'] ?>labels/hotSell.png">

                    <!-- стикер фиксирана -->
                    <?php if ($customConfig -> isVisible['label_fixPrice']): ?>
                        <input class="chk_label" name="form[badge_index][]" type="checkbox" <?= $list?->badge_index == 4 ? 'checked' : '' ?> value="4">
                        <img class="w-10" src="<?= $_ENV['app.imageDataDir'] ?>labels/fix_label.png">
                    <?php endif ?>
                </fieldset>
            </section> 

            <!-- добавяне към сайт-->
            <section class="row mb-1">	
                <label class="col-2">Към сайт</label>

                <div class="col">
                    <input name="form[is_toSite]" 
                           data-route="<?= route_to('Zenova-productToSites', $list -> product_id ?? '') ?>" 
                           type="checkbox" <?= !empty($list -> sp_site_id) || empty($list) ? 'checked' : '' ?> 
                           title="добавяне на продукта към всички сайтове" 
                           value="1">
                </div>

            </section>  
        </div>

        <!--  ==== дясна колона ============ -->
        <div id="block-category" class="col-sm-2">
            <?php
            $_categoryRootId = $list -> categoryRoot_id ?? null;
            $_subCategoryId  = $list -> category_id ?? null;
            $_subLevels      = [];

// Подгответе поднива до 5
            for ($i = 0; $i < 4; $i++) {
                $_subLevels[$i] = $pathCategory[$i]['children'] ?? [];
            }

            $_headerRoot = lang('popup/LANGpop__editProduct.basikData.category_choose');
            $_subRoute   = route_to('Popup_product-change_subCategory');
            ?>

            <!-- Главна категория -->
            <section class="row mb-1">
                <label>Главна категория</label>

                <select id="category_id" 
                        class="selectpicker css-dropdown-p css-focus-strong css-border-none border-1 w-100"
                        name="form[categoryRoot_id]" data-size="10"
                        data-header="<?= $_headerRoot ?>"
                        data-route="<?= route_to('POPup_editProduct-change_category') ?>">
                    <option value=""></option>

                    <?php
                    foreach ($categories as $main):
                        $_selectedRootCat = '';
                        if ($main['category_id'] == $_categoryRootId) {
                            $_selectedRootCat    = 'selected';
                            $_is_rootCatSelected = true;
                        }
                        ?>
                        <option <?= $_selectedRootCat ?> value="<?= $main['category_id'] ?>">
                            <?= $main['category_name'] ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </section>

            <!-- Подкатегории (до 4 нива) -->
            <?php
            for ($i = 0; $i < 4; $i++):
                $_level      = $_subLevels[$i];
                $_selectedId = $pathCategory[$i + 1]['category_id'] ?? null;
                $_isActive   = !empty($list -> category_id) && $list -> category_id == $_selectedId ? 'active' : '';

                $style = match (true) {
                    empty($_is_rootCatSelected) || empty($_level) => 'display:none',
                    default => '',
                };
                ?>

                <section class="row mb-1" style="<?= $style ?>">
                    <label>Подкатегория <?= $i + 1 ?></label>

                    <select id="subCat<?= $i + 1 ?>" 
                            class="subcatGroup <?= $_isActive ?> css-dropdown-p css-focus-strong css-border-none selectpicker border-1 w-100" 
                            name="form[category_id][]" 
                            data-header="Изберете подкатегория <?= $i + 1 ?>" 
                            data-route="<?= $_subRoute ?>">

                        <option value=""></option>

                        <?php
                        foreach ($_level as $sub):
                            // последната изнрана подкатегория
                            if ($_isActive) {
                                defined('CATEGORYNAME') or define('CATEGORYNAME', $sub['category_name']);
                                defined('CATEGORYID') or define('CATEGORYID', $sub['category_id']);
                            }
                            ?>
                            <option value="<?= $sub['category_id'] ?>" <?= $sub['category_id'] == $_selectedId ? 'selected' : '' ?>>
                                <?= $sub['category_name'] ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </section>
            <?php endfor ?>

            <?php
            $refreshCatParams = urldecode(http_build_query(array(
                'ctrl'       => $tip,
                'product_id' => $list -> product_id ?? '',
                'isRefresh'  => 1,
            )));
            ?>

            <button id="refresh-block-category" class="btn w-100 round-10 btn-warning" data-route="<?= route_to('Popup_editProduct-open', $refreshCatParams) ?>" type="button">Опресни категориите</button>
        </div>   
    </div>
</div>
