<?php
$_gensoft_itemExists = isset($list -> gensoft_item_id);

$_isRoundedToFirst = $ofer -> isRoundedToFirst ?? false;
$_priceAccuracy    = $_isRoundedToFirst ? 1 : ($general['priceAccuracy'] ?? 2);

$preval   = service('settings') -> get('App.general')['preval'] ?? [];
$currency = $preval['base_currency'] ?? 'BGN';

$_default_valutaSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв'
};

$priceType = $general['zenoobr']['price_type'] ?? 'discount';

$show = [
    'cenaB'    => true,
    'cenaA'    => true,
    'cenaSpec' => true,
    'cenaKl'   => true,
    'cenaKKC'  => true,
    'dost'     => true,
];

// RULES
if ($priceType === 'gensoft') {
    $show = [
        'cenaB'    => false,
        'cenaA'    => false,
        'cenaSpec' => false,
        'cenaKl'   => false,
        'cenaKKC'  => false,
        'dost'     => true,
    ];
}

if ($priceType === 'discount') {
    $show['cenaKl'] = false;
}
?>

<div id="modal_product" class="modal fade" tabindex="-1" data-tip="<?= $tip ?>" data-arg="<?= $arg ?>" data-backdrop="static" data-keyboard="false" role="dialog" style="z-index: 2000">

    <!-- --- ЗАРЕЖДАНЕ НА CSS ОТ CONTROLLER --- -->
    <?php if (isset($addCSS) && is_array($addCSS)) { ?>
        <?php foreach ($addCSS as $css) { ?>
            <link rel="stylesheet" type="text/css" href="<?= auto('assets/' . $css . '.css'); ?>">
        <?php } ?>
    <?php } ?>

    <div class="modal-dialog modal-dialog-centered mt-0 mw-100" role="document">
        <div class="css-background css-box-shadow modal-content ">
            <div class="css-border-none modal-header py-0">
                <h4 class="modal-title">
                    <?php if ($_gensoft_itemExists): ?>
                        <img class="w-8" src="<?= $_ENV['app.imageDataDir'] ?>logos/genSoft.jpg" alt="">
                    <?php endif ?>

                    <?= isset($list) ? 'Редакция на ' . ($list -> gensoft_productName ?? $list -> product_name ?? 'продукт') . " <small id='productId' class='text-white'>[id-{$list?->product_id}]</small>" : lang('popup/LANGpop__editProduct.title.new')
                    ?>
                </h4>

                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>

            <!-- Navigation tabs -->
            <nav>
                <ul class="nav nav-tabs tabs-heading" role="tablist">
                    <li class="nav-item">
                        <a href="#tabOsnovniDani" class="active nav-link mb-0" data-toggle="tab" role="tab"><?= lang('popup/LANGpop__editProduct.tab.basikData') ?></a>
                    </li> 

                    <?php if ($customConfig -> isVisible['categoryAttribute']): ?>
                        <li class="nav-item">
                            <a href="#tabProperty" class="nav-link mb-0" data-toggle="tab" role="tab"><?= lang('popup/LANGpop__editProduct.tab.attr') ?></a>
                        </li>
                    <?php endif ?>

                    <li class="nav-item">
                        <a href="#tabRelatedProducts" class="nav-link mb-0" data-toggle="tab" role="tab">Свързани продукти</a>
                    </li> 

                    <li class="nav-item">
                        <a href="#tabOptionsProduct" class="nav-link mb-0" data-toggle="tab" role="tab">Вариации на продукт</a>
                    </li>  

                    <li class="nav-item">
                        <a href="#tabSEO" class="nav-link mb-0" data-toggle="tab" role="tab">SEO настройки</a>
                    </li>
                </ul>
            </nav>

            <div class="modal-body py-0 overflow-auto" style=" max-height: calc(100vh - 140px);"> 
                <form id="form-product" class="tabs-body tab-content" name="form-product" role="form" action="<?= $form ?>" spellcheck="false" method="post">

                    <input id="productId2" type="hidden" name="form[product_id]" value="<?= $list -> product_id ?? '' ?>">

                    <!-- Tab основни данни -->
                    <div id="tabOsnovniDani" class="tab-pane fade show active mt-3"  role="tabpanel">
                        <?= view($view__tab['basicData']) ?>
                    </div>

                    <!-- Tab характеристики -->
                    <?php if ($customConfig -> isVisible['categoryAttribute']): ?>
                        <div id="tabProperty" class="tab-pane fade mt-3" role="tabpanel" >
                            <?= view($view__tab['properties']) ?>
                        </div>
                    <?php endif ?>

                    <!-- Tab свързани продукти -->
                    <div id="tabRelatedProducts" class="tab-pane fade mt-3" role="tabpanel">
                        <?= view($view__tab['relatedProducts']) ?>
                    </div>

                    <!-- Tab вариации на продукт -->
                    <div id="tabOptionsProduct" class="tab-pane fade mt-3" role="tabpanel">
                        <? // view($view__tab['optionsProduct'])  ?>
                    </div>

                    <!-- Tab: SEO Settings -->
                    <div id="tabSEO" class="tab-pane fade mt-3" role="tabpanel">
                        <?= view($view__tab['seoSettings']) ?>
                    </div>
                </form> 
            </div>  <!-- /.modal-body -->

            <span class="clearfix"></span>

            <div class="modal-footer py-1">
                <div class="col">
                    <?= lang('popup/LANGpop__editProduct.footer.fastLinks') ?>

                    <span class="modalMqrkaOpen pointer-cursor" data-route="<?= route_to('Popup_mqrka_open') ?>">
                        <i class="fa fa-balance-scale"></i>&nbsp;<?= lang('popup/LANGpop__editProduct.footer.mqrka') ?>
                    </span>

                    <span id="open_popupCategory" class="pointer-cursor" data-route="<?= route_to('POPup_category-open2') ?>">
                        <i class="fa fa-sitemap"></i>&nbsp;Категории
                    </span>

                    <span id="open_popupCategoryAttr" class="pointer-cursor" data-route="<?= route_to('POPup_categoryAttr-open') ?>">
                        <i class="fa fa-sitemap"></i>&nbsp;Х-ки на подкатегории
                    </span>
                </div>

                <div class="btn-group btn-group-sm">
                    <!-- Save button -->
                    <button id="save" class="btn btn-primary round-10 mr-2" data-ctrl="<?= $tip ?>" data-product-id="<?= $list -> product_id ?? '' ?>" form="form-product" type="submit">
                        <i class="fa fa-save"></i>&nbsp;<?= lang('LANG__global.btn.save') ?>
                    </button>

                    <?php
                    if (!empty($list -> product_id) && $priceType !== 'gensoft' && !url_is('*zenova*')) {
                        $urlParams = urldecode(http_build_query(array(
                            'ctrl'       => $tip,
                            'ofer_id'    => $order -> order_id ?? '',
                            'product_id' => $list -> product_id,
                            'arg'        => $arg, // $arg от POPup_editProduct
                        )));
                        ?>
                        <!-- Clone button (available only for existing products) -->
                        <button id="clone" class="btn btn-success round-10" data-route="<?= route_to('Popup_editProduct-clone', $urlParams) ?>" type="button" form="form-product">
                            <i class="fa fa-copy"></i>&nbsp;<?= lang('LANG__global.btn.clone') ?>
                        </button>
                    <?php } ?>

                    <!-- Cancel button -->
                    <button type="button" class="btn btn-default round-10" data-dismiss="modal"><?= lang('LANG__global.btn.cansel') ?>
                    </button> 
                </div>
            </div>

        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->

    <!-- --- ЗАРЕЖДАНЕ НА JS ОТ CONTROLLER --- -->
    <?php if (isset($addJS) && is_array($addJS)) { ?>
        <?php foreach ($addJS as $js) { ?>
            <script src="<?= auto('assets/' . $js . '.js'); ?>"></script>
        <?php } ?>
    <?php } ?>

    <script>
        var SETTINGS_NUM_FIXED = <?= json_encode($_priceAccuracy) ?>;
        var LANGpop__editProduct = <?php print_r(json_encode(lang('popup/LANGpop__editProduct.js'))) ?>;
    </script>
</div><!-- /.modal -->


