<?php
$settingsService = (object) service('settings') -> get('App.general');

$_json_tavaritelniza = json_decode($order -> tovaritelniza_json ?? '[]', true);
$_tovaritelnizaNo    = $order -> tavaritelniza_no ?? '';

$_title = empty($_tovaritelnizaNo) ? '' : "Заявка за куриер <br> на товарителница № $_tovaritelnizaNo";
?>

<div class="modal fade" id="modal_requestCurier" tabindex="-1"  data-backdrop="static" data-keyboard="false" role="dialog" aria-hidden="true" style="z-index: 1111111">

    <!-- --- ЗАРЕЖДАНЕ НА CSS ОТ CONTROLLER --- -->
    <?php if (isset($addCSS) && is_array($addCSS)) { ?>
        <?php foreach ($addCSS as $css) { ?>
            <link rel="stylesheet" type="text/css" href="<?= auto('assets/' . $css . '.css'); ?>">
        <?php } ?>
    <?php } ?>

    <div class="modal-dialog modal-dialog-centered w-50 mw-100 m-auto" role="document">
        <div class="css-background css-box-shadow modal-content">
            <div class="modal-header">
                <?php if ($isEcont): ?>
                    <a class="mr-5 pr-4" href="http://www.econt.bg" style="position: relative;top: -5px;">
                        <img src="/assets/images/curier/EcontLogo.png" alt="econt">
                    </a>
                <?php endif ?>

                <?php if ($isSpeedy): ?>
                    <a href="http://www.speedy.bg" style="position: relative;top: -5px;">
                        <img src="/assets/images/curier/SpeedyLogo.png" alt="Speedy">
                    </a>
                <?php endif ?>

                <?= "<h4 class='col modal-title text-center'>$_title</h4>" ?>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>

            <div class="modal-body">
                <form id="form-curier" name="form-curier" method="post" role="form" spellcheck="false" action="<?= $form ?>">
                    <input type="hidden" name="tovaritelnizaNo" value="<?= $_tovaritelnizaNo ?>">
                    <input type="hidden" name="profilSender" value="<?= $_json_tavaritelniza['profilSender'] ?>">
                    <input type="hidden" name="profilAgents" value="<?= $_json_tavaritelniza['profilAgents'] ?>">

                    <input type="hidden" name="isEcont" value="<?= $isEcont ?>">
                    <input type="hidden" name="isSpeedy" value="<?= $isSpeedy ?>">

                    <input type="hidden" name="orderId" value="<?= $order -> order_id ?>">
                    <input type="hidden" name="opakovka" value="<?= $_json_tavaritelniza['opakovka'] ?>">
                    <input type="hidden" name="packCount" value="<?= $_json_tavaritelniza['packCount'] ?>">
                    <input type="hidden" name="grandWeight" value="<?= $_json_tavaritelniza['grandWeight'] ?? 1 ?>">
                    <input type="hidden" name="profilAgents" value="<?= $_json_tavaritelniza['profilAgents'] ?? '' ?>">

                    <div class="row mb-1">
                        <span class="col-6">Адрес от който ще бъде взета пратката от куриер</span>
                        
                        <select class="bg-white akrobatBold" name="senderAdres">
                            <?php foreach ($profilSender as $client): ?>
                                <?php
                                foreach ($client['addresses'] as $k => $adr):
                                    $adrName  = $adr['city']['name'];
                                    $_ul      = $adr['street'];
                                    $_ulN     = $adr['num'];
                                    $_kv      = $adr['quarter'];
                                    $_fullAdr = '';

                                    if (empty($_ul)) {
                                        $_fullAdr = $adrName . ' ' . $_kv;
                                    } else {
                                        $_fullAdr = $adrName . ' ' . $_ul . ' ' . $_ulN;
                                    }
                                    ?>
                                    <option value="<?= $k ?>"><?= $_fullAdr ?></option>
                                <?php endforeach ?>
                            <?php endforeach ?>
                        </select>
                    </div>


                    <!-- Заявка за куриер-->
                    <div class="row mb-1">
                        <span class="col-2">Дата на вземане</span>

                        <div class="col-3">
                            <input id="requestDate" name="requestDate" type="date"  value="<?= date('Y-m-d') ?>">
                        </div>

                        <!-- Часови интервал -->
                        <span>Между:</span>
                        <div class="col">
                            <!-- От час -->
                            <?php
                            date_default_timezone_set('Europe/Sofia');
                            $now           = new DateTime();
                            $currentHour   = (int) $now -> format('G');
                            $currentMinute = (int) $now -> format('i');

                            echo '<select id="requestHourFrom" name="requestHourFrom" >';
                            echo('<option value="">Час</option>');

                            for ($h = 9; $h <= 18; $h++) {
                                // Ако е днешна дата и часът е в миналото - пропускаме
                                $_hide = now() && ($h < $currentHour || ($h == $currentHour )) ? 'hide' : '';
                                printf('<option class="' . ($_hide) . '" value="%02d">%02d</option>', $h, $h);
                            }
                            echo '</select>';
                            ?>

                            <!-- От минути -->
                            <select name="requestMinFrom">
                                <option value="">Минути</option>
                                <option value="00">00</option>
                                <option value="15">15</option>
                                <option value="30">30</option>
                                <option value="45">45</option>
                            </select>

                            <label class="mx-2">и</label>

                            <!-- До час -->

                            <?php
                            date_default_timezone_set('Europe/Sofia');

                            echo '<select id="requestHourTo" name="requestHourTo" >';
                            echo('<option value="">Час</option>');

                            for ($h = 9; $h <= 18; $h++) {
                                // Ако е днешна дата и часът е в миналото - пропускаме
                                $_hide = now() && ($h < $currentHour || ($h == $currentHour )) ? 'hide' : '';
                                printf('<option class="' . ($_hide) . '" value="%02d">%02d</option>', $h, $h);
                            }
                            echo '</select>';
                            ?>

                            <!-- До минути -->
                            <select name="requestMinTo">
                                <option value="">Минути</option>
                                <option value="00">00</option>
                                <option value="15">15</option>
                                <option value="30">30</option>
                                <option value="45">45</option>
                            </select>
                        </div>
                    </div>
                </form>
            </div>

            <div class="modal-footer">
                <div class="btn-group">
                    <button id="zaqviCurier" class="btn btn-primary" type="button"><i class="fa fa-truck"></i>&nbsp;Заяви куриер</button>

                    <button class="btn btn-outline-secondary p-1 border-0" type="button" data-dismiss="modal"><?= lang('LANG__global.btn.cansel') ?></button>
                </div>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->

    <?php if (isset($addJS) && is_array($addJS)) { ?>
        <script>
            var SETTINGS_NUM_FIXED = SETTINGS.priceAccuracy;
        </script>

        <?php foreach ($addJS as $js) { ?>
            <script src="<?= auto('assets/' . $js . '.js'); ?>"></script>
        <?php } ?>
    <?php } ?>  
</div>
