<?php

namespace App\Modules\popupForm\Models\spisak;

use \App\Models\BaseModel as BaseModel;

class MODELpop__categoryAttribute extends BaseModel {
    /* get active brand infromation */

    // извл на продуктите спрямо подкатегорията за подредба в сайт
    // ----------------------------------------------------------
    public function get__subCategory_level1() {

        $query = $this -> db -> table(self::TBL_CATEGORY);

        $mainCats = $this -> db -> table(self::TBL_CATEGORY)
                        -> where('parent_id', null)
                        -> orderBy('category_position', 'ASC')
                        -> get() -> getResultArray();

        // Извличаме само ID-тата в масив
        $mainCatIds = array_column($mainCats, 'category_id');

        // Стъпка 2: Вземаме само подкатегории от първо ниво (чиито parent_id е сред главните)
        $query = $this -> db -> table(self::TBL_CATEGORY)
                        -> whereIn('parent_id', $mainCatIds)
                        -> orderBy('ISNULL(category_position)', 'ASC', false)
                        -> orderBy('category_position', 'ASC')
                        -> get() -> getResultArray();

        return $query;
    }

    public function get__categoryAttr($catId = null) {
        $t = $this -> db -> table(self::TBL_CATEGORY_ATTRIBUTE)
                        -> where('category_id', $catId)
                        -> orderBy('ISNULL(category_char_position)')
                        -> orderBy('category_char_position', 'ASC')
                        -> get() -> getResultArray();

        //dd($t);
        return $t;
    }

    public function set__position($position = null) {

        $this -> db -> table(self::TBL_CATEGORY_ATTRIBUTE)
                -> onConstraint('category_id')
                -> updateBatch($position, ['category_characteristic_id']);
    }

    // видимост на аттрибута за категория
    function set__visibility($categoryAttId, $isVisible = 0) {

        $this -> db -> table(self::TBL_CATEGORY_ATTRIBUTE)
                -> set('is_visible', $isVisible)
                -> where('category_characteristic_id', $categoryAttId)
                -> update();
    }

    // видимост на аттрибута за категория
    function set__toCatalog($categoryAttId, $isVisible = 0) {

        $this -> db -> table(self::TBL_CATEGORY_ATTRIBUTE)
                -> set('is_visible_inCatalog', $isVisible)
                -> where('category_characteristic_id', $categoryAttId)
                -> update();
    }

    public function save_categoryAttr($data = []) {
        $builder = $this -> db -> table(self::TBL_CATEGORY_ATTRIBUTE);

        $exists = $builder
                -> where('category_id', $data['category_id'])
                -> where('value', $data['value'])
                -> countAllResults();

        if ($exists > 0) {
            $msg = 'Това име вече съществува за конкретната подкарегория';
            $this -> db -> transRollback();
            return $this -> dbError($msg);
        }

        $this -> db -> transBegin();

        $result = $builder -> upsert($data);

        if ($result === 1) {
            $result = ['lastId' => $this -> db -> insertID()];
        }

        if (!$this -> db -> transStatus()) {
            $this -> db -> transRollback();
            return $this -> dbError();
        }

        $this -> db -> transComplete();
        return $result;
    }

    public function remove($id) {

        if ($id) {
            $table = self::TBL_CATEGORY_ATTRIBUTE;

            try {
                $this -> db -> transStart();

                $affectedRows = $this -> db -> table($table)
                        -> where('category_characteristic_id', $id)
                        -> delete();

                $this -> db -> transComplete(); // Complete the transaction

                return $affectedRows > 0;
            } catch (\Exception $e) {
                return $this -> handleTransactionError("Failed to save $table: " . $e -> getMessage(), $e -> getMessage());
            }
        }
    }

}
