<?php

namespace App\Modules\popupForm\Models\product;

use \App\Models\BaseModel as BaseModel;

class MODELpop__editProduct extends BaseModel {

    public function get__product($product_id = null, $ctrl = '', $isArr = '') {
        if (!$product_id || !$ctrl || !array_key_exists($ctrl, self::TABLES)) {
            return null; // Return empty array or default data when tab is not provided
        }

        $qb = $this -> db -> table(self::TBL_PRODUCT . ' p')
                -> join(self::TBL_BRAND . ' b', 'b.brand_id = p.brand_id', 'left')
                -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' pl', 'pl.product_id = p.product_id', 'left')
                -> join(self::TBL_PRODUCT_SITES . ' st', 'st.product_id = p.product_id', 'left')
                -> join(self::TBL_MODEL . ' pm', 'pm.model_id = p.model_id', 'left')
                -> join(self::TBL_MODEL_PROPERTY . ' mv', 'mv.model_id = p.model_id', 'left')
                -> where('p.product_id', $product_id);

        // Check if the product exists in the oferta table
        if (!in_array($ctrl, ['order', 'spProduct'])) {
            $qb -> join(self::TABLES[$ctrl] . ' s', 'FIND_IN_SET(p.product_id, s.productsID)', 'left');
        }

        // селектиране на определени колони всички други колони са alias.*
        $this -> selectCols($qb, [
            'debug' => false,
            'only'  => [
                'pl' => ['cenaKKC'],
                'st' => ['sp_site_id'],
                'pm' => ['model', 'model_id', 'image_model']
            ],
            //'exclude_aliases'=> ['mv','mv2'],
            'extra' => [
                'mv.m_property_key,mv.m_property_text',
                '(SELECT 
                      GROUP_CONCAT(l.model_addit_id ORDER BY pm.model SEPARATOR ", ")
                    FROM ' . self::TBL_PRODUCT_MODEL_ADDIT_LINK . ' l

                    WHERE l.product_id = p.product_id AND l.model_main_id = p.model_id
                  ) AS additional_models'],
        ]);

        $result = $isArr === 'arr' ? $qb -> get() -> getResultArray() : $qb -> get() -> getRow();
        //dd($result);
        return $result;
    }

    // извл на главните категории
    // при промяна на главна категория се извикват подкатегориите към нея
    public function get__category($parentCategoryId = null) {

        $query = $this -> db -> table(self::TBL_CATEGORY);

        if (is_numeric($parentCategoryId)) {
            $query -> where('parent_id', $parentCategoryId);
        } else {
            $query -> where('parent_id', null);
        }

        return $query -> orderBy('ISNULL(category_position)')
                        -> orderBy('category_position', 'ASC')
                        -> get() -> getResultArray();
    }

    public function get__subCategory($product_id = null) {

        if (!is_numeric($product_id)) {
            return null;
        }

        // Get the category ID of the product
        $category_id = $this -> db -> table(self::TBL_PRODUCT)
                        -> select('category_id')
                        -> where('product_id', $product_id)
                        -> get() -> getRow('category_id');

        if (!$category_id) {
            return null;
        }

        // Get subcategories based on the retrieved category ID
        $subCategories = $this -> db -> table(self::TBL_CATEGORY)
                        -> where('parent_id', $category_id)
                        -> where('parent_id IS NOT NULL') // Use 'IS NOT NULL' for better readability
                        -> get() -> getResultArray();

        return $subCategories;
    }

    // извл на подкатегория спремо нивото нкоето избрано
    public function get__subCategory_multilevel($subCatId = null) {

        $query = $this -> db -> table(self::TBL_CATEGORY)
                        -> where('parent_id', $subCatId)
                        -> orderBy('ISNULL(category_position)')
                        -> orderBy('category_position', 'ASC')
                        -> get() -> getResultArray();

        return $query;
    }

    public function get__categoryAttribute($category_id = null) {

        $r = $this -> db -> table(self::TBL_CATEGORY_ATTRIBUTE . ' p')
                -> where('p.category_id', $category_id)
                -> orderBy('ISNULL(category_char_position)')
                -> orderBy('category_char_position', 'ASC');
//dd($r -> getCompiledSelect());
        // селектиране на определени колони всички други колони са alias.*
        $this -> selectCols($r, [
            'debug' => false,
            'only'  => [],
            'skip'  => ['p' => ['value']],
            'extra' => ['p.value as category_characteristic_value'],
        ]);

        return $r -> get() -> getResultArray();
    }

    public function get__productAttribute($product_id = null) {

        if (!$product_id) {
            return null;
        }

        $r = $this -> db -> table(self::TBL_PRODUCT_CHARACTERISTIC . ' p')
                        -> select([
                            'pa.*',
                            'p.product_id',
                            'p.product_characteristic_id',
                            'p.category_characteristic_id'
                        ])
                        -> join(self::TBL_PRODUCT_CHAR_VALUE . ' pa', 'product_characteristic_value_id', 'left')
                        -> where('p.product_id', $product_id)
                        -> get() -> getResultArray();

        return $r;
    }

    // търсене на продукти за добавяне в свързани продукти
    public function get__seachRelatedProducts($curentProductId = '', $searchName = null) {
        if (!empty($searchName)) {
            $searchName = explode(' ', $searchName);
        };

        $builder = $this -> db -> table(self::TBL_PRODUCT . ' p')
                -> select('product_id, product_name, description, image')
                -> whereNotIn('product_id', [$curentProductId]);

        foreach ($searchName as $pName) {

            $builder -> groupStart()
                    -> like('p.product_name', $pName, 'both')
                    -> orLike('p.oem', $pName, 'both')
                    -> orLike('p.upc', $pName, 'both')
                    -> orLike('p.ean', $pName, 'both')
                    -> orLike('p.kod', $pName, 'both')
                    -> orLike('p.kod_dostavchik', $pName, 'both')
                    -> groupEnd();
        }

        $products = $builder -> limit(10) -> get() -> getResult();

        if (empty($products)) {
            return '<div class="text-muted">Няма намерени продукти</div>';
        }

        $html = '<ul class="list-group bg-warning border-1">';

        foreach ($products as $product) {
            $imagePath    = $_ENV['app.imageDir'] . (!empty($product -> image) ? $product -> image : '');
            $_imgCasheSrc = empty($product -> image) ? '' : $_ENV['app.imageCasheDir'] . $product -> image . '/' . pathinfo($product -> image, PATHINFO_FILENAME) . '__150x150.' . pathinfo($product -> image, PATHINFO_EXTENSION);

            $productId   = $product -> product_id;
            $productName = $product -> product_name;
            $imageSrc    = $imagePath;
            $desc        = htmlentities($product -> description);

            $html .= <<<HTML
                        <li class="auto-count p-1 d-flex align-items-center border-bottom" data-id="{$productId}">
                            <input name="form[related_products][]" type="hidden" value="{$productId}">
                            <input class="w-3 hide" type="checkbox">
                            <img class="zoomImg mr-2 rounded border" src="$_imgCasheSrc" data-zoom-image="$imageSrc" alt=" " width="40" height="40">
                            <span class="name">$productName</span>
                            
                            <div class="btnGroup ml-auto hide">
                                 <i class="fa fa-info-circle btn py-0 px-1" data-toggle="tooltip" title="$desc" ></i>
                                 <i class="fa fa-arrows btn py-0 px-1"></i>
                                 <i class="removeItem fa fa-close btn py-0 px-1 text-danger"></i>
                            </div>
                        </li>
                    HTML;
        }

        $html .= '</ul>';

        return $html;
    }

    // свързани продукти
    public function get__relatedProducts($productJson = []) {
        if (empty($productJson)) {
            return;
        }

        $productIds = json_decode($productJson, true) ?? [];

        return $this -> db -> table(self::TBL_PRODUCT)
                        -> select('product_id,product_name,description,image')
                        -> whereIn('product_id', $productIds)
                        -> get() -> getResultArray();
    }

    // присвояваме на снимка за избрана марка
    public function set__image_toBrand($data = []) {
        if (empty($data)) {
            return;
        }

        [$table, $pk, $column, $id] = match ($data['role']) {
            '_brand' => [self::TBL_BRAND, 'brand_id', 'image_brand', $data['brandId']],
            '_models' => [self::TBL_MODEL, 'model_id', 'image_model', $data['modelId']],
            default => [self::TBL_PRODUCT, 'image']
        };

        $this -> db -> transStart();

        if (is_numeric($id)) {
            $this -> db -> table($table)
                    -> set($column, $data['image_path'])
                    -> where($pk, $id)
                    -> update();
        }

        if (!$this -> db -> transComplete()) { // Commit or rollback automatically
            return ['err' => $this -> db -> error()['message']];
        }
    }

    public function clone_product($id = '', $newProductName = '') {

        $query = $this -> db -> table(self::TBL_PRODUCT);

        if ($query -> where('product_name', $newProductName) -> countAllResults() > 0) {
            return ['dub' => true];
        }

        $productRow = $this -> db -> table(self::TBL_PRODUCT)
                        -> where('product_id', $id)
                        -> get() -> getRowArray();

        // премахване на тези keys
        // Remove specific keys
        $keysToUnset = ['product_id', 'product_name', 'gensoft_productName', 'gensoft_item_id', 'gensoft_json', 'related_products'];

        foreach ($productRow as $key => $val) {
            if (in_array($key, $keysToUnset)) {
                unset($productRow[$key]);
            }
        }

        $productRow += [
            'date_product_create' => date("d-m-Y H:i"),
            'product_name'        => $newProductName,
        ];

        $this -> db -> table(self::TBL_PRODUCT) -> insert($productRow);

        return ['lastId' => $this -> db -> insertID()];
    }

    public function save_product($data = []) {
        if (empty($data)) {
            return null;
        }

        $this -> db -> transBegin();

        // Проверка за дублиране на име при нов продукт (без значение на малки/главни букви)
        if (empty($data['product_id'])) {
            $productExists = $this -> db -> table(self::TBL_PRODUCT)
                            -> where('LOWER(product_name)', mb_strtolower($data['product_name'])) -> countAllResults();

            if ($productExists > 0) {
                return ['dub' => true, 'dubName' => $data['product_name']];
            }
        }

        // Подготовка на променливите за модел (ако има подадени такива)
        $priceKkc = $data['cenaKKC'] ?? null; // Цена с ДДС (ККЦ)
        // Премахва ги от масива с основни данни
        unset($data['cenaKKC'], $data['is_toSite']);

        // Добавяне или обновяване на запис за продукт (upsert)
        // 1- ако е нов ред, 2- update, 0 -ако данните са същите   
         $upsertResult = $this -> db -> table(self::TBL_PRODUCT) -> upsert($data);


        // Определяне на ID на продукта (ако е ново, взимаме новото, ако е update - ползваме подаденото)
        $productId = $upsertResult === 1 ? $this -> db -> insertID() : ($data['product_id'] ?? null);

        // автом.  задаваме ценови нива(B,A,SPEC) на база % отстъпка от настройки на с-мата
        if (!empty($priceKkc)) {
            $settings       = service('settings') -> get('App.general');
            $discount       = $settings['zenoobr'] ?? []; // Масив с проценти за ценовите нива
            $precision      = $settings['priceAccuracy'] ?? 2; // Точност на закръгляване
            $dds            = !empty($settings['dds']) ? ($settings['dds'] / 100) + 1 : 1; // ДДС коефициент
            $price          = $priceKkc / $dds; // Цена без ДДС
            // Масив с данни за различните ценови нива
            $priceLevelData = [
                'product_id' => $productId,
                'cenaB'      => round($price * (1 - ($discount['b'] ?? 0) / 100), $precision),
                'cenaA'      => round($price * (1 - ($discount['a'] ?? 0) / 100), $precision),
                'cenaSpec'   => round($price * (1 - ($discount['spec'] ?? 0) / 100), $precision),
                'cenaKKC'    => $priceKkc,
            ];

            // Upsert на ценовите нива
            $this -> db -> table(self::TBL_PRODUCT_PRICE_LEVEL) -> upsert($priceLevelData);
        }


        if (!$this -> db -> transComplete()) { // Commit or rollback automatically
            return ['err' => 'Грешка при изпълнение на sql заявката'];
        }

        return match ($upsertResult) {
            1 => ['lastId' => $productId], // Нов запис
            2 => 2, // Update на съществуващ запис
            default => 0, // Без промяна (същите данни)
        };
    }

    // след като сме избрали продуктите се добавят към офетата
    function generateTable($productId) {

        $sql = $this -> db -> table(self::TBL_PRODUCT . ' p')
                -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' pl', 'product_id', 'left')
                -> join(self::TBL_MODEL . ' pm', 'pm.model_id = p.model_id', 'left')
                -> join(self::TBL_BRAND . ' b', 'b.brand_id=p.brand_id', 'left')
                -> where('p.product_id', $productId);

        // селектиране на определени колони всички други колони са alias.*
        $this -> selectCols($sql, [
            'debug' => false,
            'only'  => [
                'pm' => ['model', 'model_id']
            ],
            'extra' => ['cenaKKC AS nivo'],
        ]);

        return $sql -> get() -> getResultArray();
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
