<?php

namespace App\Modules\popupForm\Controllers\spisak;

use \App\Models\common\MODEL__global;
use \App\Modules\popupForm\Models\spisak\MODELpop__valuta;

class POPup_valuta extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/spisak\\';

    public function __construct() {
        parent::__construct();

        $this -> MODELpop__valuta = new MODELpop__valuta();
        $this -> MODEL__global    = new MODEL__global();
    }

    // ajax отваряне на модал ф валута
    // ==================================================
    public function open() {

        $data = [
            'addJS' => $this -> addJS(),
            'list'  => $this -> MODEL__global -> get__valuta()
        ];

        return json_encode(view($this -> viewPath . 'VIEWpop__valuta', $data));
    }

    public function set_defaultValuta($id, $name) {//ajax
        $isDefault    = $this -> request -> getVar('isDefault');
        $valutaSymbol = $this -> request -> getVar('valutaSymbol');

        service('settings') -> set("App.default_valuta", $valutaSymbol);

        $this -> MODELpop__valuta -> set_defaultValuta($id, $isDefault);

        return json_encode($this -> returnResponse(true, $name, 'успешно e избрана основна валута', 1));
    }

    public function save() {

        $form = $this -> request -> getVar('form');
        $json = '';

        $this -> MODELpop__valuta -> save_valuta($form);

        $sql = $this -> MODEL__global -> get__valuta();

        $htmlTable = view($this -> viewPath . 'VIEWpop__valuta', ['list' => $sql]);
        preg_match('#<tbody([\s\S]*)</tbody>#i', $htmlTable, $matches);

        $json = trim(preg_replace('#</?tbody[^>]*>#i', ' ', $matches[0]));

        echo json_encode($json);
    }

    // ==== зареждане на css файлове в header на html странiцата =====
    // ---------------------------------------------------------------
    public function delete($id, $name) {

        $response = $this -> MODELpop__valuta -> delete_valuta($id);
        $json     = '';

        if ($response == true) {
            $json = lang('popup/LANGpop__valuta.sql.ok.deleted', [$name]);
        } else {
            $json = lang('popup/LANGpop__valuta.sql.err.deleted', [$name]);
        }

        return json_encode($json);
    }

    public function addJS() {

        $global = [];

        $plugins = [];

        $default = [];
        $modals  = ['js/popupForm/popup_valuta'];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
