<?php

namespace App\Modules\popupForm\Controllers\spisak;

use \App\Modules\popupForm\Models\spisak\MODELpop__shablon;

class POPup_shablon extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/spisak\\';

    public function __construct() {
        parent::__construct();

        $this -> MODELpop__shablon = new MODELpop__shablon();
    }

    // ajax отваряне на модал ф шаблон
    // ======================================================================
    public function open() {
        $data = [
            'shablonName' => $this -> MODELpop__shablon -> get__shablonName(), // изв на имената
            'addJS'       => $this -> addJS()
        ];

        return json_encode(view($this -> viewPath . 'VIEWpop__shablon', $data));
    }

    // ajax извличане на избраният шаблон от select box
    public function izbor_shablon() {
        $id     = $this -> request -> getVar('optionSelectedId');
        $result = $this -> MODELpop__shablon -> get__shablon_by_id($id);

        $prefixString = $_ENV['app.imageDir'];
        $pattern      = '/(<img\s[^>]*?src=")([^"]*)"/i';
        $replacement  = '$1' . $prefixString . '$2"';

        $result -> shablon_header = preg_replace($pattern, $replacement, $result -> shablon_header);
        $result -> shablon_footer = preg_replace($pattern, $replacement, $result -> shablon_footer);

        // dd($result);
        return json_encode($result, JSON_UNESCAPED_UNICODE);
    }

    public function save() {// ajax
        $shablon_header = $this -> request -> getVar('shablon_header');
        $shablon_footer = $this -> request -> getVar('shablon_footer');
        $shablonName    = $this -> request -> getVar('shablonName');
        $shablonId      = $this -> request -> getVar('shablonId');

        $shablon_header = str_replace($_ENV['app.imageDir'], '', $shablon_header);
        $shablon_footer = str_replace($_ENV['app.imageDir'], '', $shablon_footer);

        $data = [
            'shablon_id'     => $shablonId,
            'shablon_name'   => $shablonName,
            'shablon_header' => $shablon_header,
            'shablon_footer' => $shablon_footer
        ];

        $response = $this -> MODELpop__shablon -> save_shablon($data);

        // 1- ако е нов ред, 2- update, 0 -ако данните са същите
        if (is_numeric($shablonId)) {
            return json_encode('');
        } else {
            return json_encode(['lastId' => $response]);
        }
    }

    public function updateName() {// ajax
        $data = [
            'shablon_id'   => $this -> request -> getVar('shablonId'),
            'shablon_name' => $this -> request -> getVar('shablonName'),
        ];

        $response = $this -> MODELpop__shablon -> update_shablonName($data);

        if ($response == 2) {
            return json_encode('');
        }
    }

    // копиране на шаблон 
    public function copy() {//ajax
        $data = [
            'id'          => $this -> request -> getVar('shablonId'),
            'shablonName' => $this -> request -> getVar('shablonName')
        ];

        $response = $this -> MODELpop__shablon -> copy_shablon($data);

        return json_encode($response);
    }

    public function delete() {// ajax
        $id = $this -> request -> getVar('shablonId');
        $this -> MODELpop__shablon -> delete_shablon($id);

        return json_encode('');
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins'
        ];

        $plugins = [
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/ckeditor/ckeditor',
            'plugins/ckeditor/ckeditor_config',
                //'plugins/ckfinder/ckfinder'
        ];

        $default = [];
        $modals  = ['js/popupForm/popup_shablon'];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
