<?php

namespace App\Modules\popupForm\Controllers\spisak;

use \App\Models\common\MODEL__global;
use \App\Modules\popupForm\Models\spisak\MODELpop__nashiFirmi;

class POPup_nashiFirmi extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/spisak\\';

    public function __construct() {

        parent::__construct();

        $this -> MODEL__global        = new MODEL__global();
        $this -> MODELpop__nashiFirmi = new MODELpop__nashiFirmi();
    }

    // отваряне на модал ф категории в модал ф. продукт
    // ======================================================================
    public function open($id) {// ajax
        $data = [
            // 'addCSS'       => $this -> addCSS(),
            'addJS'        => $this -> addJS(),
            'addJS'        => $this -> addJS(),
            'list'         => $this -> MODELpop__nashiFirmi -> get__nashaFirma_by_id($id),
            'country_list' => $this -> MODEL__global -> get__country()
        ];

        return json_encode(view($this -> viewPath . 'VIEWpop__nashiFirmi', $data), JSON_UNESCAPED_UNICODE);
    }

    public function save() {// ajax
        $form     = $this -> trimFilter($this -> request -> getVar('form'));
        $formInfo = $this -> trimFilter($this -> request -> getVar('form-info'));

        $form['info_json'] = json_encode($formInfo, JSON_UNESCAPED_UNICODE);

        if (!isset($form['nshiF_isDefault'])) {
            $form['nshiF_isDefault'] = null;
        }

        $response = $this -> MODELpop__nashiFirmi -> save_nashaFirma($form);

        if ($response == 1) {
            $this -> returnResponse(true, $form['nshiF_name'], lang('popup/LANGpop__nashaFirma.returnResponse.ok.newNashaFirma'), 1);
        }
        if ($response == 2) {
            $this -> returnResponse(true, $form['nshiF_name'], lang('popup/LANGpop__nashaFirma.returnResponse.ok.editNashaFirma'), 1);
        }

        return redirect() -> back();
    }

    public function delete($id = null) {// ajax
        $this -> MODELpop__nashiFirmi -> remove_nashaFirma($id);

        return json_encode('');
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
        ];

        $plugins = [
            'plugins/ckeditor/ckeditor',
            'plugins/ckeditor/ckeditor_config',
            'plugins/ckfinder/ckfinder'
        ];

        $default = [];
        $modals  = ['js/popupForm/popup_nashaFirma'];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
