<?php

namespace App\Modules\popupForm\Controllers\spisak;

use \App\Models\common\MODEL__global;
use \App\Controllers\systems\Language;
use \App\Modules\popupForm\Models\spisak\MODELpop__language;

class POPup_language extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/spisak\\';

    public function __construct() {
        parent::__construct();

        $this -> MODELpop__language = new MODELpop__language();
        $this -> MODEL__global      = new MODEL__global();

        $this -> Language = new Language();
    }

    // ajax отваряне на модал ф валута
    // ==================================================
    public function open() {

        $data = [
            'addJS' => $this -> addJS(),
            'list'  => $this -> MODELpop__language -> get__lang()
        ];

        return json_encode(view($this -> viewPath . 'VIEWpop__language', $data));
    }

    public function set_defaulLanguage($code) {//ajax
        // $isDefault = $this -> request -> getVar('isDefault');
        // $code      = $this -> request -> getVar('code');
        service('settings') -> set("App.defaultLocale", $code);
        $this -> Language -> index($code);

        return json_encode($this -> returnResponse(true, $code, 'успешно e избрана основен език', 1));
    }

    public function save() {

        $form = $this -> request -> getVar('form');
        $json = '';

        $this -> MODELpop__language -> save_lang($form);

        $sql = $this -> MODELpop__language -> get__lang();

        $htmlTable = view($this -> viewPath . 'VIEWpop__language', ['list' => $sql]);
        preg_match('#<tbody([\s\S]*)</tbody>#i', $htmlTable, $matches);

        $json = trim(preg_replace('#</?tbody[^>]*>#i', ' ', $matches[0]));

        echo json_encode($json);
    }

    // ==== зареждане на css файлове в header на html странiцата =====
    // ---------------------------------------------------------------
    public function delete($id, $name) {

        $response = $this -> MODELpop__language -> delete_lang($id);
        $json     = '';

        if ($response == true) {
            $json = lang('popup/LANGpop__valuta.sql.ok.deleted', [$name]);
        } else {
            $json = lang('popup/LANGpop__valuta.sql.err.deleted', [$name]);
        }

        return json_encode($json);
    }

    public function addJS() {

        $global = [
            'js/_Global/ajax_config'
        ];

        $plugins = [];

        $default = [];
        $modals  = ['js/popupForm/popup_language'];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
