<?php

namespace App\Modules\popupForm\Controllers\spisak;

use \App\Controllers\ApiQurier;
use \App\Models\MODEL__apiQurier;
use \App\Models\common\MODEL__global;
use \App\Modules\popupForm\Models\spisak\MODELpop__klient;

class POPup_klient extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/spisak/klient\\';

    public function __construct() {
        parent::__construct();
        $this -> MODEL__global    = new MODEL__global();
        $this -> MODEL__apiQurier = new MODEL__apiQurier();
        $this -> MODELpop__klient = new MODELpop__klient();
    }

    // отваряне на модал ф категории в модал ф. продукт
    // ======================================================================
    public function open($id) {// ajax
        $isRefresh = $this -> request -> getVar('isRefresh'); // url param ако рефрешваме страницата с load

        $data = [
            'addCSS' => $this -> addCSS(),
            'addJS'  => $this -> addJS(),
            'list'   => $this -> MODELpop__klient -> get__klient($id),
            'views'  => [
                'basicDataTab'   => $this -> viewPath . 'VIEWpop__klient_basicData',
                'lizeContaktTab' => $this -> viewPath . 'VIEWpop__klient_lize_zaContakt',
                'deliveryTab'    => $this -> viewPath . 'VIEWpop__klient_delivery',
                'portalTab'      => $this -> viewPath . 'VIEWpop__klient_portal'
            ],
                // 'allOfices' => $this -> speedyRequest -> get__all_ofices($urlData + ['cityId' => $data['curier'] -> city_id, 'isMachine' => $isMachine ?? 0])
                //'country_list' => $this -> MODEL__global -> get__country()
        ];

        $view = view($this -> viewPath . 'VIEWpop__klient', $data);

        return $isRefresh ? $view : json_encode($view, JSON_UNESCAPED_UNICODE); 
    }

    public function get_klientObekt() {// ajax
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $klientId = $urlParams['klient_id'] ?? '';
        $obekt    = $urlParams['obekt'] ?? '';

        $response = $this -> MODELpop__klient -> get__klient($klientId);
        $klient   = json_decode($response -> klient_obekt_json ?? '[]', true);

        return json_encode($klient ? array_filter($klient[$obekt] ?? [], fn($v) => $v !== '') : ['err' => 'Липсват данни за клиент.']);
    }

    public function resetUpdatePassword() {// ajax
        $klientId = $this -> request -> getVar('klient_id');
        $action   = $this -> request -> getVar('action');
        $password = $this -> request -> getVar('password');

        $response = $this -> MODELpop__klient -> reset_update_password($klientId, $action, $password);

        return json_encode($response);
    }

    public function save() {// ajax
        $form                    = $this -> request -> getVar('form-klient');
        $form['klientData_json'] = json_encode($this -> request -> getVar('json-data'), JSON_UNESCAPED_UNICODE);
        //$form['klient_obekt_json'] = json_encode(array_map('array_filter', $this -> request -> getVar('json-obekt')), JSON_UNESCAPED_UNICODE);

        $filtered_obekt = array_filter($this -> request -> getVar('json-obekt') ?? [], function ($obekt) {
            return !empty($obekt['lice_zaKont']);
        }
        );

        $form['klient_obekt_json'] = !empty($filtered_obekt) ? json_encode($filtered_obekt, JSON_UNESCAPED_UNICODE) : NULL;

        $response = $this -> MODELpop__klient -> save_klient($form);

        $json   = match ($response) {
            1 => $this -> returnResponse(true, $form['klient_name'], lang('popup/LANGpop__klient.returnResponse.ok.newKlient'), 1, $isJson = 1),
            0, 2 => $this -> returnResponse(true, $form['klient_name'], lang('popup/LANGpop__klient.returnResponse.ok.editKlient'), 1, $isJson = 1),
            default => []
        };

        return json_encode($json + ['klientId' => $form['klient_id']]);
    }

    public function delete($id = null) {// ajax
        $this -> MODELpop__klient -> remove($id);

        return json_encode('');
    }

    public function addCSS() {
        return ['css/layouts/autocomplete'];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/curierLocator',
        ];

        $plugins = [];

        $default = [];
        $modals  = ['js/popupForm/popup_klient'];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
