<?php

namespace App\Modules\popupForm\Controllers\spisak;

use \App\Modules\popupForm\Models\spisak\MODELpop__category;

class POPup_category extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/spisak/category\\';

    public function __construct() {
        parent::__construct();
        $this -> MODELpop__category = new MODELpop__category();
    }

    public function changeParent() {
        $id       = (int) $this -> request -> getVar('category_id');
        $parentId = $this -> request -> getVar('parent_id');

        $this -> MODELpop__category -> changeParent(
                $id,
                $parentId !== '' ? (int) $parentId : null
        );

        return $this -> response -> setJSON(['success' => true]);
    }

    // отваряне на модал ф категории в модал ф. продукт
    public function open2() {// ajax
        $isRefresh         = $this -> request -> getVar('isRefresh'); // url param ако рефрешваме
        $pathIds           = $this -> request -> getVar('pathIds'); // url param ако рефрешваме
        $activeMainCatText = $this -> request -> getVar('activeMainCatText'); // страницата с load

        $data = [
            'modal_Title'       => lang('popup/LANGpop__category.title'),
            'addCSS'            => $this -> addCSS(),
            'addJS'             => $this -> addJS(),
            'mcats'             => $this -> MODELpop__category -> get__category(),
            'scats'             => $this -> MODELpop__category -> get__subCategory(),
            'breadcrumbs'       => $pathIds ?? [],
            'activeMainCatText' => $activeMainCatText ?? '',
            // VIEWS -----------------------------------------------------
            'view_table'        => $this -> viewPath . 'VIEWpop__category-table',
        ];

        $view = view($this -> viewPath . 'VIEWpop__category', $data);

        return $isRefresh ? $view : json_encode($view);
    }

    public function save2($categoryId = null, $action = '') {// ajax
        $name   = trim($this -> request -> getVar('doomEditElement') ?: $this -> request -> getVar('name'));
        $isRoot = $this -> request -> getVar('isRoot') ?? '';

        // ... сливане на масиви
        $data = [
            'category_name' => $name,
            ...($action === 'edit' && is_numeric($categoryId) ? ['category_id' => (int) $categoryId] : []),
            ...($action === 'new' ? ['parent_id' => is_numeric($categoryId) ? (int) $categoryId : null] : []),
        ];

        $response = $this -> MODELpop__category -> save_category($data, $isRoot);

        return json_encode($response, JSON_UNESCAPED_UNICODE);
    }

    public function delete2($id) {// ajax
        $response = $this -> MODELpop__category -> remove($id);

        return json_encode($response);
    }

    public function reorder2() {//ajax
        $positionsArr = $this -> request -> getVar('positionsArr');
        //$rootCatId       = $this -> request -> getVar('rootCatId');

        $this -> MODELpop__category -> set__position($positionsArr);

        return $this -> response -> setJSON($positionsArr);
    }

    // присвояване на снимка за категория
    public function setImage() {//ajax
        $id   = $this -> request -> getVar('id');
        $path = $this -> request -> getVar('path') ?? null;

        $data = [
            'category_id' => $id,
            'image_cat'   => $path,
        ];

        $response = $this -> MODELpop__category -> set__image($data);
        return json_encode($response);
    }

    public function seo($categoryId = null) {
        $categoryModel = $this -> MODELpop__category;
        $seoModel      = new \App\Modules\popupForm\Models\spisak\MODELpop__categorySEO();

        // Load category base info
        $category = $categoryModel -> get__categoryById($categoryId);

        // Try to load existing SEO data
        $seoData = $seoModel -> getByCategoryId((int) $categoryId);

        // Generate default SEO if missing
        if (empty($seoData)) {
            $seoData = $seoModel -> generateDefaultSEO([
                'category_id'          => $categoryId,
                'category_name'        => $category['category_name'] ?? '',
                'category_description' => $category['category_description'] ?? '',
            ]);
        }

        $category = array_merge($category ?? [], $seoData);

        $data = [
            'addCSS'   => $this -> addCSS('seo'),
            'addJS'    => $this -> addJS('seo'),
            'category' => $category
        ];

        // Render modal HTML
        $html = view($this -> viewPath . 'VIEWpop__editCategorySEO', $data);

        return json_encode($html);
    }

    public function seoSave($categoryId) {
        $form = $this -> request -> getVar('form');

        $seoModel = new \App\Modules\popupForm\Models\spisak\MODELpop__categorySEO();
        $seoModel -> saveSEO([
            'category_id'     => $categoryId,
            'seo_title'       => $form['seo_title'] ?? null,
            'seo_description' => $form['seo_description'] ?? null,
            'focus_keyword'   => $form['focus_keyword'] ?? null,
            'canonical_url'   => $form['canonical_url'] ?? null,
            'noindex'         => !empty($form['noindex']) ? 1 : 0,
            'seo_slug'        => $form['seo_slug'] ?? null,
        ]);

        return $this -> response -> setJSON([
                    'status'   => 'success',
                    'message'  => 'SEO settings saved successfully.',
                    'redirect' => base_url('home'),
        ]);
    }

    public function addCSS($arg = '') {
        return match ($arg) {
            'seo' => ['css/popupForm/popup_editCategorySEO'],
            default => ['css/popupForm/popup_category'],
        };
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS($arg = '') {

        $global = [
            'js/_Global/ajax_config',
        ];

        $plugins = [
            'plugins/doomEdit/jquery.doomEdit',
            'plugins/img/jquery.elevatezoom',
            'plugins/ckfinder/ckfinder',
            'plugins/ckfinder/config'
        ];

        $default = [];

        $modals = match ($arg) {
            'seo' => ['js/popupForm/categories/popup_categorySeo'],
            default => ['js/popupForm/categories/popup_category'],
        };

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
