<?php

namespace App\Modules\popupForm\Controllers\spisak;

use \App\Modules\popupForm\Models\spisak\MODELpop__categoryAttribute;

class POPup_CategoryAttr extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/spisak/categoryAttr\\';

    public function __construct() {
        parent::__construct();
        $this -> MODELpop__categoryAttribute = new MODELpop__categoryAttribute();
    }

    // отваряне на модал ф категории в модал ф. продукт
    // ======================================================================
    public function open() {//ajax
        $isRefresh = $this -> request -> getVar('isRefresh');

        $getCategories = $this -> MODEL__global -> get__all_categories();
        $categories    = $this -> buildCategoryTree(null, $getCategories);
//dd($categories);
        $data          = [
            'addCSS' => $this -> addCSS(),
            'addJS'  => $this -> addJS(),
            'ctrl'   => [
                'modal_Title' => 'Характеристики за подкатегории',
                'categories'  => $categories,
                // VIEWS -----------------------------------------------------
                'view'        => $this -> viewPath . 'VIEWpop__categoryAttr-layout',
            ],
        ];

        $view = view($this -> viewPath . 'VIEWpop__categoryAttr', $data);

        return $isRefresh ? $view : json_encode($view);
        // return json_encode($view);
    }

    public function select_category() {
        $childCategoriesArr    = $this -> request -> getVar('childCategoriesArr') ?? [];
        $singleChildCategoryId = $this -> request -> getVar('singleChildCategoryId');
        $catRootId             = $this -> request -> getVar('catRootId');
        $level                 = (int) $this -> request -> getVar('level') ?: 1;
        $targetIds             = [];
        $catAtributes          = [];

        // 🧠 Вземаме от кеш или генерираме
        $cacheKey   = 'tree_categories_full';
        $categories = cache() -> get($cacheKey);

        if (!$categories || $categories) {
            $getCategories = $this -> MODEL__global -> get__all_categories();
            $categories    = $this -> buildCategoryTree(null, $getCategories);
            $catAtributes  = $this -> MODELpop__categoryAttribute -> get__categoryAttr($singleChildCategoryId);
            cache() -> save($cacheKey, $categories, 3600); // 1 час
        }

        if ($level === 1 && $catRootId) {
            $targetIds[] = $catRootId;
        } elseif ($level >= 2 && $catRootId && $childCategoriesArr) {
            $targetIds[] = $catRootId;
            $targetIds   = array_merge($targetIds, array_column($childCategoriesArr, 'id'));
        }

        // обхождаме вложено дърво само с 1 цикъл
        foreach ($targetIds as $id) {
            $found = null;

            foreach ($categories as $cat) {
                if ((int) $cat['category_id'] === (int) $id) {
                    $found = $cat;
                    break;
                }
            }

            if (!$found) {
                $categories = []; // не е намерен пътя
                break;
            }

            $categories = $found['children'] ?? [];
        }

        $data = [
            'ctrl' => [
                'categories'            => $categories,
                'level'                 => $level,
                'catAtributes'          => $catAtributes,
                'singleChildCategoryId' => $singleChildCategoryId,
                'childCategoriesArr'    => $childCategoriesArr
            ]
        ];

        $view  = view($this -> viewPath . '/_parts/VIEWpop__categoryAttr-childCategories', $data);
        $view2 = view($this -> viewPath . '/_parts/VIEWpop__categoryAttr-catAtributes', $data);

        return ($level === 1 && $catRootId && empty($childCategoriesArr)) ?
                json_encode($view) :
                json_encode(['categories' => $view, 'catAtributes' => $view2]);
    }

    public function reorder() {//ajax
        $positionArr = $this -> request -> getVar('positionArr');

        //dd($positionArr);
        $this -> MODELpop__categoryAttribute -> set__position($positionArr);

        return $this -> response -> setJSON($positionArr);
    }

    public function isVisible($categoryAttrId = '') {
        $isVisible = $this -> request -> getVar('isVisible');

        $this -> MODELpop__categoryAttribute -> set__visibility($categoryAttrId, $isVisible);
    }

    public function show_categoryAttr_toCatalog($categoryAttrId = '') {
        $isVisible = $this -> request -> getVar('isVisible');

        $this -> MODELpop__categoryAttribute -> set__toCatalog($categoryAttrId, $isVisible);
    }

    public function save() {//ajax
        $isNew      = $this -> request -> getVar('new') ?? 0;
        $childCatId = $this -> request -> getVar('childCatId') ?? '';
        $curentId   = $this -> request -> getVar('curentId') ?? '';
        $newName    = $this -> request -> getVar('newName') ?? '';
        $editName   = trim($this -> request -> getVar('doomEditElement')) ?? '';

        $catData = [
            'category_characteristic_id' => $isNew ? null : $curentId,
            'category_id'                => $childCatId,
            'value'                      => $newName ? $newName : $editName,
            'is_visible'                 => 0,
        ];

        $response = $this -> MODELpop__categoryAttribute -> save_categoryAttr($catData);

        return json_encode($response);
    }

    public function delete($id = null) {//ajax
        $response = $this -> MODELpop__categoryAttribute -> remove($id);

        return json_encode($response);
    }

    public function addCSS() {
        return [
            'css/popupForm/popup_categoryAttr'
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins'
        ];

        $plugins = [
            'plugins/doomEdit/jquery.doomEdit',
            'plugins/htmx.min'
        ];

        $default = [];
        $modals  = ['js/popupForm/categories/popup_categoryAttr'];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
