<?php

namespace App\Modules\popupForm\Controllers\product;

use \App\Models\common\MODEL__global;
use \App\Models\common\MODEL__all_oferta;
use \App\Modules\popupForm\Models\product\MODELpop__zenovaLista;

class POPup_zenovaLista extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/product\\';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global         = new MODEL__global();
        $this -> MODEL__all_oferta     = new MODEL__all_oferta();
        $this -> MODELpop__zenovaLista = new MODELpop__zenovaLista();

        helper('array');
    }

    private function __generateViewTable($arg, $data) {
        return view("Modules/{$arg}\Views\VIEW__$arg-table", [
            'valuta' => $this -> MODEL__global -> get__valuta(),
            'mqrka'  => $this -> MODEL__global -> get__mqrka(),
            'ofer'   => $data['ofer'],
            'list'   => $data['list'],
        ]);
    }

    // отваряне на модал ф. 
    // -------------------------
    public function open() {
        $urlPrams    = $this -> request -> getGet();
        $zenovaLista = $this -> MODEL__global -> get__zenovaLista();

        $data = [
            'addJS'       => $this -> addJS(),
            'zenovaLista' => $zenovaLista,
            'tip'         => $urlPrams['ctrl']
        ];

        return json_encode(view($this -> viewPath . 'VIEWpop__izbor_zenova', $data));
    }

    // модал ф. прехвърляне на продукт в цен листа
    // ----------------------------------------------
    public function open_moveProductToZenova() {
        $productId      = $this -> request -> getVar('productId');
        $curentZenovaId = $this -> request -> getVar('curentZenovaId');

        if ($this -> request -> getPost()) {
            $zenovaId = $this -> request -> getVar('zenovaId');

            $result = $this -> MODELpop__zenovaLista -> moveProduct($productId, $curentZenovaId, $zenovaId);

            return json_encode($result);
        }

        $zenovaLista = $this -> MODEL__global -> get__zenovaLista();
        $productData = $this -> MODEL__global -> get__product_byId($productId);

        $data = [
            'addJS'          => $this -> addJS(),
            'zenovaLista'    => $zenovaLista,
            'productData'    => $productData,
            'curentZenovaId' => $curentZenovaId,
        ];

        return json_encode(view($this -> viewPath . 'VIEWpop__moveProduct_toZenova', $data));
    }

    ////////////////////////////////////////////////////////////
    //--- МОДАЛ ФОРМА ИЗБОР НА КЪМ САЙТ ---
    // /////////////////////////////////////////////////////////
    // 
    // добавяне на избраната ценова листа с ниво в офертата. 
    // ---------------------------------------------------
    public function import($arg) {

        $zenovaLista_id = $this -> request -> getVar('zenovaLista_id');

        $arr = [
            'zenovaLista_id' => $zenovaLista_id,
            'nivo'           => $this -> request -> getVar('nivo'),
            'productIdArr'   => $this -> request -> getVar('productIdArr')
        ];

        $data = [
            'ofer' => $this -> MODEL__global -> get__zenovaLista_byId($zenovaLista_id),
            'list' => $this -> MODEL__global -> get__izbor_zenovaLista($arr)
        ];

        $data['view_table'] = $this -> __generateViewTable($arg, $data);

        // добавяне на избраната ценова листа към оферта
        if (preg_match('#<tbody([\s\S]*)</tbody>#i', $data['view_table'], $matches)) {
            return json_encode(trim(preg_replace('#</?tbody[^>]*>#i', ' ', $matches[0])));
        }
    }

    //избиране на ценово ниво за всички продукти в таблицта
    public function izbor_zenovoNivo($arg, $oferId) {

        $arr = [
            'constTBL'     => $arg,
            'oferId'       => $oferId,
            'nivo'         => $this -> request -> getVar('nivo'),
            'productIdArr' => $this -> request -> getVar('productIdArr')
        ];

        $data = [
            'ofer' => $this -> MODEL__all_oferta -> get__ofer_by_id('_ofer_' . $arg, $oferId),
            'list' => $this -> MODEL__global -> get__izbor_zenovoNivo($arr)
        ];

        $data['view_table'] = $this -> __generateViewTable($arg, $data);

        // добавяне на избраната ценова листа към оферта
        if (preg_match('#<tbody([\s\S]*)</tbody>#i', $data['view_table'], $matches)) {
            return json_encode(trim(preg_replace('#</?tbody[^>]*>#i', ' ', $matches[0])));
        }
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins'
        ];

        $plugins = ['plugins/stickyTableHeaders/stickytableheaders'];

        $default = [];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
