<?php

namespace App\Modules\popupForm\Controllers\product;

use \App\Models\common\MODEL__global;
use \App\Modules\zenova\Models\MODEL__zenova_oferta;
use \App\Modules\popupForm\Models\product\MODELpop__zenoobr;

class POPup_zenoobrazuvane extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/product/zenoobrazuvane\\';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global        = new MODEL__global();
        $this -> MODELpop__zenoobr    = new MODELpop__zenoobr();
        $this -> MODEL__zenova_oferta = new MODEL__zenova_oferta();
    }

    // ajax отваряне на модал ф. ЦЕНООБРАЗУВАНЕ
    public function open($id) {
        $productId_arr = json_decode($this -> request -> getVar('productId_arr'), true);
        $isPrivate     = (bool) $this -> request -> getVar('isPrivate');

        $productId_arr = array_filter($productId_arr, function ($value) {
            return !empty($value);
        });

        $data = [
            'title'    => 'Ценообразуване - ' . ($isPrivate ? 'индивидуално' : ''),
            'form'     => route_to('Popup_zenoobrazuvan-save', urldecode(http_build_query(['id' => $id]))),
            'formIndv' => route_to('Popup_zenoobrazuvan-save', urldecode(http_build_query(['id' => $id, 'isIndiv' => true]))),
            'addJS'    => $this -> addJS($isPrivate),
            'addCSS'   => $this -> addCSS(),
            'ofer'     => $this -> MODELpop__zenoobr -> get_ofer_by_id($id),
            'list'     => $this -> MODELpop__zenoobr -> get_products($productId_arr),
        ];

        $view = $this -> viewPath . ($isPrivate ? 'VIEWpop__zenoobrPrivate' : 'VIEWpop__zenoobr');

        return json_encode(view($view, $data));
    }

    // ajax submit на данни от модал ф. ценообразуване
    // ==================================================
    public function save() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);
        $formData = json_decode($this -> request -> getVar('form') ?? '[]', true);

        if (empty($formData)) {
            return json_encode(['err' => 'Грешка: масива form е null!']);
        }

        $form = $this -> changeArr($formData, [
            'all' => [
                'json' => ['zonoobrPercent_json']
            ]
                ], null, true);

        // замества празните с-ти с null в масива
        array_walk_recursive($form['product'], function (&$value) {
            $value = ($value === '' || $value == 0) ? null : $value;
        });

        if (isset($urlParams['isIndiv'])) {
            $this -> MODELpop__zenoobr -> save_zenoobrIndiv($urlParams, $form);
        } else {
            $this -> MODELpop__zenoobr -> save_zenoobr($urlParams, $form);
        }

        return json_encode('');
    }

    public function addCSS() {
        return [
            'plugins/jTippy_popupTitle/jTippy.min'
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS($isPrivate) {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/inOfer/tableActions',
        ];

        $plugins = [
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/tableSearchRow/tableSearchRow',
            'plugins/stickyTableHeaders/jquery.table.freezeHeader',
            //'plugins/stickyTableHeaders/stickytableheaders',
            'plugins/img/jquery.elevatezoom'
        ];

        $default = [
            $isPrivate ? 'js/popupForm/popup_zenoobrazuvanePrivate' : 'js/popupForm/popup_zenoobrazuvane'
        ];
        
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
