<?php

namespace App\Modules\popupForm\Controllers\product;

use \App\Models\common\MODEL__global;
use \App\Modules\popupForm\Models\product\MODELpop__toSite;

class POPup_toSite extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/product\\';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global    = new MODEL__global();
        $this -> MODELpop__toSite = new MODELpop__toSite();

        helper('array');
    }

    ////////////////////////////////////////////////////////////
    //--- МОДАЛ ФОРМА ИЗБОР НА КЪМ САЙТ ---
    // /////////////////////////////////////////////////////////
    // 
    // отваряне на модал ф. 
    // --------------------------------------
    public function open() {
        $productIds = json_decode($this -> request -> getVar('productIds'), true);

        $data = [
            'addCSS'             => $this -> addCSS(),
            'addJS'              => $this -> addJS(),
            'productList'        => $this -> MODELpop__toSite -> get__productList_by_ids($productIds),
            'product_toSiteData' => $this -> MODELpop__toSite -> get__product_to_siteData($productIds),
            'sites'              => $this -> MODEL__global -> get__sites()
        ];

        return json_encode(view($this -> viewPath . 'VIEWpop__toSite', $data));
    }

    public function save() { // ajax
        $form = $this -> request -> getVar('form');

        $removeFromSite = [];
        $combined       = [];

        foreach ($form as $key => $products) {
            $siteId = preg_match('/siteId_(\d+)/', $key, $matches) ? $matches[1] : null;
            if (!$siteId) {
                continue; // Skip invalid siteId
            }

            foreach ($products as $productId => $value) {
                $visibility_type = (in_array('1', $value) && in_array('2', $value)) ?
                        0 : implode(',', array_filter($value));

                $removeFromSite[] = [
                    'product_id' => $productId,
                    'sp_site_id' => $siteId,
                ];

                if ($visibility_type === '') {
                    continue; // Skip adding to $combined if it should be removed
                }

                $combined[] = [
                    'product_id'      => $productId,
                    'sp_site_id'      => $siteId,
                    'visibility_type' => $visibility_type,
                ];
            }
        }

        usort($combined, function ($a, $b) {
            return $a['product_id'] <=> $b['product_id'];  // Spaceship operator for ascending order
        });

        $res = $this -> MODELpop__toSite -> save_data($combined, $removeFromSite);

        return json_encode($res);
    }

    public function addCSS() {
        return [];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/inOfer/tableActions'
        ];

        $plugins = [
            //'plugins/stickyTableHeaders/jquery.table.freezeHeader',
            'plugins/stickyTableHeaders/stickytableheaders',
        ];

        $default = [];
        $modals  = ['js/popupForm/popup_toSite'];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
