<?php

namespace App\Modules\popupForm\Controllers\product;

use \App\Models\common\MODEL__global;
use \App\Modules\order\Models\MODEL__order;
use \App\Modules\popupForm\Models\product\MODELpop__returnOrder;

class POPup_returnOrder extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/product\\';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__order          = new MODEL__order();
        $this -> MODELpop__returnOrder = new MODELpop__returnOrder();

        helper('array');
    }

    // отваряне на модал ф. 
    // -------------------------
    public function open($orderId = null) {
        $urlPrams    = $this -> request -> getGet();
        $productList = $this -> MODELpop__returnOrder -> get__products_fromOrder($orderId);

        $data = [
            'addJS'       => $this -> addJS(),
            'productList' => $productList,
        ];

        return json_encode(view($this -> viewPath . 'VIEWpop__returnOrder', $data));
    }

    public function save() {
        $urlPrams = $this -> request -> getVar();

        $errors = [
            'orderId'  => 'Липсва id на поръчка',
            'klientId' => 'Липсва id на клиент',
            'product'  => 'Липсват продукти в масива'
        ];

        foreach ($errors as $key => $message) {
            if (empty($urlParams[$key])) {
                return json_encode(['err' => $message]);
            }
        }

        $data = [
            'order_id'     => $urlPrams['orderId'],
            'klient_id'    => $urlPrams['klientId'],
            'product_json' => $urlPrams['product'],
        ];

        if (empty($data)) {
            return json_encode(['err' => 'Масива с данни е празен']);
        }

        $this -> MODELpop__returnOrder -> save_return($data);

        return json_encode('');
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/inOfer/tableActions'
        ];

        $plugins = ['plugins/stickyTableHeaders/stickytableheaders'];

        $default = [];
        $modals  = ['js/popupForm/popup_returnOrder'];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
