<?php

namespace App\Modules\popupForm\Controllers\product;

use \App\Models\common\MODEL__global;
use \App\Models\MODEL__gensoft;
use \App\Modules\popupForm\Models\product\MODELpop__editProduct;
use \App\Modules\zenova\Models\MODEL__zenova_oferta;
use \App\Modules\popupForm\Models\product\MODELpop__productSEO;
use \App\Models\BaseModel;

class POPup_editProduct extends \App\Controllers\BaseController {

    protected $viewPath = 'Modules/popupForm/Views/product\\';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global         = new MODEL__global();
        $this -> MODEL__gensoft        = new MODEL__gensoft();
        $this -> MODELpop__editProduct = new MODELpop__editProduct();
        $this -> MODEL__zenova_oferta  = new MODEL__zenova_oferta();
        $this -> MODELpop__productSEO  = new MODELpop__productSEO();

        helper('array');
    }

    /**
     * --- МОДАЛ ФОРМА ПРОДУКТ ---
     * отваряне на модал ф.
     * Loads product, category, attributes, and SEO data.
     */
    public function open($urlParams = null) {
        parse_str($urlParams, $urlParams);
        $general = service('settings') -> get('App.general') ?? [];

        $isRefresh = $this -> request -> getVar('isRefresh');
        $subCatId  = $this -> request -> getVar('subCatId'); // ako se ползва JQ load

        $priceAccuracy = $general['priceAccuracy'] ?? 2; // fallback 2
        // $is_order = explode('|', $arg); // order|8   тип на офертата и id на оферта
        $listData      = null;
        $seoData       = [];

        // Load SEO data for the current product
        $seoModel = new \App\Modules\popupForm\Models\product\MODELpop__productSEO();

        // Load product data
        if (!empty($urlParams['product_id'])) {
            $listData = $this -> MODELpop__editProduct -> get__product($urlParams['product_id'], $urlParams['ctrl'], 'obj');
        }

        // FIX: when creating NEW product (no product_id)
        if (!$listData) {
            $listData = (object) [
                        'product_id'       => null,
                        'product_name'     => '',
                        'badge_index'      => null,
                        'related_products' => [],
                        'image_aditional'  => null,
                        'category_id'      => null,
                        'categoryRoot_id'  => null,
                        'price_dostavna'   => 0,
                        'cenaKKC'          => 0,
                        'nalichnost'       => 0,
                        'sp_mqrka_id'      => null,
            ];
        }
        $catRootId = $listData -> categoryRoot_id ?? null;
        $subCatId  = $isRefresh ? $subCatId : ($listData -> category_id ?? null);

        $getCategories = $this -> MODEL__global -> get__all_categories();
        $categories    = $this -> buildCategoryTree(null, $getCategories);

        $pathCategory = $this -> findPathToCategory(!empty($catRootId) && empty($subCatId) ? $catRootId : $subCatId, $categories); // определяне пътя до категориите
        // If product exists — check if there’s SEO data in DB
        if (!empty($urlParams['product_id'])) {
            $seoData = $seoModel -> getByProductId((int) $urlParams['product_id']);
        }

        // --- Inject SEO data or defaults ---
        if (!empty($seoData)) {
            // Case: SEO record found → attach existing values
            foreach ($seoData as $key => $value) {
                if ($key === 'seo_images' && !empty($value)) {
                    $listData -> seo_images = json_decode($value, true);
                } else {
                    $listData -> $key = $value;
                }
            }
        } else {
            // Case: No SEO record → build defaults for form preview
            $defaultSeo = $seoModel -> generateDefaultSEO([
                'product_id'        => $urlParams['product_id'] ?? 0,
                'product_name'      => $listData -> product_name ?? '',
                'short_description' => $listData -> short_description ?? '',
                'description'       => $listData -> description ?? '',
                'kod'               => $listData -> kod ?? '',
                'oem'               => $listData -> oem ?? ''
            ]);

            if (!isset($defaultSeo['noindex']) || $defaultSeo['noindex'] === null) {
                $defaultSeo['noindex'] = 0;
            }

            // Attach defaults (not saved in DB yet)
            foreach ($defaultSeo as $key => $value) {
                if ($key === 'seo_images') {
                    $listData -> seo_images = is_string($value) ? json_decode($value, true) : $value;
                } else {
                    $listData -> $key = $value;
                }
            }
        }

        $data = [
            'addCSS'             => $this -> addCSS(),
            'addJS'              => $this -> addJS(),
            'settingsGeneral'    => service('settings') -> get('App.general'),
            'tip'                => $urlParams['ctrl'],
            'arg'                => $urlParams['arg'] ?? '',
            'product_id'         => $urlParams['product_id'],
            'form'               => route_to('Popup_product-save', urldecode(http_build_query($urlParams))),
            'list'               => $listData,
            'category_attribute' => $this -> MODELpop__editProduct -> get__categoryAttribute(['subCatId' => $subCatId]),
            'product_attribute'  => $this -> MODELpop__editProduct -> get__productAttribute($urlParams['product_id']),
            'related_products'   => $this -> MODELpop__editProduct -> get__relatedProducts($listData -> related_products ?? []),
            'pathCategory'       => $pathCategory,
            'priceAccuracy'      => $priceAccuracy,
            'categories'         => $categories,
            'mqrka'              => $this -> MODEL__global -> get__mqrka(),
            'view__tab'          => [
                'basicData'       => $this -> viewPath . 'editProduct/tab/VIEWpop__editProduct-tab-basicData',
                'properties'      => $this -> viewPath . 'editProduct/tab/VIEWpop__editProduct-tab-properties',
                'relatedProducts' => $this -> viewPath . 'editProduct/tab/VIEWpop__editProduct-tab-relatedProducts',
                'optionsProduct'  => $this -> viewPath . 'editProduct/tab/VIEWpop__editProduct-tab-optionsProduct',
                'seoSettings'     => $this -> viewPath . 'editProduct/tab/VIEWpop__editProduct-tab-seoSettings',
            ],
        ];

        $view = view($this -> viewPath . 'editProduct/VIEWpop__editProduct', $data);

        return $isRefresh ? $view : json_encode($view);
    }

    // populate подкатегория в модал ф. продукт при кликване на select box
    // -----------------------------------------------------------------
    public function change_category() {//ajax
        $categoryId = $this -> request -> getVar('category_id');
        $json       = [];

        if ($categoryId) {
            $response = $this -> MODELpop__editProduct -> get__category($categoryId);

            if (!empty($response)) {
                $options = [];

                foreach ($response as $row) {
                    $options[] = [
                        'value' => $row['category_id'],
                        'text'  => $row['category_name'],
                    ];
                }

                helper('selectBox');
                $selectBoxHtml = populate_select_box($options, '', '');

                $json = [
                    'selectBoxHtml'      => $selectBoxHtml,
                    'categoryProperties' => view($this -> viewPath . 'editProduct/tab/VIEWpop__editProduct-tab-properties'),
                ];
            }
        }

        return json_encode($json, JSON_THROW_ON_ERROR);
    }

    public function change_subCategory() {//ajax
        $subCatId  = $this -> request -> getVar('subCatId');
        $productId = $this -> request -> getVar('productId');
        $tip       = $this -> request -> getVar('tip');
        $json      = [];
        $list      = (object) [];

        if ($subCatId) {
            $list -> product_id = $productId;
            $product_attribute  = $this -> MODELpop__editProduct -> get__productAttribute($productId);
            $category_attribute = $this -> MODELpop__editProduct -> get__categoryAttribute(['subCatId' => $subCatId]);

            $subCat_multiLevel = $this -> MODELpop__editProduct -> get__subCategory_multilevel($subCatId);

            if (!empty($subCat_multiLevel)) {
                $options = [];

                foreach ($subCat_multiLevel as $row) {
                    $options[] = [
                        'value' => $row['category_id'],
                        'text'  => $row['category_name'],
                    ];
                }
                helper('selectBox');
                $selectBoxHtml = populate_select_box($options, '', '');
            }


            $data = [
                'list'               => $list,
                'product_attribute'  => $product_attribute,
                'category_attribute' => $category_attribute,
                'subCatId'           => $subCatId,
                'tip'                => $tip,
                'product_id'         => $productId,
            ];

            $json = [
                'categoryProperties' => view($this -> viewPath . 'editProduct/tab/VIEWpop__editProduct-tab-properties', $data)
            ];

            if (!empty($selectBoxHtml)) {
                $json['selectBoxHtml'] = $selectBoxHtml;
            }
        }

        return json_encode($json, JSON_THROW_ON_ERROR);
    }

    // присвояване на снимка за избрана марка
    public function set_imageToBrand() { //ajax
        $role       = $this -> request -> getVar('role');
        $image_path = $this -> request -> getVar('image_path');
        $brandId    = $this -> request -> getVar('brandId');
        $modelId    = $this -> request -> getVar('modelId');

        $data = compact('role', 'image_path', 'brandId', 'modelId');

        $this -> MODELpop__editProduct -> set__image_toBrand($data);
        return json_encode('');
    }

    // клониране на продукт 
    public function clone() { //ajax
        $urlParams      = $this -> request -> getGet();
        $newProductName = $this -> request -> getVar('newProductName');
        $ctrl           = $urlParams['ctrl'] ?? null;
        $productId      = $urlParams['product_id'] ?? null;

        $response = $this -> MODELpop__editProduct -> clone_product($productId, $newProductName);

        $response = match (true) {
            isset($response['dub']) =>
            [
                'dub'  => true,
                'data' => lang('popup/LANGpop__editProduct.js.alert.dubProdName', [$newProductName]),
            ],
            $ctrl === 'product' =>
            [
                'spProduct' => true,
            ],
            is_numeric($response['lastId']) =>
            [
                'lastId' => true,
                'data'   => $this -> __createTableRow($response['lastId'], $urlParams),
            ],
            default => [],
        };

        return json_encode($response);
    }

    // търсене на продукт по име за таб свързани продукти
    public function search_relatedProducts() {
        $searchName      = trim($this -> request -> getGet('searchName'));
        $curentProductId = trim($this -> request -> getGet('curentProductId'));

        if (!$searchName || mb_strlen($searchName) < 2) {
            return '<span class="text-danger">Въведете поне 2 символа...</span>';
        }

        $response = $this -> MODELpop__editProduct -> get__seachRelatedProducts($curentProductId, $searchName);

        return $response;
    }

    // СЪЗДАВАНЕ НА НОВ ИЛИ РЕДАКЦИЯ НА ПРОДУКТ ЧРЕЗ FORM SUBMIT ОТ МОД. Ф.
    // ===================================================================
    public function save($urlParams = null) {
        parse_str($urlParams, $urlParams);
        $zenovaId              = (int) $urlParams['arg'];
        $productCharacteristic = $this -> request -> getVar('product_characteristic');
        $formData              = $this -> trimFilter($this -> request -> getVar('form'));

        // array changes
        $arrayChanges = [
            'all'    => [
                'imp'  => ['image_aditional'],
                'json' => ['related_products']
            //'filterArr' => ['product_characteristic'],
            ],
            'create' => [
                'date' => 'date_product_create' // име на sql колоната 
            ]
        ];

        $form = $this -> changeArr($formData, $arrayChanges, $urlParams['product_id'] ?? null, true);

        // замества празните с-ти с null в масива
        $form['badge_index'] = ($value               = current(array_filter($form['badge_index'], fn($value) => !is_null($value)))) !== false ? $value : null;

        // филтрира подкатегориите до последната която има стойност
        $filteredCat         = array_filter($form['category_id']);
        $form['category_id'] = !empty($filteredCat) ? end($filteredCat) : null;

        $razmerArr = array_filter(array_map('trim', explode('x', str_replace('_', '', $form['razmer'] ?? ''))), fn($v) => $v !== '');

        $form['length'] = $razmerArr[0] ?? null;
        $form['width']  = $razmerArr[1] ?? null;
        $form['height'] = $razmerArr[2] ?? null;

        // Extract and clean SEO data
        $seoData = [
            'product_id'      => $urlParams['product_id'] ?? null,
            'seo_title'       => $form['seo_title'] ?? null,
            'seo_description' => $form['seo_description'] ?? null,
            'focus_keyword'   => $form['focus_keyword'] ?? null,
            'canonical_url'   => $form['canonical_url'] ?? null,
            'noindex'         => !empty($form['noindex']) ? 1 : 0,
            'seo_slug'        => $form['seo_slug'] ?? null,
            'seo_images'      => !empty($form['seo_images']) ? json_encode($form['seo_images'], JSON_UNESCAPED_UNICODE) : null,
        ];

        unset(
                $form['razmer'],
                $form['seo_title'],
                $form['seo_description'],
                $form['focus_keyword'],
                $form['canonical_url'],
                $form['noindex'],
                $form['seo_slug'],
                $form['seo_images']
        );

        // Основен save (insert/update) на продукта
        $response = $this -> MODELpop__editProduct -> save_product($form);

        if (isset($response['err'])) {
            return json_encode(['err' => $response['err']]);
        }

        if (isset($response['dub'])) {
            return json_encode([
                'dub'  => true,
                'data' => lang('popup/LANGpop__editProduct.js.alert.dubProdName', [$response['dubName']])
            ]);
        }

        $urlCtrl   = $urlParams['ctrl'] ?? '';
        $lastId    = $response['lastId'] ?? null;
        $productId = (int) $urlParams['product_id'] ?: $lastId;

        // Връзка към други сайтове (ако е маркирано)
        if (!empty($productId)) {
            $seoData['product_id'] = $productId;
            $this -> MODEL__zenova_oferta -> product_toSites($productId, !empty($form['is_toSite']));
            $this -> MODELpop__productSEO -> saveSEO($seoData);
        }

        // ако е ценова и ако продукта е нов се записва авт. в текущата ценова листа
        if ($urlCtrl === 'zenova' && $zenovaId && $lastId) {
            $zenova = $this -> MODEL__zenova_oferta -> get_zenova_by_id($zenovaId);

            $data = [
                'zenova'   => [
                    'id'         => $zenovaId,
                    'offersName' => $zenova -> offersName,
                ],
                'zProduct' => [['product_id' => (int) $lastId]]
            ];

            $result = $this -> MODEL__zenova_oferta -> save_oferta($zenovaId, $data, []);

            if (!empty($result['err'])) {
                return $this -> response -> setJSON($result);
            }

            if (!empty($zenova -> productsID)) {
                $currentIds = array_map('intval', explode(',', $zenova -> productsID));
            }

            $finalIds = array_unique(array_merge($currentIds, [$lastId]));

            $this -> MODEL__zenova_oferta -> db -> table(BaseModel::TBL_ZENOVA_LISTA)
                    -> where('id', $zenovaId)
                    -> update(['productsID' => implode(',', $finalIds)]);
        }

        // Генериране на JSON отговор в зависимост от контекста (ctrl)
        $json = match (true) {
            $urlCtrl === 'product' && $lastId =>
            [
                'spProduct' => true,
                $this -> returnResponse(true, $form['product_name'], lang('popup/LANGpop__editProduct.returnResponse.ok.newProduct'), 1)
            ],
            $urlCtrl !== 'product' && $lastId =>
            [
                'isNew' => true,
                'data'  => $this -> __createTableRow($lastId, $urlParams)
            ],
            default =>
            [
                'edit'   => true,
                'reload' => $urlCtrl === 'product',
                'data'   => $this -> __createTableRow($urlParams['product_id'], $urlParams)
            ]
        };

        return json_encode($json);
    }

    // ако създаваме нов продукт
    private function __createTableRow($lastId = null, $urlParams = null) {

        $arr = [
            'arg'    => $urlParams['arg'] ?? '',
            'list'   => $this -> MODELpop__editProduct -> generateTable($lastId),
            'ofer'   => null,
            'order'  => null,
            'valuta' => $this -> MODEL__global -> get__valuta(),
            'mqrka'  => $this -> MODEL__global -> get__mqrka()
        ];

        $view_htmlTable = $this -> get__viewTable($urlParams['ctrl'], $arr);

        if (preg_match('#<tbody([\s\S]*)</tbody>#i', $view_htmlTable, $matches)) {
            $modifiedTbody = preg_replace_callback('#<tr([^>]*)(>)#i', function ($matches) {
                // Check if the <tr> already has other attributes
                $attributes = isset($matches[1]) ? $matches[1] : '';
                return '<tr' . $attributes . ' data-fromizborproduct="true" >';
            }, $matches[0]);

            return trim(preg_replace('#</?tbody[^>]*>#i', ' ', $modifiedTbody));
        }
    }

    public function addCSS() {
        return [
            'css/common/dropdown',
            'css/popupForm/popup_editProduct',
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/loadPlugins',
            'js/_Global/dropdown'
        ];

        $plugins = [
            'plugins/doomEdit/jquery.doomEdit',
            'plugins/ckeditor/ckeditor',
            'plugins/ckeditor/ckeditor_config',
            'plugins/ckfinder/ckfinder',
            'plugins/ckfinder/config',
            'plugins/img/jquery.elevatezoom',
            'plugins/htmx.min',
        ];

        $default = [];

        $modals = [
            'js/popupForm/editProduct/popup_edit_product',
            'js/popupForm/editProduct/popup_edit_product-properties',
            'js/popupForm/editProduct/popup_edit_product-related',
            'js/popupForm/editProduct/popup_edit_product-seo'
        ];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
