<?php

namespace App\Modules\order\Controllers;

use \App\Controllers\BaseController as BaseController;
use \App\Controllers\ApiQurier;
use \App\Models\MODEL__apiQurier;
use \App\Models\common\MODEL__global;
use \App\Models\MODEL__offer_isOpen;
use \App\Models\common\MODEL__all_oferta;
use \App\Models\MODEL__gensoft;
use \App\Modules\order\Models\MODEL__order;
use \App\Libraries\Pagination;

class Order extends BaseController {

    protected $tip      = 'order';
    protected $viewPath = 'Modules\order\Views\\';

    public function __construct() {
        parent::__construct();

        $this -> ApiQurier         = new ApiQurier();
        $this -> Pagination_lib    = new Pagination();
        $this -> MODEL__apiQurier  = new MODEL__apiQurier();
        $this -> MODEL__global     = new MODEL__global();
        $this -> MODEL__all_oferta = new MODEL__all_oferta();
        $this -> MODEL__gensoft    = new MODEL__gensoft();
        $this -> MODEL__order      = new MODEL__order();
        // $this -> cache             = Services::cache();
        // cache()->save('foo', json_decode('{"28":{"qty":"1","pcs":"20","pac":"1","nwc":"1","gwc":"2","nw":"20","gw":"1","l":"1","w":"1","h":"20","vol":"1"}}',true), DAY*2);
        //cache()-> clean();
        //$id = '';
        helper('url');
    }

    public function index() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $order               = null;
        $products            = [];
        $deliveryObekt       = [];
        $folder_forDocumetns = '';

        if (is_numeric($urlParams['orderId'] ?? [])) {
            $this -> session -> set('oferId', $urlParams['orderId']);
            $this -> session -> set('openedTab', $this -> tip);

            $order    = $this -> MODEL__order -> get__order_byId($urlParams['orderId']);
            $products = $this -> MODEL__order -> get__products_inOrder($urlParams['orderId']);

            $folder_forDocumetns = glob(dirname(getcwd()) . '/' . $_ENV['app.documentsDir'] . 'documents/order/' . $urlParams['orderTip'] . '/' . $urlParams['orderId'] . '/*.*'); // прикачени файлове

            if ($_ENV['app.gensoftEnable']) {
                $products = $this -> MODEL__gensoft -> get__info_products($products);
                // dd($products);
            }

            // Обработка на данните за обекта на доставка
            if (!empty($order -> delivery_json)) {
                $ko = json_decode($order -> delivery_json);
            }

            $shippingCode     = $ko -> izborKurier ?? '';
            $isDoorShipping   = in_array($shippingCode, ['econt_door', 'speedy_door']);
            $isOfficeShipping = in_array($shippingCode, ['econt_office', 'econt_machina', 'speedy_office', 'speedy_machina']);

            $deliveryObekt = [
                'isDefault'            => $ko -> default ?? '',
                'liceKont'             => $ko -> lice_zaKont ?? '',
                'tel'                  => $ko -> tel ?? '',
                'grad'                 => $ko -> grad ?? '',
                'email'                => $ko -> email ?? '',
                'postCode'             => $ko -> postCode ?? '',
                'ofis'                 => $ko -> ofis ?? '',
                'kvartal'              => $ko -> quarter ?? '',
                'ulica'                => $ko -> street ?? '',
                'ulicaNo'              => $ko -> street_num ?? '',
                'blockNo'              => $ko -> block_no ?? '',
                'floorNo'              => $ko -> floor_no ?? '',
                'entranceNo'           => $ko -> entrance_no ?? '',
                'apartmentNo'          => $ko -> apartment_no ?? '',
                'other'                => $ko -> other ?? '',
                'izborKurier'          => $shippingCode,
                'isOfice'              => in_array($shippingCode, ['econt_office', 'econt_machina', 'speedy_office', 'speedy_machina']),
                'showAdresBlock'       => $isDoorShipping ? '' : 'hide',
                'showOfficeBlock'      => $isOfficeShipping ? '' : 'hide',
                'isAllowed'            => $isDoorShipping ? '' : 'css-pointer-events-none2',
                'showBtnLocatorEcont'  => in_array($shippingCode, ['econt_office', 'econt_machina']) ? '' : 'hide',
                'showBtnLocatorSpeedy' => in_array($shippingCode, ['speedy_office', 'speedy_machina']) ? '' : 'hide',
                'deliveryMetod'        => isset($ko -> deliveryMetod) ? $ko -> deliveryMetod : ''
            ];
        }

        $data = [
            'page_title'    => lang('LANG__order.breadcrumbs.pageTitle'),
            'breadcrumbs'   => $this -> breadcrumb -> render(),
            'message'       => session() -> getFlashdata('message'),
            'addCSS'        => $this -> addCSS(),
            'addJS'         => $this -> addJS(),
            'order'         => $order,
            'ofer'          => $order, // само за глоб данни за клиент
            'list'          => $products,
            'kontragents'   => $_ENV['app.gensoftEnable'] ? $this -> MODEL__gensoft -> get__kontragents() : [],
            'status'        => $this -> MODEL__global -> get__status(),
            'mqrka'         => $this -> MODEL__global -> get__mqrka(),
            'deliveryObekt' => $deliveryObekt,
            'get_documents' => ['docs' => $folder_forDocumetns, 'tab' => $urlParams['tab'], 'orderTip' => $urlParams['orderTip'], 'orderId' => $urlParams['orderId'] ?? ''],
            'modulTip'      => $this -> tip,
            // VIEWS -----------------------------------------------------
            'view'          => [
                'global_klientData'        => 'common/VIEW__glob-klientData',
                'actionBtn'                => $this -> viewPath . 'VIEW__order-actionBtn',
                'leftAside'                => $this -> viewPath . 'VIEW__order-leftAside',
                'leftAside-delivery'       => $this -> viewPath . 'VIEW__order-leftAside-delivery',
                'leftAside-deliveryKlient' => $this -> viewPath . 'VIEW__order-leftAside-delivery-klient',
                'actionContent'            => $this -> viewPath . 'VIEW__order-actionContent',
                'htmlTable'                => $this -> viewPath . (in_array($urlParams['orderTip'], ['site', 'L', 'K', 'F', 'N']) ? 'VIEW__order-site-table' : ''),
                'documents_inModul'        => 'common/VIEW__documents-inModul', // таблица с прикачени файлове
            ],
        ];
//dd($deliveryObekt);
        return $this -> render_template($this -> viewPath . 'VIEW__order', $data);
    }

    // проверка дали продукта в Gensoft има серийни номера или партиди
//    public function isGensoft_serNoOrPartida($productId) {
//
//        $res = $this -> MODEL__order -> get__gensoft_serNoOrPartida($productId);
//        return json_encode($res);
//    }
    // изтриване на товаритвлница
    public function delete_tovaritelniza() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $order = $this -> MODEL__order -> get__order_byId($urlParams['orderId']);

        if (!empty($order -> delivery_json)) {
            $delivery_obekt_json = json_decode($order -> delivery_json);
            $izborKurier         = $delivery_obekt_json -> izborKurier;

            if ($izborKurier == 'econt_office' || $izborKurier == 'econt_door' || $izborKurier == 'econt_machina') {
                $response = $this -> ApiQurier -> econt_deleteLabel($urlParams['tovaritelnizaNo']);

                if ($response !== null && ($response['results'][0]['error'] === null || $response === '{}')) {
                    $this -> MODEL__order -> deleteLTovaritelniza($urlParams);
                } else {
                    $this -> returnResponse(false, '', $response['results'][0]['error']['message'] . '. Опитайте отново след 1 мин.', 1);
                }
            } elseif ($izborKurier == 'speedy_office' || $izborKurier == 'speedy_door' || $izborKurier == 'speedy_machina') {
                $response = $this -> ApiQurier -> speedy_deleteLabel($urlParams['tovaritelnizaNo']);

                if ($response !== null || $response === '{}') {
                    $this -> MODEL__order -> deleteLTovaritelniza($urlParams);
                } else {
                    $this -> returnResponse(false, '', json_decode($response, true)['error']['message'] . '. Опитайте отново след 1 мин.', 1);
                }
            }

            return json_encode('');
        }
    }

    // изтриване на оферта
    public function delete_order() {
        parse_str($this -> request -> uri -> getQuery(), $urlParams);

        $this -> MODEL__order -> delete_order($urlParams);

        return redirect() -> to(html_entity_decode(route_to('tabOrder', "orderTip={$urlParams['orderTip']}")));
    }

    public function submit() {

        $form       = $this -> request -> getVar();
        $orderId    = $form['orderId'] ?? null;
        $totalPrice = 0;

        if (empty($form['product_json'])) {
            return ['err' => "Грешка: Няма предоставени продукти за обработка."];
        }

        foreach ($form['product_json'] as &$row) {
            $totalPrice += (int) $row['qty'] * (float) $row['price'];

            foreach (['inGensoftOrd', 'inGensoftSklad', 'gensoftSmetka'] as $key) {
                if (empty($row[$key])) {
                    unset($row[$key]);
                }
            }
        }

        $form = $this -> changeArr($form, [
            'all'    => [
                'json' => ['product_json'],
            ],
            'update' => [
                'user' => 'userName_modify',
                'date' => 'date_update'
            ],
            'create' => [
                'user' => 'userName_create',
            ],
                ], $orderId, true);

        $orderTip = match ($form['orderTip']) {
            'F' => 'K',
            'site' => null,
            default => $form['orderTip'],
        };

        $delivery_json = $form['delivery_json'];
        if (in_array($form['orderTip'], ['K', 'F'])) {
            $delivery_json = json_encode(array_filter($delivery_json, fn($value) => !is_null($value) && $value !== ''), JSON_UNESCAPED_UNICODE);
        }

        $form = array_filter(array_merge($form['order'], [
            'orderTip'        => $orderTip,
            'total_price'     => $totalPrice,
            'delivery_json'   => $delivery_json,
            'product_json'    => $form['product_json'],
            'userName_modify' => $form['userName_modify'] ?? null,
            'userName_create' => $form['userName_create'] ?? null,
            'date_update'     => $form['date_update'] ?? null
        ]));

        $response = $this -> MODEL__order -> save_order($form);

        // ако е нова оферта се заклучва към потребителя който я е създал
        if (!is_numeric($orderId) && !empty($response['orderId'])) {
            $MODEL__offer_isOpen = new MODEL__offer_isOpen();
            $MODEL__offer_isOpen -> checkAndLockOffer($response['orderId'], $this -> tip, $this -> user -> id);
        }

        return json_encode($response);
        //return json_encode($data); // last id на оферта ако е нова оферта
    }

    // връщане на поръчката
    public function returnOrder($orderId = null) {

        //$form       = $this -> request -> getVar();

        $response = $this -> MODEL__order -> return_order($orderId);

        return json_encode('');
    }

    // изпращане на данните към gensoft поръчка
    public function sendTo_gensoftOrder($orderId = null) {
        if (empty($orderId)) {
            return;
        }

        $isSingleProduct = (int) $this -> request -> getVar('isSingleProduct');
        $productIds      = json_decode($this -> request -> getVar('productIds'), true);
        $productIds      = is_array($productIds) ? $productIds : [$productIds];
        $skladName       = $this -> request -> getVar('sklad');
        $arr             = [];

        $products = $this -> MODEL__order -> get_products_byId($productIds);
        $order    = $this -> MODEL__order -> get__order_byId($orderId);

        $arr['skladName']       = $skladName;
        $arr['isSingleProduct'] = $isSingleProduct;

        if (empty($order) || empty($products)) {
            return json_encode(['err' => 'Грешка: данните в масива са празни!']);
        }

        $arr['order'] = [
            'products'       => $products,
            'klient'         => $order -> klient_name,
            'dds'            => $order -> invoice_tip == 'фактура' ? 20 : 0,
            'payment_method' => $order -> payment_method,
            'owner'          => $this -> user -> first_name . ' ' . $this -> user -> last_name,
        ];

        $gensoft = service('PrepareOrder_toGensoft');

        //$response = $gensoft->send($order, $arr);
        $response = $this -> MODEL__gensoft -> convert_in_order($arr, $order);
        dd($response);
        // 
        if (!empty($response) && empty($response['err'])) {

            $gensoftOrder = array_filter(
                    [
                        'datetime'   => $response['datetime'] ?? '',
                        'datetime2'  => $response['datetime2'] ?? '',
                        'skladName'  => $response['skladName'] ?? '',
                        'skladName2' => $response['skladName2'] ?? '',
                        'smetka'     => $response['smetka'] ?? '',
                        'smetka2'    => $response['smetka2'] ?? '',
                    ], function ($value) {
                        return !empty($value);
                    });

            $data = [
                'orderId'         => $order -> order_id,
                'gensoftOrder'    => $gensoftOrder,
                'isSingleProduct' => $isSingleProduct,
                'productId'       => $productIds,
                'productJson'     => $order -> product_json,
                'newOrder'        => $response['newOrder'] ?? '',
                'casheProdData'   => $response['casheProdData'] ?? '',
            ];

            $this -> MODEL__order -> is_newGensoftOrder($data);
        }

        return json_encode($response ?? '', JSON_UNESCAPED_UNICODE);
    }

    // последна продажна цена от gensoft за клиент
    public function gensoft_lastPrice() {

        $form = $this -> request -> getVar();

        if (empty($form['stoka']) || empty($form['firmaName'])) {
            return ['err' => 'Липсва валидно gensoft име за продукт!'];
        }

        $reponse = $this -> MODEL__gensoft -> get_lastPrice($form);

        return json_encode($reponse);
    }

    // извличане от gensoft с бг
    function convert($str) {
        return iconv("CP1251", "UTF-8", $str);
    }

    // преобразуване в подхoдящ бг формат за interbase
    function convert2($str) {
        return iconv("UTF-8", "CP1251", $str);
    }

    // зареждане на css файлове в header на html странiцата
    // ====================================================
    public function addCSS($isList = null) {

        return $isList ?
                // ако е в mainPage
                ['css/mainPage/mainPage'] :
                // ------------------------
                [
            //'css/curier/api_autocomplete',
            'plugins/ssi_uploaderImage/styles/ssi-uploader',
            'css/layouts/autocomplete',
            'css/layouts/global',
            'css/layouts/tables',
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/jqueryAlert/jqueryConfirm',
            'plugins/timepicker/datepicker',
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS($isList = null) {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/klient_modify_inOfer',
            'js/_Global/curierLocator',
            'js/_Global/inOfer/tableActions',
        ];

        $plugins = $isList ?
                // ако е в mainPage
                [
            'plugins/stickyTableHeaders/stickytableheaders',
            'plugins/tblColumnToggle/jquery.columntoggle',
            'plugins/tblColumnToggle/jquery.pageLength'
                ] :
                // ------------------------
                [
            'plugins/ssi_uploaderImage/js/ssi-uploader',
            'plugins/autocomplete/tautocomplete',
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/jqueryAlert/jqueryConfirm',
            'plugins/img/jquery.elevatezoom',
            'plugins/tableSearchRow/tableSearchRow',
            //'plugins/stickyTableHeaders/jquery.table.freezeHeader',
            'plugins/stickyTableHeaders/stickytableheaders',
            'plugins/timepicker/datepicker'
        ];

        $default = $isList ?
                // ако е в mainPage
                ['js/mainPage/mainPage'] :
                // ------------------------
                [
            'js/modul/order/order_vars',
            'js/modul/order/order',
        ];

        $modals = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
