<?php

namespace App\Modules\events\Controllers;

use \App\Controllers\BaseController as BaseController;
use \App\Models\common\MODEL__global;
use \App\Modules\events\Models\MODEL__events;

class Events extends BaseController {

    protected $viewPath = 'Modules\events\Views\\';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global = new MODEL__global();
        $this -> MODEL__events = new MODEL__events();
        helper('url');
    }

    public function index($tip) {
        $mapTip = match ($tip) {
            'raznos' => 1,
            'gensoftDostavka' => 2,
            default => ''
        };

        $data = [
            'page_title'  => 'Табло',
            'breadcrumbs' => $this -> breadcrumb -> render(),
            'message'     => session() -> getFlashdata('message'),
            'addCSS'      => $this -> addCSS(),
            'addJS'       => $this -> addJS(),
            'date'        => date('d-m-Y'),
            'users'       => $this -> MODEL__global -> get__users(['id', 'first_name', 'last_name']),
            'list'        => $this -> MODEL__events -> get__events(null, $mapTip),
            // view
            'view__table' => ($tip === 'raznos') ? $this -> viewPath . 'VIEW__events-raznos-table' : $this -> viewPath . 'VIEW__events-gensoftDostavka-table'
        ];

        return $this -> render_template($this -> viewPath . 'VIEW__events', $data);
    }

    public function changeDate($tip) {

        $date   = $this -> request -> getVar('date');
        $mapTip = match ($tip) {
            'raznos' => 1,
            'gensoftDostavka' => 2,
            default => ''
        };

        $view = ($tip === 'raznos') ? 'VIEW__events-raznos-table' : 'VIEW__events-gensoftDostavka-table';

        $data = [
            'date'  => $date,
            'users' => $this -> MODEL__global -> get__users(['id', 'first_name', 'last_name']),
            'list'  => $this -> MODEL__events -> get__events($date, $mapTip),
        ];

        return json_encode(
                [
                    'view' => view($this -> viewPath . $view, $data)
                ]
        );
    }

    // филтър доставчик
    public function autocomplete() {//ajax
        $text     = $this -> request -> getVar('text');
        $response = $this -> MODEL__events -> get__autocomplete($text);

        return json_encode($response);
    }

    public function submit($date = null, $tip = '') {
        $session = service('session');
        $json    = $this -> request -> getVar('json');
        $files   = $this -> request -> getFileMultiple('files');

        $mapTip = match ($tip) {
            'raznos' => 1,
            'gensoftDostavka' => 2,
            default => ''
        };

        $decodedJson = json_decode($json, true);

        $form = [
            'user_id'     => $session -> get('user')?->id,
            'events_date' => $date,
            'events_json' => json_encode($decodedJson, JSON_UNESCAPED_UNICODE),
            'tip'         => $mapTip
        ];

        if ($files) {
            $folder          = WRITEPATH . 'uploads/events/' . $tip;
            $targetDirectory = $folder . '/' . $date;

            // Create folder if it doesn't exist
            if (!is_dir($targetDirectory)) {
                mkdir($targetDirectory, 0777, true);
            }

            foreach ($files as $file) {
                if ($file -> isValid() && !$file -> hasMoved()) {
                    $newName = preg_replace('/[\s]+/', '_', $file -> getClientName());

                    if (!$file -> move($targetDirectory, $newName, true)) {
                        $err = 'Файлът не е качен';
                    }
                }
            }
        }

        $this -> MODEL__events -> save($form);

        $view = ($tip === 'raznos') ? 'VIEW__events-raznos-table' : 'VIEW__events-gensoftDostavka-table';

        $data = [
            'date'  => $date,
            'users' => $this -> MODEL__global -> get__users(['id', 'first_name', 'last_name']),
            'list'  => $this -> MODEL__events -> get__events($date, $mapTip),
        ];

        $viewContent = view($this -> viewPath . $view, $data);
        $tbodyRegex  = '#<tbody>([\s\S]*)</tbody>#i';
        $viewBody    = preg_match($tbodyRegex, $viewContent, $matches) ? trim(str_replace(['<tbody>', '</tbody>'], ' ', $matches[0])) : '';

        $responseData = [
            'msg'  => $this -> returnResponse(true, $date, 'записан разнос с дата', 1),
            'view' => $viewBody,
        ];

        return json_encode($responseData);
    }

    // изтриване на оферта
    public function delete($date, $tip) {

        $mapTip = match ($tip) {
            'raznos' => 1,
            'gensoftDostavka' => 2,
            default => ''
        };

        $res = $this -> MODEL__events -> delete($date, $mapTip);

        if ($res) {
            $folder          = WRITEPATH . 'uploads/events/' . $tip;
            $targetDirectory = $folder . '/' . $date;

            array_map('unlink', glob("$targetDirectory/*.*"));
            is_dir($targetDirectory) ? rmdir($targetDirectory) : '';

            $this -> returnResponse(true, $date, 'изтрит разнос с дата', 1);
        } else {
            $this -> returnResponse(false, $date, 'грешка при изтриване на разнос с дата', 1);
        }

        return redirect() -> back();
    }

    // зареждане на css файлове в header на html странiцата
    // ====================================================
    public function addCSS() {

        return [
            'css/mainPage/mainPage',
            'css/layouts/autocomplete',
            'plugins/dateTimePicker/jquery.datetimepicker',
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/inOfer/tableActions'
        ];

        $plugins = [
            'plugins/tableSearchRow/tableSearchRow',
            'plugins/dateTimePicker/jquery.datetimepicker',
            //'plugins/timepicker/datepicker',
        ];
        $default = ['js/modul/events/events'];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

////echo json_encode($arr_merged, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT);
 //
//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
