<?php
$request = \Config\Services::request();

$general = service('settings') -> get('App.general') ?? [];
helper('utils'); // helper 

/* --- Основни настройки ------------------------------------ */
$preval    = $general['preval'] ?? [];
$priceType = $general['zenoobr']['price_type'] ?? 'discount';
$currency  = $preval['base_currency'] ?? 'BGN';

/* --- Точност ------------------------------------------------- */
$_isRoundedToFirst = $ofer -> isRoundedToFirst ?? false;
$_priceAccuracy    = $_isRoundedToFirst ? 1 : ($general['priceAccuracy'] ?? 2);

/* --- Валута ---------------------------------------------- */
$_default_valutaCode   = $currency;
$_default_valutaSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв'
};

/* --- Ценови нива --------------------------------------------- */
$_priceLevels = [
    'cenaB'    => 'B',
    'cenaA'    => 'А',
    'cenaSpec' => 'Спец.',
    'cenaKKC'  => 'ККЦ'
];

// само когато НЕ е discount / gensoft
if (!in_array($priceType, ['discount', 'gensoft'], true)) {
    $_priceLevels['cenaKl'] = 'Кл.клиент';
}


/* --- Цени -------------------------------------------------- */
$_pricesWithDds     = !empty($general['prices_with_dds']);
$_dealerPricesLabel = 'ДИЛЪРСКИ ЦЕНИ ' . ($_pricesWithDds ? '(С ДДС)' : '(БЕЗ ДДС)');

$_labelValuta = "<div class='w-50 m-auto' style='background-color:#C61111;color:#fff!important;padding:1px 6px;border-radius:4px;font-size:0.85em;'> $_default_valutaCode </div>";

/* --- Мярка -------------------------------------------------- */
$_mqrka = isset($mqrka) ? array_column($mqrka, null, 'sp_mqrka_id') : [];
?>

<table id="tbl_products" class="table table-striped table-sm mt-3" cellspacing="0" width="100%">
    <thead class="css-background">
        <tr style="background: #C61111;color: white;">
            <th class="p-1 fw-600" colspan="13">
                <span style="background: #C61111;"><?= $_dealerPricesLabel ?></span>
            </th>
        </tr>

        <tr class="css-bg-purple">
            <th colspan="3"></th> 

            <th>
                <input id="filter" class="pr-4 css-input-p css-focus-strong css-border-none css-max-input-width" type="search" placeholder="<?= lang('LANG__global.placeholder.filter') ?>">
            </th>

            <th colspan="4"></th>   

            <?php if ($priceType !== 'gensoft'): ?>
                <th>
                    <?php
                    $_route     = route_to('Promo-getPriceLevel');
                    $_priceNivo = "<div id='priceLevelAll' class='text-center' data-all='1'>
                                    <span>Ценово ниво за всички продукти</span>
                                    <br><br>";

                    foreach ($_priceLevels as $level => $label) {
                        $_priceNivo .= "<button class='css-btn-wp' type='button'
                                        data-level='{$level}'
                                        data-route='{$_route}'>
                                        {$label}
                                    </button>";
                    }
                    $_priceNivo .= "</div>";
                    ?>
                    <button class="css-btn-purple border-w-1 round-10 text-white btn btn-sm" type="button" data-toggle="tooltip" title="<?= $_priceNivo ?>">Ц. ниво</button>
                </th>  
            <?php endif; ?>

            <th colspan="3"></th>   
        </tr>

        <tr>
            <th class="w-2"></th> 
            <th class="w-6"></th>
            <th class="w-5">Марка</th>
            <th class="w-15"><?= lang('LANG__special.tbl.th.product') ?></th>
            <th class="w-15"><?= lang('LANG__special.tbl.th.description') ?></th>
            <th class="w-5">Наличност</th>
            <th class="w-5"><?= lang('LANG__special.tbl.th.qty') ?></th>
            <th class="w-5"><?= lang('LANG__special.tbl.th.nadz') ?></th>
            <th class="w-6">Цена дилър
                <?= $_labelValuta ?>
            </th>

            <?php if ($priceType != 'gensoft') { ?>
                <th class="w-5"><?= lang('LANG__special.tbl.th.zenaDostavna') ?> 
                    <?= $_labelValuta ?>
                </th>
            <?php } ?>

            <th class="w-4"><?= lang('LANG__special.tbl.th.img') ?></th>
        </tr>
    </thead>

    <tbody> 
        <?php
        if (!isset($list)) {
            return;
        }

        $_colorRows = json_decode((string) $ofer?->colorRows, true) ?? [];
        $_clRow     = [];

        foreach ($list as $key => $row) {

            $_gensoftJson   = json_decode((string) $row['gensoft_json']);
            $_qtyPrice_json = json_decode($row['qtyPrice_json'] ?? '');

            $_mqrkaItem = empty($row['sp_mqrka_id']) ? '' : $_mqrka[$row['sp_mqrka_id']]['mqrka_unit'];

            // if (!$request -> isAJAX()) {
            helper('colorRows'); // Load the helper
            $_clRow    = generate_colorRows(['list' => $list, 'key' => $key, 'colspan' => 10, 'colorRows' => $_colorRows]);
            // }
            ?> 

            <tr data-id="<?= $row['product_id'] ?>"> 

                <td class="align-middle text-center">
                    <input type="hidden" name="baner[productsID][]" value="<?= $row['product_id'] ?>">           
                </td> 

                <!--  бутони -->
                <td class="action text-center align-middle"> 
                    <div>
                        <i class="delete_product btn-outline-danger p-1 border-0 fa fa-trash" title="<?= lang('LANG__global.tbl.btn.title.delete') ?>"></i>

                        <?php
                        $urlParams = array(
                            'ctrl'       => 'baner',
                            'product_id' => $row['product_id'],
                            'arg'        => '',
                        );
                        ?>

                        <i class="edit_product btn-outline-primary p-1 border-0 fa fa-edit" data-route="<?= route_to('Popup_editProduct-open', urldecode(http_build_query($urlParams))) ?>" title="<?= lang('LANG__global.tbl.btn.title.edit') ?>"></i> 
                    </div>

                    <div>
                        <i class="btn-outline-dark p-1 border-0 fa fa-arrows" title="<?= lang('LANG__global.tbl.btn.title.move') ?>"></i>
                        <i class="rowPosition btn-outline-dark p-1 border-0 fa fa-list"></i>
                    </div> 
                </td> 

                <!--  бранд img -->
                <td class="productBrandImg align-middle text-center">
                    <img class="mw-100 m-auto" src="<?= $row['image_brand'] != '' ? $_ENV['app.imageCasheDir'] . $row['image_brand'] . '/' . pathinfo($row['image_brand'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image_brand'], PATHINFO_EXTENSION) : '' ?>" onerror="this.onerror=null;this.src='';" data-img="<?= $row['image_brand'] ?>" alt=" ">
                </td> 

                <!--  продукт име -->
                <td class="productName align-middle text-break fw-500">
                    <?= empty($row['product_name']) ? '<b class="bg-danger">Липсва продуктово име</b><br>' . $row['gensoft_productName'] : $row['product_name'] ?>
                    <div>
                        <?php
                        if ($row['gensoft_item_id']) {
                            echo '<img class="w-20" src="' . $_ENV['app.imageDataDir'] . 'logos/genSoft.jpg" alt="">';
                        }

                        // echo $_gensoftJson -> qty_safe ?? '' ? '<p class="bg-secondary m-2">' . $_ENV['app.sklad4'] . '</p>' : '';
                        ?>  
                    </div>
                </td> 

                <!--  описание -->
                <td class="productDesk align-middle fw-500">
                    <div class="maxHeight">
                        <?= $row['description'] ?>
                    </div>

                    <?php if (!empty($row['description'])) { ?>
                        <i class="fa fa-info-circle text-primary text-center d-block cursor-pointer css-icon-active" data-toggle="tooltip" data-position="left" data-title="<?= htmlentities($row['description']) ?>"></i> 
                    <?php } ?>
                </td> 

                <!--  наличност -->
                <td class="productNalichnost position-relative align-middle text-center fw-500">
                    <div class="position-absolute w-100" style="top: 50%; left: 50%; transform: translate(-50%, -50%);"><?= ($row['nalichnost'] ?? 0 ) . ' ' . $_mqrkaItem ?>
                    </div>

                    <div class="position-relative mt-5 pt-1" style="bottom: 0; left: 50%; transform: translateX(-50%);">
                        <?php
                        if ($_gensoftJson -> kol_lock ?? null) {
                            echo '<small>запаз. - ' . $_gensoftJson -> kol_lock . $_mqrkaItem . '</small>';
                        }
                        ?>
                    </div>
                </td>

                <!--  брой -->
                <td class="qty position-relative align-middle text-center fw-500">
                    <div class="position-absolute w-90" style="top: 50%; left: 50%; transform: translate(-50%, -50%);"> 
                        <input class="qty css-input-p css-focus-strong css-border-none css-max-input-width text-center" 
                               name="baner[qtyPrice_json][<?= $row['product_id'] ?>][qty]" 
                               data-isNumeric  
                               type="text"  
                               value="<?= $_qtyPrice_json -> {$row['product_id']} -> qty ?? '' ?>"> 
                    </div>

                    <div class="position-relative mt-5 pt-1" style="bottom: 0; left: 50%; transform: translateX(-50%);">
                        <?= $_mqrkaItem ?>
                    </div>
                </td> 

                <!--  надценка -->
                <td class="nadz text-center align-middle fw-500"></td> 

                <!--  цена продава  -->
                <td class="zenaProdava position-relative align-middle text-center fw-400">
                    <?php
                    $_zenaProdava = null;
                    $_promoPrice  = null;
                    $_gsKKC       = h_toFixed($_gensoftJson -> KKC ?? null, $_isRoundedToFirst); // gensoft KKC 

                    if (isset($row['nivo'])) {
                        $_zenaProdava = h_toFixed($row['nivo'], $_isRoundedToFirst);
                    } elseif (isset($_qtyPrice_json -> {$row['product_id']} -> price)) {
                        $_zenaProdava = h_toFixed($_qtyPrice_json -> {$row['product_id']} -> price, $_isRoundedToFirst);
                    }

                    $_gPromoPercent = is_numeric($_gensoftJson -> promoPercent ?? null) ? (float) $_gensoftJson -> promoPercent : null; // gensoft промо % 

                    if ($_gPromoPercent && is_numeric($_gsKKC)) {
                        $_promoPrice = h_toFixed($_gsKKC * (1 + ($_gPromoPercent / 100)), $_isRoundedToFirst);
                    }
                    ?>
                    <div class="position-absolute w-90" style="top: 50%; left: 50%; transform: translate(-50%, -50%);">
                        <input class="zenaProdava css-input-p css-focus-strong css-border-none css-max-input-width text-center" 
                               name="baner[qtyPrice_json][<?= $row['product_id'] ?>][price]" 
                               data-isNumeric
                               type="text" 
                               value="<?= $priceType === 'gensoft' ? $_gsKKC : ($_zenaProdava ?? '') ?>"
                               <?= $priceType === 'gensoft' && !empty($row['gensoft_item_id']) ? 'disabled' : '' ?>>  
                    </div>

                    <div class="position-relative mt-5 pt-1" style="bottom: 0; left: 50%; transform: translateX(-50%);">
                        <?php if ($_promoPrice !== null && !empty($_gsKKC)): ?>
                            <small class="<?= $_gPromoPercent < 0 ? 'text-danger' : 'text-success' ?>">
                                <?= ($_gPromoPercent > 0 ? '+' : '') . $_promoPrice . '&nbsp;&nbsp;(' . $_gPromoPercent . '%)' ?>
                            </small>
                        <?php endif; ?>

                        <?php
                        $_route           = route_to('Promo-getPriceLevel');
                        $_btnPriceLvl     = '';
                        $_isEmptyPriceLvl = true; // Предполагаме, че всички нива са празни;
                        $_btn             = '';
                        foreach ($_priceLevels as $level => $label) {
                            if (!empty($row[$level])) {
                                $_btn .= "<button class='css-btn-wp' data-level='$level'
                                          data-product-id='{$row['product_id']}'
                                          data-route='$_route' type='button'>$label</button>";
                            }
                        }


                        if ($priceType !== 'gensoft' && $_btn) {
                            echo "<button class='css-btn-purple round-10 w-100'
                                  type='button' data-toggle='tooltip'
                                  title=\"<div id='priceLevel' class='d-flex gap-3'><span>Ценово ниво</span>$_btn</div>\">
                                  Ц. ниво
                                </button>";
                        }
                        ?>
                    </div>
                </td> 

                <!--  цена доставна -->
                <?php if ($priceType != 'gensoft') { ?>
                    <td class="zenaDostavna text-center align-middle css-background fw-500" data-base-price="<?= sprintf('%0.' . $_priceAccuracy . 'f', $row['price_dostavna']) ?>">
                        <?= sprintf('%0.' . $_priceAccuracy . 'f', $row['price_dostavna']) ?>
                    </td> 
                <? } ?>

                <!--  картинка -->
                <td class="productImage align-middle">
                    <?php
                    echo match ($row['badge_index']) {
                        '1' => '<div class="mb-1 text-center"><img class="w-50" src="' . $_ENV['app.imageDataDir'] . 'labels/new_label.png"></div>',
                        '2' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/feature_label.png"></div>',
                        '3' => '<div class="mb-1 text-center"><img class="w-50" src="' . $_ENV['app.imageDataDir'] . 'labels/hotSell.png"></div>',
                        '4' => '<div class = "mb-1 text-center"><img class = "w-50" src = "' . $_ENV['app.imageDataDir'] . 'labels/fix_label.png"></div>',
                        default => ''
                    };
                    ?>
                    <div class="d-flex">
                        <span class="<?= $row['image'] != '' ? 'fa fa-search-plus' : '' ?> position-absolute"></span>
                        <?php $_imgSrc = empty($row['image']) ? '' : $_ENV['app.imageCasheDir'] . $row['image'] . '/' . pathinfo($row['image'], PATHINFO_FILENAME) . '__150x150.' . pathinfo($row['image'], PATHINFO_EXTENSION) ?>
                        <img class="zoomImg mw-100 m-auto" src="<?= $_imgSrc ?>" data-full-image="<?= $_ENV['app.imageDir'] . $row['image'] ?>" onerror="this.onerror=null;this.src='';" alt=" ">  
                    </div>
                </td>         
            </tr> 
            <?php
            echo implode("", $_clRow);
        }
        ?> 
    </tbody> 
</table>
